/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pluginapi.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.util.stream.StreamUtil;

public class SnapshotReport {
    private static final Log log = LogFactory.getLog(SnapshotReport.class);
    public static final String REPORT_CONFIG_DIRECTORY = "config";
    public static final String REPORT_LOG_DIRECTORY = "log";
    public static final String REPORT_DATA_DIRECTORY = "data";
    public static final String PROP_SNAPSHOT_CONFIG_FILES = "snapshotConfigEnabled";
    public static final String PROP_CONFIG_DIRECTORY = "snapshotConfigDirectory";
    public static final String PROP_CONFIG_REGEX = "snapshotConfigRegex";
    public static final String PROP_CONFIG_RECURSIVE = "snapshotConfigRecursive";
    public static final String PROP_SNAPSHOT_LOG_FILES = "snapshotLogEnabled";
    public static final String PROP_LOG_DIRECTORY = "snapshotLogDirectory";
    public static final String PROP_LOG_REGEX = "snapshotLogRegex";
    public static final String PROP_LOG_RECURSIVE = "snapshotLogRecursive";
    public static final String PROP_SNAPSHOT_DATA_FILES = "snapshotDataEnabled";
    public static final String PROP_DATA_DIRECTORY = "snapshotDataDirectory";
    public static final String PROP_DATA_REGEX = "snapshotDataRegex";
    public static final String PROP_DATA_RECURSIVE = "snapshotDataRecursive";
    public static final String PROP_SNAPSHOT_ADDITIONAL_FILES = "snapshotAdditionalFilesEnabled";
    public static final String PROP_ADDITIONAL_FILES_LIST = "snapshotAdditionalFilesList";
    public static final String PROP_ADDITIONAL_FILES_DIRECTORY = "snapshotAdditionalFilesDirectory";
    public static final String PROP_ADDITIONAL_FILES_REGEX = "snapshotAdditionalFilesRegex";
    public static final String PROP_ADDITIONAL_FILES_RECURSIVE = "snapshotAdditionalFilesRecursive";
    public static final String PROP_BASE_DIRECTORY = "snapshotBaseDirectory";
    public static final String PROP_REPORT_OUTPUT_DIRECTORY = "snapshotReportOutputDirectory";
    private final String name;
    private final String description;
    private final Configuration configuration;

    public SnapshotReport(String name, String description, Configuration config) {
        this.name = name;
        this.description = description;
        this.configuration = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File generate() throws Exception {
        File outputFile = this.getSnapshotReportFile();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generating snapshot [" + outputFile + "]"));
        }
        FileOutputStream fos = new FileOutputStream(outputFile);
        ZipOutputStream zip = new ZipOutputStream(fos);
        try {
            ZipEntry zipEntry = new ZipEntry("snapshot.properties");
            zip.putNextEntry(zipEntry);
            Properties properties = new Properties();
            properties.setProperty("name", this.getName());
            properties.setProperty("description", this.getDescription());
            properties.setProperty("epochmillis", Long.toString(System.currentTimeMillis()));
            properties.store(zip, null);
            Map<String, URL> allFiles = this.getAllFilesToSnapshot();
            for (Map.Entry<String, URL> snapshotFileEntry : allFiles.entrySet()) {
                zipEntry = new ZipEntry(snapshotFileEntry.getKey());
                zip.putNextEntry(zipEntry);
                InputStream input = snapshotFileEntry.getValue().openStream();
                try {
                    StreamUtil.copy((InputStream)input, (OutputStream)zip, (boolean)false);
                }
                finally {
                    input.close();
                }
            }
        }
        finally {
            zip.close();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generated snapshot [" + outputFile + "] of size [" + outputFile.length() + "]"));
        }
        return outputFile;
    }

    protected String getName() {
        return this.name;
    }

    protected String getDescription() {
        return this.description;
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    protected File getSnapshotReportFile() throws Exception {
        String dirString = this.getConfiguration().getSimpleValue(PROP_REPORT_OUTPUT_DIRECTORY, null);
        File dir = null;
        if (dirString != null) {
            dir = new File(dirString);
            dir.mkdirs();
        }
        File outputFile = File.createTempFile(this.getName(), ".zip", dir);
        return outputFile;
    }

    protected Map<String, URL> getAllFilesToSnapshot() throws Exception {
        Map<String, URL> additionalFiles;
        Map<String, URL> dataFiles;
        Map<String, URL> logFiles;
        HashMap<String, URL> allFiles = new HashMap<String, URL>();
        Map<String, URL> configFiles = this.getConfigFilesToSnapshot();
        if (configFiles != null) {
            allFiles.putAll(configFiles);
        }
        if ((logFiles = this.getLogFilesToSnapshot()) != null) {
            allFiles.putAll(logFiles);
        }
        if ((dataFiles = this.getDataFilesToSnapshot()) != null) {
            allFiles.putAll(dataFiles);
        }
        if ((additionalFiles = this.getAdditionalFilesToSnapshot()) != null) {
            allFiles.putAll(additionalFiles);
        }
        return allFiles;
    }

    protected Map<String, URL> getConfigFilesToSnapshot() throws Exception {
        RegexFilenameFilter filter;
        File[] confFiles;
        Configuration config = this.getConfiguration();
        if (!"true".equals(config.getSimpleValue(PROP_SNAPSHOT_CONFIG_FILES, "false"))) {
            return null;
        }
        String baseDir = config.getSimpleValue(PROP_BASE_DIRECTORY, null);
        String confDir = config.getSimpleValue(PROP_CONFIG_DIRECTORY, "conf");
        String confRegex = config.getSimpleValue(PROP_CONFIG_REGEX, null);
        String recursive = config.getSimpleValue(PROP_CONFIG_RECURSIVE, "false");
        HashMap<String, URL> filesMap = null;
        File confDirFile = new File(confDir);
        if (!confDirFile.isAbsolute()) {
            confDirFile = new File(baseDir, confDir);
        }
        if ((confFiles = confDirFile.listFiles(filter = new RegexFilenameFilter(confRegex, recursive))) != null) {
            filesMap = new HashMap<String, URL>(confFiles.length);
            this.populateFilesMap(confFiles, filesMap, REPORT_CONFIG_DIRECTORY, filter);
        } else {
            log.warn((Object)("Failed to get list of conf files from [" + confDirFile + "]"));
        }
        return filesMap;
    }

    protected Map<String, URL> getLogFilesToSnapshot() throws Exception {
        RegexFilenameFilter filter;
        File[] logFiles;
        Configuration config = this.getConfiguration();
        if (!"true".equals(config.getSimpleValue(PROP_SNAPSHOT_LOG_FILES, "false"))) {
            return null;
        }
        String baseDir = config.getSimpleValue(PROP_BASE_DIRECTORY, null);
        String logDir = config.getSimpleValue(PROP_LOG_DIRECTORY, "logs");
        String logRegex = config.getSimpleValue(PROP_LOG_REGEX, null);
        String recursive = config.getSimpleValue(PROP_LOG_RECURSIVE, "false");
        HashMap<String, URL> filesMap = null;
        File logDirFile = new File(logDir);
        if (!logDirFile.isAbsolute()) {
            logDirFile = new File(baseDir, logDir);
        }
        if ((logFiles = logDirFile.listFiles(filter = new RegexFilenameFilter(logRegex, recursive))) != null) {
            filesMap = new HashMap<String, URL>(logFiles.length);
            this.populateFilesMap(logFiles, filesMap, REPORT_LOG_DIRECTORY, filter);
        } else {
            log.warn((Object)("Failed to get list of log files from [" + logDirFile + "]"));
        }
        return filesMap;
    }

    protected Map<String, URL> getDataFilesToSnapshot() throws Exception {
        RegexFilenameFilter filter;
        File[] dataFiles;
        Configuration config = this.getConfiguration();
        if (!"true".equals(config.getSimpleValue(PROP_SNAPSHOT_DATA_FILES, "false"))) {
            return null;
        }
        String baseDir = config.getSimpleValue(PROP_BASE_DIRECTORY, null);
        String dataDir = config.getSimpleValue(PROP_DATA_DIRECTORY, REPORT_DATA_DIRECTORY);
        String dataRegex = config.getSimpleValue(PROP_DATA_REGEX, null);
        String recursive = config.getSimpleValue(PROP_DATA_RECURSIVE, "false");
        HashMap<String, URL> filesMap = null;
        File dataDirFile = new File(dataDir);
        if (!dataDirFile.isAbsolute()) {
            dataDirFile = new File(baseDir, dataDir);
        }
        if ((dataFiles = dataDirFile.listFiles(filter = new RegexFilenameFilter(dataRegex, recursive))) != null) {
            filesMap = new HashMap<String, URL>(dataFiles.length);
            this.populateFilesMap(dataFiles, filesMap, REPORT_DATA_DIRECTORY, filter);
        } else {
            log.warn((Object)("Failed to get list of data files from [" + dataDirFile + "]"));
        }
        return filesMap;
    }

    protected Map<String, URL> getAdditionalFilesToSnapshot() throws Exception {
        Configuration config = this.getConfiguration();
        if (!"true".equals(config.getSimpleValue(PROP_SNAPSHOT_ADDITIONAL_FILES, "false"))) {
            return null;
        }
        String baseDir = config.getSimpleValue(PROP_BASE_DIRECTORY, null);
        PropertyList additionalList = config.getList(PROP_ADDITIONAL_FILES_LIST);
        if (additionalList == null || additionalList.getList() == null) {
            return null;
        }
        HashMap<String, URL> filesMap = new HashMap<String, URL>();
        for (Property property : additionalList.getList()) {
            String recursive;
            RegexFilenameFilter filter;
            File[] additionalFiles;
            PropertyMap additionalFileMap = (PropertyMap)property;
            String additionalFilesDir = additionalFileMap.getSimpleValue(PROP_ADDITIONAL_FILES_DIRECTORY, "");
            String additionalFilesRegex = additionalFileMap.getSimpleValue(PROP_ADDITIONAL_FILES_REGEX, null);
            String additionalFilesEnabled = additionalFileMap.getSimpleValue(PROP_SNAPSHOT_ADDITIONAL_FILES, "true");
            if (!"true".equals(additionalFilesEnabled)) continue;
            File additionalFilesDirFile = new File(additionalFilesDir);
            if (!additionalFilesDirFile.isAbsolute()) {
                additionalFilesDirFile = new File(baseDir, additionalFilesDir);
            }
            if ((additionalFiles = additionalFilesDirFile.listFiles(filter = new RegexFilenameFilter(additionalFilesRegex, recursive = additionalFileMap.getSimpleValue(PROP_ADDITIONAL_FILES_RECURSIVE, "false")))) != null) {
                this.populateFilesMap(additionalFiles, filesMap, additionalFilesDir, filter);
                continue;
            }
            log.warn((Object)("Failed to get list of additional files from [" + additionalFilesDirFile + "]"));
        }
        return filesMap;
    }

    private void populateFilesMap(File[] filesDirectories, Map<String, URL> filesMap, String directoryPrefix, RegexFilenameFilter filter) throws Exception {
        for (File fileDirectory : filesDirectories) {
            if (fileDirectory.isDirectory()) {
                File[] subDirectoryFiles = fileDirectory.listFiles(filter);
                if (subDirectoryFiles != null) {
                    this.populateFilesMap(subDirectoryFiles, filesMap, directoryPrefix + "/" + fileDirectory.getName(), filter);
                    continue;
                }
                log.warn((Object)("Failed to get subdirectory files for [" + fileDirectory + "]"));
                continue;
            }
            filesMap.put(directoryPrefix + '/' + fileDirectory.getName(), fileDirectory.toURI().toURL());
        }
    }

    protected static class RegexFilenameFilter
    implements FilenameFilter {
        private String regex;
        private boolean recursive;

        public RegexFilenameFilter(String regex, String recursive) {
            this.regex = regex;
            this.recursive = Boolean.parseBoolean(recursive);
        }

        @Override
        public boolean accept(File dir, String name) {
            if (new File(dir, name).isDirectory()) {
                return this.recursive;
            }
            return this.regex == null || name.matches(this.regex);
        }
    }
}

