/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc;

import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rhq.core.pc.ServerServices;
import org.rhq.core.pc.plugin.PluginFinder;
import org.rhq.core.pluginapi.inventory.PluginContainerDeployment;

public class PluginContainerConfiguration {
    private static final String PROP_PREFIX = "rhq.pc.";
    private static final String PLUGIN_FINDER_PROP = "rhq.pc.plugin-finder";
    private static final String PLUGIN_DIRECTORY_PROP = "rhq.pc.plugin-directory";
    private static final String IS_INSIDE_AGENT_PROP = "rhq.pc.is-inside-agent";
    private static final String CONTAINER_NAME_PROP = "rhq.pc.container-name";
    private static final String DATA_DIRECTORY_PROP = "rhq.pc.data-directory";
    private static final String TEMP_DIRECTORY_PROP = "rhq.pc.temp-directory";
    private static final String DISABLED_PLUGINS = "rhq.pc.disabled-plugins";
    private static final String ROOT_PLUGIN_CLASSLOADER_REGEX_PROP = "rhq.pc.root-plugin-classloader-regex";
    private static final String CREATE_RESOURCE_CLASSLOADERS = "rhq.pc.create-resource-classloaders";
    private static final String START_MANAGEMENT_BEAN_PROP = "rhq.pc.start-management-bean";
    private static final String WAIT_FOR_SHUTDOWN_SERVICE_TERMINATION = "rhq.pc.wait-for-shutdown-service-termination";
    public static final boolean WAIT_FOR_SHUTDOWN_SERVICE_TERMINATION_DEFAULT = false;
    private static final String SHUTDOWN_SERVICE_TERMINATION_TIMEOUT = "rhq.pc.shutdown-service-termination-timeout";
    public static final long SHUTDOWN_SERVICE_TERMINATION_TIMEOUT_DEFAULT = 300L;
    private static final String SERVER_DISCOVERY_INITIAL_DELAY_PROP = "rhq.pc.server-discovery-initial-delay";
    public static final long SERVER_DISCOVERY_INITIAL_DELAY_DEFAULT = 10L;
    private static final String SERVER_DISCOVERY_PERIOD_PROP = "rhq.pc.server-discovery-period";
    public static final long SERVER_DISCOVERY_PERIOD_DEFAULT = 900L;
    private static final String SERVICE_DISCOVERY_INITIAL_DELAY_PROP = "rhq.pc.service-discovery-initial-delay";
    public static final long SERVICE_DISCOVERY_INITIAL_DELAY_DEFAULT = 20L;
    private static final String SERVICE_DISCOVERY_PERIOD_PROP = "rhq.pc.service-discovery-period";
    public static final long SERVICE_DISCOVERY_PERIOD_DEFAULT = 86400L;
    private static final String CHILD_RESOURCE_DISCOVERY_DELAY_PROP = "rhq.pc.child-resource-discovery-delay";
    public static final long CHILD_RESOURCE_DISCOVERY_DELAY_DEFAULT = 5L;
    private static final String RESOURCE_FACTORY_CORE_POOL_SIZE_PROP = "rhq.pc.resource-factory-core-pool-size";
    public static final int RESOURCE_FACTORY_CORE_POOL_SIZE_DEFAULT = 1;
    private static final String RESOURCE_FACTORY_MAX_POOL_SIZE_PROP = "rhq.pc.resource-factory-max-pool-size";
    public static final int RESOURCE_FACTORY_MAX_POOL_SIZE_DEFAULT = 100;
    private static final String RESOURCE_FACTORY_KEEP_ALIVE_PROP = "rhq.pc.resource-factory-keep-alive";
    public static final int RESOURCE_FACTORY_KEEP_ALIVE_DEFAULT = 1000;
    private static final String AVAILABILITY_SCAN_INITIAL_DELAY_PROP = "rhq.pc.availability-scan-initial-delay";
    public static final long AVAILABILITY_SCAN_INITIAL_DELAY_DEFAULT = 5L;
    private static final String AVAILABILITY_SCAN_PERIOD_PROP = "rhq.pc.availability-scan-period";
    public static final long AVAILABILITY_SCAN_PERIOD_DEFAULT = 30L;
    private static final String MEASUREMENT_COLLECTION_INITIAL_DELAY_PROP = "rhq.pc.measurement-collection-initial-delay";
    public static final long MEASUREMENT_COLLECTION_INITIAL_DELAY_DEFAULT = 30L;
    private static final String MEASUREMENT_COLLECTION_THREADCOUNT_PROP = "rhq.pc.measurement-collection-threadpoolsize";
    public static final int MEASUREMENT_COLLECTION_THREADCOUNT_DEFAULT = 5;
    private static final String DRIFT_DETECTION_INITIAL_DELAY_PROP = "rhq.pc.drift-detection-initial-delay";
    public static final long DRIFT_DETECTION_INITIAL_DELAY_DEFAULT = 30L;
    private static final String DRIFT_DETECTION_PERIOD_PROP = "rhq.pc.drift-detection-period";
    public static final long DRIFT_DETECTION_PERIOD_DEFAULT = 60L;
    private static final String CONTENT_DISCOVERY_INITIAL_DELAY_PROP = "rhq.pc.content-discovery-initial-delay";
    public static final long CONTENT_DISCOVERY_INITIAL_DELAY_DEFAULT = 60L;
    private static final String CONTENT_DISCOVERY_PERIOD_PROP = "rhq.pc.content-discovery-period";
    public static final long CONTENT_DISCOVERY_PERIOD_DEFAULT = 30L;
    private static final String CONTENT_DISCOVERY_THREADCOUNT_PROP = "rhq.pc.content-discovery-threadpoolsize";
    public static final int CONTENT_DISCOVERY_THREADCOUNT_DEFAULT = 10;
    private static final String CONFIGURATION_DISCOVERY_INITIAL_DELAY_PROP = "rhq.pc.configuration-discovery-initial-delay";
    public static final long CONFIGURATION_DISCOVERY_INITIAL_DELAY_DEFAULT = 300L;
    private static final String CONFIGURATION_DISCOVERY_PERIOD_PROP = "rhq.pc.configuration-discovery-period";
    public static final long CONFIGURATION_DISCOVERY_PERIOD_DEFAULT = 3600L;
    private static final String OPERATION_INVOKER_THREADCOUNT_PROP = "rhq.pc.operation-invoker-threadpoolsize";
    public static final int OPERATION_INVOKER_THREADCOUNT_DEFAULT = 10;
    private static final String OPERATION_INVOCATION_TIMEOUT = "rhq.pc.operation-invocation-timeout";
    public static final long OPERATION_INVOCATION_TIMEOUT_DEFAULT = 600L;
    private static final String EVENT_SENDER_INITIAL_DELAY_PROP = "rhq.pc.event-sender-initial-delay";
    public static final long EVENT_SENDER_INITIAL_DELAY_DEFAULT = 30L;
    private static final String EVENT_SENDER_PERIOD_PROP = "rhq.pc.event-sender-period";
    public static final long EVENT_SENDER_PERIOD_DEFAULT = 30L;
    private static final String EVENT_REPORT_MAX_PER_SOURCE_PROP = "rhq.pc.event-report-max-per-source";
    public static final int EVENT_REPORT_MAX_PER_SOURCE_DEFAULT = 200;
    private static final String EVENT_REPORT_MAX_TOTAL_PROP = "rhq.pc.event-report-max-total";
    public static final int EVENT_REPORT_MAX_TOTAL_DEFAULT = 400;
    private ServerServices serverServices = null;
    private Map<String, Object> configuration = new HashMap<String, Object>();

    public File getPluginDirectory() {
        return (File)this.configuration.get(PLUGIN_DIRECTORY_PROP);
    }

    public void setPluginDirectory(File pluginDir) {
        this.configuration.put(PLUGIN_DIRECTORY_PROP, pluginDir);
    }

    public File getDataDirectory() {
        return (File)this.configuration.get(DATA_DIRECTORY_PROP);
    }

    public void setDataDirectory(File dataDir) {
        this.configuration.put(DATA_DIRECTORY_PROP, dataDir);
    }

    public File getTemporaryDirectory() {
        return (File)this.configuration.get(TEMP_DIRECTORY_PROP);
    }

    public void setTemporaryDirectory(File tmpDir) {
        this.configuration.put(TEMP_DIRECTORY_PROP, tmpDir);
    }

    public List<String> getDisabledPlugins() {
        List list = (List)this.configuration.get(DISABLED_PLUGINS);
        if (list == null) {
            return new ArrayList<String>(0);
        }
        return new ArrayList<String>(list);
    }

    public void setDisabledPlugins(List<String> disabledPlugins) {
        if (disabledPlugins != null) {
            this.configuration.put(DISABLED_PLUGINS, disabledPlugins);
        } else {
            this.configuration.remove(DISABLED_PLUGINS);
        }
    }

    public String getRootPluginClassLoaderRegex() {
        return (String)this.configuration.get(ROOT_PLUGIN_CLASSLOADER_REGEX_PROP);
    }

    public void setRootPluginClassLoaderRegex(String regex) {
        if (regex != null) {
            this.configuration.put(ROOT_PLUGIN_CLASSLOADER_REGEX_PROP, regex);
        } else {
            this.configuration.remove(ROOT_PLUGIN_CLASSLOADER_REGEX_PROP);
        }
    }

    public boolean isCreateResourceClassloaders() {
        Object val = this.configuration.get(CREATE_RESOURCE_CLASSLOADERS);
        if (val == null) {
            return this.isInsideAgent();
        }
        return (Boolean)val;
    }

    public void setCreateResourceClassloaders(boolean flag) {
        this.configuration.put(CREATE_RESOURCE_CLASSLOADERS, flag);
    }

    public boolean isStartManagementBean() {
        Object val = this.configuration.get(START_MANAGEMENT_BEAN_PROP);
        if (val == null) {
            return true;
        }
        return (Boolean)val;
    }

    public void setStartManagementBean(boolean value) {
        this.configuration.put(START_MANAGEMENT_BEAN_PROP, value);
    }

    public boolean isWaitForShutdownServiceTermination() {
        Boolean wait = (Boolean)this.configuration.get(WAIT_FOR_SHUTDOWN_SERVICE_TERMINATION);
        return wait == null ? false : wait;
    }

    public void setWaitForShutdownServiceTermination(boolean wait) {
        this.configuration.put(WAIT_FOR_SHUTDOWN_SERVICE_TERMINATION, wait);
    }

    public long getShutdownServiceTerminationTimeout() {
        Long timeout = (Long)this.configuration.get(SHUTDOWN_SERVICE_TERMINATION_TIMEOUT);
        return timeout == null ? 300L : timeout;
    }

    public void setShutdownServiceTerminationTimeout(long timeout) {
        this.configuration.put(SHUTDOWN_SERVICE_TERMINATION_TIMEOUT, timeout);
    }

    public long getAvailabilityScanInitialDelay() {
        Long period = (Long)this.configuration.get(AVAILABILITY_SCAN_INITIAL_DELAY_PROP);
        return period == null ? 5L : period;
    }

    public void setAvailabilityScanInitialDelay(long period) {
        this.configuration.put(AVAILABILITY_SCAN_INITIAL_DELAY_PROP, period);
    }

    public long getAvailabilityScanPeriod() {
        Long period = (Long)this.configuration.get(AVAILABILITY_SCAN_PERIOD_PROP);
        return period == null ? 30L : period;
    }

    public void setAvailabilityScanPeriod(long period) {
        this.configuration.put(AVAILABILITY_SCAN_PERIOD_PROP, period);
    }

    public long getMeasurementCollectionInitialDelay() {
        Long period = (Long)this.configuration.get(MEASUREMENT_COLLECTION_INITIAL_DELAY_PROP);
        return period == null ? 30L : period;
    }

    public void setMeasurementCollectionInitialDelay(long period) {
        this.configuration.put(MEASUREMENT_COLLECTION_INITIAL_DELAY_PROP, period);
    }

    public long getServerDiscoveryInitialDelay() {
        Long period = (Long)this.configuration.get(SERVER_DISCOVERY_INITIAL_DELAY_PROP);
        return period == null ? 10L : period;
    }

    public void setServerDiscoveryInitialDelay(long period) {
        this.configuration.put(SERVER_DISCOVERY_INITIAL_DELAY_PROP, period);
    }

    public long getServerDiscoveryPeriod() {
        Long period = (Long)this.configuration.get(SERVER_DISCOVERY_PERIOD_PROP);
        return period == null ? 900L : period;
    }

    public void setServerDiscoveryPeriod(long period) {
        this.configuration.put(SERVER_DISCOVERY_PERIOD_PROP, period);
    }

    public long getServiceDiscoveryInitialDelay() {
        Long period = (Long)this.configuration.get(SERVICE_DISCOVERY_INITIAL_DELAY_PROP);
        return period == null ? 20L : period;
    }

    public void setServiceDiscoveryInitialDelay(long period) {
        this.configuration.put(SERVICE_DISCOVERY_INITIAL_DELAY_PROP, period);
    }

    public long getServiceDiscoveryPeriod() {
        Long period = (Long)this.configuration.get(SERVICE_DISCOVERY_PERIOD_PROP);
        return period == null ? 86400L : period;
    }

    public void setServiceDiscoveryPeriod(long period) {
        this.configuration.put(SERVICE_DISCOVERY_PERIOD_PROP, period);
    }

    public long getChildResourceDiscoveryDelay() {
        Long delay = (Long)this.configuration.get(CHILD_RESOURCE_DISCOVERY_DELAY_PROP);
        return delay == null ? 5L : delay;
    }

    public void setChildResourceDiscoveryDelay(long delay) {
        this.configuration.put(CHILD_RESOURCE_DISCOVERY_DELAY_PROP, delay);
    }

    public PluginFinder getPluginFinder() {
        PluginFinder pluginFinder = (PluginFinder)this.configuration.get(PLUGIN_FINDER_PROP);
        return pluginFinder;
    }

    public void setPluginFinder(PluginFinder finder) {
        this.configuration.put(PLUGIN_FINDER_PROP, finder);
    }

    public int getMeasurementCollectionThreadPoolSize() {
        Integer size = (Integer)this.configuration.get(MEASUREMENT_COLLECTION_THREADCOUNT_PROP);
        return size == null ? 5 : size;
    }

    public void setMeasurementCollectionThreadPoolSize(int size) {
        this.configuration.put(MEASUREMENT_COLLECTION_THREADCOUNT_PROP, size);
    }

    public long getDriftDetectionInitialDelay() {
        Long delay = (Long)this.configuration.get(DRIFT_DETECTION_INITIAL_DELAY_PROP);
        return delay == null ? 30L : delay;
    }

    public void setDriftDetectionInitialDelay(long delay) {
        this.configuration.put(DRIFT_DETECTION_INITIAL_DELAY_PROP, delay);
    }

    public long getDriftDetectionPeriod() {
        Long period = (Long)this.configuration.get(DRIFT_DETECTION_PERIOD_PROP);
        return period == null ? 60L : period;
    }

    public void setDriftDetectionPeriod(long period) {
        this.configuration.put(DRIFT_DETECTION_PERIOD_PROP, period);
    }

    public long getContentDiscoveryInitialDelay() {
        Long delay = (Long)this.configuration.get(CONTENT_DISCOVERY_INITIAL_DELAY_PROP);
        return delay == null ? 60L : delay;
    }

    public void setContentDiscoveryInitialDelay(long delay) {
        this.configuration.put(CONTENT_DISCOVERY_INITIAL_DELAY_PROP, delay);
    }

    public long getContentDiscoveryPeriod() {
        Long period = (Long)this.configuration.get(CONTENT_DISCOVERY_PERIOD_PROP);
        return period == null ? 30L : period;
    }

    public void setContentDiscoveryPeriod(long period) {
        this.configuration.put(CONTENT_DISCOVERY_PERIOD_PROP, period);
    }

    public int getContentDiscoveryThreadPoolSize() {
        Integer size = (Integer)this.configuration.get(CONTENT_DISCOVERY_THREADCOUNT_PROP);
        return size == null ? 10 : size;
    }

    public void setContentDiscoveryThreadPoolSize(int size) {
        this.configuration.put(CONTENT_DISCOVERY_THREADCOUNT_PROP, size);
    }

    public long getConfigurationDiscoveryInitialDelay() {
        Long delay = (Long)this.configuration.get(CONFIGURATION_DISCOVERY_INITIAL_DELAY_PROP);
        return delay == null ? 300L : delay;
    }

    public void setConfigurationDiscoveryInitialDelay(long delay) {
        this.configuration.put(CONFIGURATION_DISCOVERY_INITIAL_DELAY_PROP, delay);
    }

    public long getConfigurationDiscoveryPeriod() {
        Long period = (Long)this.configuration.get(CONFIGURATION_DISCOVERY_PERIOD_PROP);
        return period == null ? 3600L : period;
    }

    public void setConfigurationDiscoveryPeriod(long period) {
        this.configuration.put(CONFIGURATION_DISCOVERY_PERIOD_PROP, period);
    }

    public int getOperationInvokerThreadPoolSize() {
        Integer size = (Integer)this.configuration.get(OPERATION_INVOKER_THREADCOUNT_PROP);
        return size == null ? 10 : size;
    }

    public void setOperationInvokerThreadPoolSize(int size) {
        this.configuration.put(OPERATION_INVOKER_THREADCOUNT_PROP, size);
    }

    public long getOperationInvocationTimeout() {
        Long timeout = (Long)this.configuration.get(OPERATION_INVOCATION_TIMEOUT);
        return timeout == null ? 600L : timeout;
    }

    public void setOperationInvocationTimeout(long timeout) {
        this.configuration.put(OPERATION_INVOCATION_TIMEOUT, timeout);
    }

    public long getEventSenderInitialDelay() {
        Long delay = (Long)this.configuration.get(EVENT_SENDER_INITIAL_DELAY_PROP);
        return delay == null ? 30L : delay;
    }

    public void setEventSenderInitialDelay(long delay) {
        this.configuration.put(EVENT_SENDER_INITIAL_DELAY_PROP, delay);
    }

    public long getEventSenderPeriod() {
        Long period = (Long)this.configuration.get(EVENT_SENDER_PERIOD_PROP);
        return period == null ? 30L : period;
    }

    public void setEventSenderPeriod(long period) {
        this.configuration.put(EVENT_SENDER_PERIOD_PROP, period);
    }

    public int getEventReportMaxPerSource() {
        Integer value = (Integer)this.configuration.get(EVENT_REPORT_MAX_PER_SOURCE_PROP);
        return value == null ? 200 : value;
    }

    public void setEventReportMaxPerSource(int value) {
        this.configuration.put(EVENT_REPORT_MAX_PER_SOURCE_PROP, value);
    }

    public int getEventReportMaxTotal() {
        Integer value = (Integer)this.configuration.get(EVENT_REPORT_MAX_TOTAL_PROP);
        return value == null ? 400 : value;
    }

    public void setEventReportMaxTotal(int value) {
        this.configuration.put(EVENT_REPORT_MAX_TOTAL_PROP, value);
    }

    public void setResourceFactoryCoreThreadPoolSize(int size) {
        this.configuration.put(RESOURCE_FACTORY_CORE_POOL_SIZE_PROP, size);
    }

    public int getResourceFactoryCoreThreadPoolSize() {
        Integer size = (Integer)this.configuration.get(RESOURCE_FACTORY_CORE_POOL_SIZE_PROP);
        return size == null ? 1 : size;
    }

    public void setResourceFactoryMaxThreadPoolSize(int size) {
        this.configuration.put(RESOURCE_FACTORY_MAX_POOL_SIZE_PROP, size);
    }

    public int getResourceFactoryMaxThreadPoolSize() {
        Integer size = (Integer)this.configuration.get(RESOURCE_FACTORY_MAX_POOL_SIZE_PROP);
        return size == null ? 100 : size;
    }

    public void setResourceFactoryKeepAliveTime(int time) {
        this.configuration.put(RESOURCE_FACTORY_KEEP_ALIVE_PROP, time);
    }

    public int getResourceFactoryKeepAliveTime() {
        Integer time = (Integer)this.configuration.get(RESOURCE_FACTORY_KEEP_ALIVE_PROP);
        return time == null ? 1000 : time;
    }

    public String getContainerName() {
        String fqdn = (String)this.configuration.get(CONTAINER_NAME_PROP);
        if (fqdn == null) {
            try {
                fqdn = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (Exception e) {
                fqdn = null;
            }
        }
        return fqdn;
    }

    public void setContainerName(String name) {
        this.configuration.put(CONTAINER_NAME_PROP, name);
    }

    public ServerServices getServerServices() {
        return this.serverServices;
    }

    public void setServerServices(ServerServices serverServices) {
        this.serverServices = serverServices;
    }

    public boolean isInsideAgent() {
        Object val = this.configuration.get(IS_INSIDE_AGENT_PROP);
        if (val == null) {
            return false;
        }
        return (Boolean)val;
    }

    public PluginContainerDeployment getPluginContainerDeployment() {
        if (this.isInsideAgent()) {
            return PluginContainerDeployment.AGENT;
        }
        return PluginContainerDeployment.EMBEDDED;
    }

    public void setInsideAgent(boolean flag) {
        this.configuration.put(IS_INSIDE_AGENT_PROP, flag);
    }

    public String toString() {
        return this.configuration.toString();
    }

    public static String getDefaultClassLoaderFilter() {
        StringBuilder defaultRegex = new StringBuilder();
        defaultRegex.append("(javax\\.xml\\.bind\\..*)|");
        defaultRegex.append("(com\\.sun\\.activation\\..*)|");
        defaultRegex.append("(com\\.sun\\.istack\\..*)|");
        defaultRegex.append("(com\\.sun\\.xml\\..*)|");
        defaultRegex.append("(org\\.apache\\.commons\\.httpclient\\..*)|");
        defaultRegex.append("(org\\.jboss\\.logging\\..*)|");
        defaultRegex.append("(org\\.jboss\\.net\\..*)|");
        defaultRegex.append("(org\\.jboss\\.util\\..*)|");
        defaultRegex.append("(org\\.jboss\\.dom4j\\..*)|");
        defaultRegex.append("(org\\.jboss\\.mx\\..*)|");
        defaultRegex.append("(org\\.jboss\\.remoting\\..*)|");
        defaultRegex.append("(org\\.jboss\\.serial\\..*)|");
        defaultRegex.append("(org\\.dom4j\\..*)|");
        defaultRegex.append("(EDU\\.oswego\\..*)|");
        defaultRegex.append("(gnu\\.getopt\\..*)|");
        defaultRegex.append("(javax\\.persistence\\..*)|");
        defaultRegex.append("(org\\.rhq\\.core\\.clientapi\\..*)|");
        defaultRegex.append("(org\\.rhq\\.core\\.communications\\..*)|");
        defaultRegex.append("(org\\.rhq\\.core\\.pc\\..*)|");
        defaultRegex.append("(org\\.rhq\\.enterprise\\.communications\\.(?!command\\.server\\.CommandProcessorMetrics.*).*)");
        String clRegex = defaultRegex.toString();
        return clRegex;
    }
}

