/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.configuration;

import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.configuration.ConfigurationUpdateRequest;
import org.rhq.core.clientapi.server.configuration.ConfigurationServerService;
import org.rhq.core.clientapi.server.configuration.ConfigurationUpdateResponse;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pc.configuration.ConfigManagement;
import org.rhq.core.pc.configuration.ConfigurationUpdateException;
import org.rhq.core.pc.configuration.ConfigurationUtilityService;
import org.rhq.core.pc.configuration.ConfigurationUtilityServiceImpl;
import org.rhq.core.pc.configuration.UpdateInProgressException;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;

public class UpdateResourceConfigurationRunner
implements Runnable,
Callable<ConfigurationUpdateResponse> {
    private final Log log = LogFactory.getLog(UpdateResourceConfigurationRunner.class);
    private ConfigurationUpdateRequest request;
    private ConfigManagement configMgmt;
    private ConfigurationFacet configurationFacet;
    private ResourceType resourceType;
    private ConfigurationServerService configurationServerService;
    private ConfigurationUtilityService configUtilService = new ConfigurationUtilityServiceImpl();

    public UpdateResourceConfigurationRunner(ConfigurationServerService configurationServerService, ResourceType type, ConfigManagement configMgmt, ConfigurationUpdateRequest request) {
        this.configurationServerService = configurationServerService;
        this.resourceType = type;
        this.configMgmt = configMgmt;
        this.request = request;
    }

    ConfigurationUpdateRequest getRequest() {
        return this.request;
    }

    ConfigManagement getConfigMgmt() {
        return this.configMgmt;
    }

    ResourceType getResourceType() {
        return this.resourceType;
    }

    ConfigurationServerService getConfigurationServerService() {
        return this.configurationServerService;
    }

    ConfigurationUtilityService getConfigUtilService() {
        return this.configUtilService;
    }

    void setConfigUtilService(ConfigurationUtilityService service) {
        this.configUtilService = service;
    }

    @Override
    public void run() {
        try {
            this.call();
        }
        catch (Exception e) {
            this.log.error((Object)"Error while chaining run to call", (Throwable)e);
        }
    }

    @Override
    public ConfigurationUpdateResponse call() throws Exception {
        ConfigurationUpdateResponse response;
        int requestId = this.request.getConfigurationUpdateId();
        try {
            response = new ConfigurationUpdateResponse(requestId, this.request.getConfiguration(), ConfigurationUpdateStatus.SUCCESS, null);
            try {
                this.configMgmt.executeUpdate(this.request.getResourceId(), this.request.getConfiguration());
            }
            catch (UpdateInProgressException e) {
                response.setStatus(ConfigurationUpdateStatus.INPROGRESS);
                response.setErrorMessage("Configuration facet did not indicate success or failure - assuming failure.");
            }
            catch (ConfigurationUpdateException e) {
                response.setStatus(ConfigurationUpdateStatus.FAILURE);
                response.setErrorMessage(e.getMessage());
            }
            ConfigurationDefinition configurationDefinition = this.resourceType.getResourceConfigurationDefinition();
            this.configUtilService.normalizeConfiguration(response.getConfiguration(), configurationDefinition);
            List<String> errorMessages = this.configUtilService.validateConfiguration(response.getConfiguration(), configurationDefinition);
            for (String errorMessage : errorMessages) {
                this.log.warn((Object)("Plugin Error: Invalid " + this.resourceType.getName() + " Resource configuration returned by " + this.resourceType.getPlugin() + " plugin - " + errorMessage));
            }
            if (response.getStatus() == ConfigurationUpdateStatus.SUCCESS) {
                response.setConfiguration(null);
            }
        }
        catch (Throwable t) {
            this.log.error((Object)("Plugin Error: Exception thrown while updating Resource configuration for " + this.resourceType.getName() + " Resource with id [" + this.request.getResourceId() + "]."), t);
            response = new ConfigurationUpdateResponse(requestId, this.request.getConfiguration(), t);
        }
        if (this.configurationServerService != null) {
            this.configurationServerService.completeConfigurationUpdate(response);
        }
        return response;
    }
}

