/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.content;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.server.content.ContentServerService;
import org.rhq.core.clientapi.server.content.DeployPackagesRequest;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.transfer.ContentResponseResult;
import org.rhq.core.domain.content.transfer.DeployIndividualPackageResponse;
import org.rhq.core.domain.content.transfer.DeployPackagesResponse;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.content.ContentManager;
import org.rhq.core.pc.inventory.InventoryManager;
import org.rhq.core.pc.util.ComponentUtil;
import org.rhq.core.util.exception.ThrowableUtil;

public class CreateContentRunner
implements Runnable,
Callable<DeployPackagesResponse> {
    private final Log log = LogFactory.getLog(CreateContentRunner.class);
    private ContentManager contentManager;
    private DeployPackagesRequest request;

    public CreateContentRunner(ContentManager contentManager, DeployPackagesRequest request) {
        this.contentManager = contentManager;
        this.request = request;
    }

    @Override
    public void run() {
        try {
            this.call();
        }
        catch (Exception e) {
            this.log.error((Object)"Create content runner failed", (Throwable)e);
        }
    }

    @Override
    public DeployPackagesResponse call() throws Exception {
        ContentServerService serverService;
        DeployPackagesResponse response;
        try {
            response = this.contentManager.performPackageDeployment(this.request.getResourceId(), this.request.getPackages());
        }
        catch (Throwable throwable) {
            response = new DeployPackagesResponse(ContentResponseResult.FAILURE);
            response.setOverallRequestErrorMessage(ThrowableUtil.getStackAsString((Throwable)throwable));
        }
        response.setRequestId(this.request.getRequestId());
        Set packageResponses = response.getPackageResponses();
        if (packageResponses != null) {
            HashSet<String> packageTypeNames = new HashSet<String>();
            for (DeployIndividualPackageResponse individualResponse : packageResponses) {
                String packageTypeName;
                PackageDetailsKey key = individualResponse.getKey();
                if (key == null || packageTypeNames.contains(packageTypeName = key.getPackageTypeName())) continue;
                packageTypeNames.add(packageTypeName);
                try {
                    this.contentManager.executeResourcePackageDiscoveryImmediately(this.request.getResourceId(), individualResponse.getKey().getPackageTypeName());
                }
                catch (Throwable throwable) {
                    this.log.error((Object)("Error occurred on content discovery request" + throwable));
                }
            }
        }
        if ((serverService = this.contentManager.getContentServerService()) != null) {
            serverService.completeDeployPackageRequest(response);
        }
        if (response.getOverallRequestResult() == ContentResponseResult.SUCCESS) {
            try {
                ResourceType resourceType = ComponentUtil.getResourceType(this.request.getResourceId());
                InventoryManager inventoryManager = PluginContainer.getInstance().getInventoryManager();
                if (this.executeServerScan(resourceType)) {
                    inventoryManager.executeServerScanImmediately();
                }
                inventoryManager.executeServiceScanImmediately();
            }
            catch (Throwable throwable) {
                this.log.warn((Object)("Error occurred on resource discovery request" + throwable));
            }
        }
        return response;
    }

    private boolean executeServerScan(ResourceType resourceType) {
        boolean execute = resourceType.getCategory() == ResourceCategory.PLATFORM || resourceType.getCategory() == ResourceCategory.SERVER && resourceType.getParentResourceTypes().isEmpty();
        return execute;
    }
}

