/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.drift;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.common.drift.ChangeSetReader;
import org.rhq.common.drift.FileEntry;
import org.rhq.common.drift.Headers;
import org.rhq.core.domain.drift.DriftFile;
import org.rhq.core.pc.drift.ChangeSetManager;
import org.rhq.core.pc.drift.DriftClient;
import org.rhq.core.util.stream.StreamUtil;

public class DriftFilesSender
implements Runnable {
    private Log log = LogFactory.getLog(DriftFilesSender.class);
    private int resourceId;
    private Headers headers;
    private List<? extends DriftFile> driftFiles;
    private ChangeSetManager changeSetMgr;
    private DriftClient driftClient;

    public void setResourceId(int resourceId) {
        this.resourceId = resourceId;
    }

    public void setHeaders(Headers headers) {
        this.headers = headers;
    }

    public void setDriftFiles(List<? extends DriftFile> driftFiles) {
        this.driftFiles = driftFiles;
    }

    public void setDriftClient(DriftClient driftClient) {
        this.driftClient = driftClient;
    }

    public void setChangeSetManager(ChangeSetManager changeSetManager) {
        this.changeSetMgr = changeSetManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ZipOutputStream stream = null;
        int numContentFiles = 0;
        try {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Preparing to send content to server for " + this.defToString()));
            }
            long startTime = System.currentTimeMillis();
            File changeSet = this.changeSetMgr.findChangeSet(this.resourceId, this.headers.getDriftDefinitionName());
            File changeSetDir = changeSet.getParentFile();
            String timestamp = Long.toString(System.currentTimeMillis());
            String contentFileName = "content_" + timestamp + ".zip";
            File zipFile = new File(changeSetDir, contentFileName);
            stream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));
            if (this.driftFiles.size() == 1) {
                DriftFile driftFile = this.driftFiles.get(0);
                File file = this.find(driftFile);
                if (file == null || !file.exists()) {
                    this.log.warn((Object)("Unable to find file for " + driftFile));
                } else {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Adding " + file.getPath() + " to " + contentFileName));
                    }
                    this.addFileToContentZipFile(stream, driftFile, file);
                    ++numContentFiles;
                }
            } else {
                Map<String, FileEntry> fileEntries = this.createSnapshotIndex();
                for (DriftFile driftFile : this.driftFiles) {
                    FileEntry entry = fileEntries.get(driftFile.getHashId());
                    if (entry == null) continue;
                    File file = new File(this.headers.getBasedir(), entry.getFile());
                    if (file == null || !file.exists()) {
                        this.log.warn((Object)("Unable to find file for " + driftFile));
                        continue;
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Adding " + file.getPath() + " to " + contentFileName));
                    }
                    this.addFileToContentZipFile(stream, driftFile, file);
                    ++numContentFiles;
                }
            }
            if (numContentFiles > 0) {
                this.driftClient.sendChangeSetContentToServer(this.resourceId, this.headers.getDriftDefinitionName(), zipFile);
            }
            stream.close();
            stream = null;
            if (this.log.isInfoEnabled()) {
                long endTime = System.currentTimeMillis();
                this.log.info((Object)("Finished submitting request to send content to server in " + (endTime - startTime) + " ms"));
            }
        }
        catch (IOException e) {
            if (numContentFiles > 0) {
                this.log.error((Object)"Failed to send drift files.", (Throwable)e);
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFileToContentZipFile(ZipOutputStream stream, DriftFile driftFile, File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            stream.putNextEntry(new ZipEntry(driftFile.getHashId()));
            StreamUtil.copy((InputStream)fis, (OutputStream)stream, (boolean)false);
        }
        finally {
            fis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File find(DriftFile driftFile) throws IOException {
        ChangeSetReader reader = this.changeSetMgr.getChangeSetReader(this.resourceId, this.headers.getDriftDefinitionName());
        try {
            for (FileEntry entry : reader) {
                if (!entry.getNewSHA().equals(driftFile.getHashId())) continue;
                File file = new File(this.headers.getBasedir(), entry.getFile());
                return file;
            }
            File file = null;
            return file;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, FileEntry> createSnapshotIndex() throws IOException {
        ChangeSetReader reader = this.changeSetMgr.getChangeSetReader(this.resourceId, this.headers.getDriftDefinitionName());
        try {
            TreeMap<String, FileEntry> map = new TreeMap<String, FileEntry>();
            for (FileEntry entry : reader) {
                map.put(entry.getNewSHA(), entry);
            }
            TreeMap<String, FileEntry> treeMap = map;
            return treeMap;
        }
        finally {
            reader.close();
        }
    }

    private String defToString() {
        return "[resourceId: " + this.resourceId + ", driftDefinitionId: " + this.headers.getDriftDefinitionId() + ", driftDefinitionName: " + this.headers.getDriftDefinitionName() + "]";
    }
}

