/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.drift.sync;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.drift.DriftDefinition;
import org.rhq.core.domain.drift.DriftDefinitionComparator;
import org.rhq.core.pc.drift.DriftDetectionSchedule;
import org.rhq.core.pc.drift.DriftManager;
import org.rhq.core.pc.drift.ScheduleQueue;
import org.rhq.core.pc.drift.sync.DriftSynchronizer;

class RuntimeSynchronizer
implements DriftSynchronizer {
    private final Log log = LogFactory.getLog(RuntimeSynchronizer.class);
    private DriftManager driftMgr;

    public RuntimeSynchronizer(DriftManager driftManager) {
        this.driftMgr = driftManager;
    }

    @Override
    public List<DriftDefinition> getDeletedDefinitions(int resourceId, Set<DriftDefinition> definitionsFromServer) {
        this.log.debug((Object)("Checking for drift definitions that need to be deleted for resource id " + resourceId));
        LinkedList<DriftDefinition> deleted = new LinkedList<DriftDefinition>();
        ScheduleQueue queue = this.driftMgr.getSchedulesQueue();
        for (DriftDetectionSchedule schedule : this.getSchedulesForResource(resourceId, queue.toArray())) {
            if (definitionsFromServer.contains(schedule.getDriftDefinition())) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Detected stale drift definition that needs to be purged - " + this.toString(resourceId, schedule.getDriftDefinition())));
            }
            deleted.add(schedule.getDriftDefinition());
        }
        return deleted;
    }

    @Override
    public void purgeFromLocalInventory(int resourceId, List<DriftDefinition> definitions) {
        this.log.debug((Object)("Preparing to unschedule drift detection and purge from local inventory drift definitions that have been deleted on the server for resource id " + resourceId));
        for (DriftDefinition c : definitions) {
            this.driftMgr.unscheduleDriftDetection(resourceId, c);
        }
    }

    @Override
    public List<DriftDefinition> getAddedDefinitions(int resourceId, Set<DriftDefinition> definitionsFromServer) {
        this.log.debug((Object)("Checking for drift definitions that need to be added for resource id " + resourceId));
        ScheduleQueue queue = this.driftMgr.getSchedulesQueue();
        DriftDefinitionComparator comparator = new DriftDefinitionComparator(DriftDefinitionComparator.CompareMode.BOTH_BASE_INFO_AND_DIRECTORY_SPECIFICATIONS);
        LinkedList<DriftDefinition> added = new LinkedList<DriftDefinition>();
        for (DriftDefinition c : definitionsFromServer) {
            if (queue.contains(resourceId, c, comparator)) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Detected new drift definition that needs to be added to local inventory - " + this.toString(resourceId, c)));
            }
            added.add(c);
        }
        return added;
    }

    @Override
    public void addToLocalInventory(int resourceId, List<DriftDefinition> definitions) {
        this.log.debug((Object)("Adding drift definitions to local inventory and creating drift detection schedules for resource id " + resourceId));
        for (DriftDefinition c : definitions) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Adding " + this.toString(resourceId, c) + " to local inventory"));
            }
            this.driftMgr.scheduleDriftDetection(resourceId, c);
        }
    }

    @Override
    public void syncChangeSetContent() {
        this.driftMgr.scanForContentToResend();
    }

    private String toString(int rid, DriftDefinition c) {
        return "DriftDefinition[id: " + c.getId() + ", name: " + c.getName() + ", resourceId: " + rid + "]";
    }

    private List<DriftDetectionSchedule> getSchedulesForResource(int resourceId, DriftDetectionSchedule[] schedules) {
        LinkedList<DriftDetectionSchedule> resourceSchedules = new LinkedList<DriftDetectionSchedule>();
        for (DriftDetectionSchedule s : schedules) {
            if (s.getResourceId() != resourceId) continue;
            resourceSchedules.add(s);
        }
        return resourceSchedules;
    }
}

