/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.inventory;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.server.discovery.InventoryReport;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.PluginContainerConfiguration;
import org.rhq.core.pc.inventory.AvailabilityExecutor;
import org.rhq.core.pc.inventory.InventoryManager;
import org.rhq.core.pc.inventory.ResourceContainer;
import org.rhq.core.pc.plugin.PluginComponentFactory;
import org.rhq.core.pc.util.FacetLockType;
import org.rhq.core.pluginapi.availability.AvailabilityFacet;
import org.rhq.core.pluginapi.inventory.ProcessScanResult;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.util.exception.ExceptionPackage;
import org.rhq.core.util.exception.Severity;

public class RuntimeDiscoveryExecutor
implements Runnable,
Callable<InventoryReport> {
    private Log log = LogFactory.getLog(RuntimeDiscoveryExecutor.class);
    private InventoryManager inventoryManager;
    private PluginContainerConfiguration pluginContainerConfiguration;
    private Resource rootResource;

    public RuntimeDiscoveryExecutor(InventoryManager inventoryManager, PluginContainerConfiguration pluginContainerConfiguration) {
        this.inventoryManager = inventoryManager;
        this.pluginContainerConfiguration = pluginContainerConfiguration;
    }

    public RuntimeDiscoveryExecutor(InventoryManager inventoryManager, PluginContainerConfiguration pluginContainerConfiguration, Resource rootResource) {
        this(inventoryManager, pluginContainerConfiguration);
        this.rootResource = rootResource;
    }

    @Override
    public void run() {
        this.call();
    }

    @Override
    @NotNull
    public InventoryReport call() {
        String target = this.rootResource != null ? this.rootResource.toString() : "platform";
        this.log.info((Object)("Executing runtime discovery scan rooted at [" + target + "]..."));
        InventoryReport report = new InventoryReport(this.inventoryManager.getAgent());
        try {
            report.setRuntimeReport(true);
            report.setStartTime(System.currentTimeMillis());
            this.runtimeDiscover(report);
            report.setEndTime(System.currentTimeMillis());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Runtime discovery scan took %d ms.", report.getEndTime() - report.getStartTime()));
            }
            this.log.info((Object)("Scanned platform and " + report.getAddedRoots().size() + " server(s) and discovered " + (report.getResourceCount() - report.getAddedRoots().size()) + " new descendant Resource(s)."));
            if (this.log.isTraceEnabled()) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(10000);
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(report);
                this.log.trace((Object)("Runtime report contains " + report.getResourceCount() + " Resources with a size of " + baos.size() + " bytes"));
            }
            this.inventoryManager.handleReport(report);
        }
        catch (Exception e) {
            this.log.warn((Object)("Exception caught while executing runtime discovery scan rooted at [" + target + "]."), (Throwable)e);
            report.addError(new ExceptionPackage(Severity.Warning, (Throwable)e));
        }
        return report;
    }

    private void runtimeDiscover(InventoryReport report) throws PluginContainerException {
        if (this.rootResource == null) {
            Resource platform = this.inventoryManager.getPlatform();
            this.discoverForResource(platform, report, false);
        } else {
            this.discoverForResource(this.rootResource, report, false);
        }
    }

    private void discoverForResource(Resource parent, InventoryReport report, boolean parentReported) throws PluginContainerException {
        AvailabilityType currentAvailabilityType;
        this.log.debug((Object)("Discovering child Resources for " + parent + "..."));
        ResourceContainer parentContainer = this.inventoryManager.getResourceContainer(parent);
        if (parentContainer == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Cannot perform service scan on parent [" + parent + "] without a container"));
            }
            return;
        }
        if (parentContainer.getResourceComponentState() != ResourceContainer.ResourceComponentState.STARTED) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Parent [" + parent + "] is not STARTED - not performing service scan"));
            }
            return;
        }
        if (parent.getInventoryStatus() != InventoryStatus.COMMITTED) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Parent [" + parent + "] must be imported/committed before service scan can run."));
            }
            return;
        }
        Set childResourceTypes = parent.getResourceType().getChildResourceTypes();
        if ((null == childResourceTypes || childResourceTypes.isEmpty()) && parent.getChildResources().isEmpty()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Parent resource type [" + parent + "] has no child types; cannot perform service scan."));
            }
            return;
        }
        Availability currentAvailability = parentContainer.getAvailability();
        AvailabilityType availabilityType = currentAvailabilityType = null == currentAvailability ? AvailabilityType.DOWN : currentAvailability.getAvailabilityType();
        if (AvailabilityType.UP != currentAvailabilityType || ResourceCategory.SERVER == parentContainer.getResource().getResourceType().getCategory()) {
            AvailabilityFacet parentComponent = null;
            try {
                parentComponent = parentContainer.createResourceComponentProxy(AvailabilityFacet.class, FacetLockType.NONE, AvailabilityExecutor.GET_AVAILABILITY_TIMEOUT, true, false);
            }
            catch (PluginContainerException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Parent component for [" + parent + "] was null; cannot perform service scan."));
                }
                return;
            }
            try {
                currentAvailabilityType = parentComponent.getAvailability();
            }
            catch (Exception e) {
                currentAvailabilityType = AvailabilityType.DOWN;
            }
        }
        if (AvailabilityType.UP != currentAvailabilityType) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Availability of [" + parent + "] is not UP, cannot perform service scan on it."));
            }
            return;
        }
        PluginComponentFactory factory = PluginContainer.getInstance().getPluginComponentFactory();
        try {
            for (ResourceType childResourceType : childResourceTypes) {
                ResourceDiscoveryComponent discoveryComponent = null;
                try {
                    discoveryComponent = factory.getDiscoveryComponent(childResourceType, parentContainer);
                }
                catch (PluginContainerException pce) {
                    this.log.error((Object)("Unable to obtain discovery component for [" + childResourceType + "]"), (Throwable)pce);
                }
                if (discoveryComponent == null) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)("Resource not discoverable, no component found: " + childResourceType));
                    continue;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Running service scan on parent resource [" + parent + "] looking for children of type [" + childResourceType + "]"));
                }
                Set<Resource> discoveredChildResources = this.inventoryManager.executeComponentDiscovery(childResourceType, discoveryComponent, parentContainer, Collections.<ProcessScanResult>emptyList());
                HashMap<String, Resource> mergedResources = new HashMap<String, Resource>();
                for (Resource discoveredChildResource : discoveredChildResources) {
                    Resource mergedResource = this.inventoryManager.mergeResourceFromDiscovery(discoveredChildResource, parent);
                    mergedResources.put(mergedResource.getUuid(), mergedResource);
                    if (mergedResource.getId() != 0 || parentReported) continue;
                    report.addAddedRoot(parent);
                    parentReported = true;
                }
                this.removeStaleResources(parent, childResourceType, mergedResources);
            }
            for (Resource childResource : parent.getChildResources()) {
                this.discoverForResource(childResource, report, parentReported);
            }
        }
        catch (Throwable t) {
            report.getErrors().add(new ExceptionPackage(Severity.Severe, t));
            this.log.error((Object)"Error in runtime discovery", t);
        }
    }

    private void removeStaleResources(Resource parent, ResourceType childResourceType, Map<String, Resource> mergedResources) {
        Set existingChildResources = parent.getChildResources();
        for (Resource existingChildResource : existingChildResources) {
            if (!existingChildResource.getResourceType().equals((Object)childResourceType) || mergedResources.containsKey(existingChildResource.getUuid()) || existingChildResource.getId() != 0 && this.pluginContainerConfiguration.isInsideAgent()) continue;
            this.log.info((Object)("Removing stale resource [" + existingChildResource + "]"));
            this.inventoryManager.removeResourceAndIndicateIfScanIsNeeded(existingChildResource);
        }
    }
}

