/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.measurement;

import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.measurement.MeasurementAgentService;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementData;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.measurement.NumericType;
import org.rhq.core.domain.measurement.ResourceMeasurementScheduleRequest;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pc.ContainerService;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.PluginContainerConfiguration;
import org.rhq.core.pc.agent.AgentService;
import org.rhq.core.pc.inventory.InventoryManager;
import org.rhq.core.pc.inventory.ResourceContainer;
import org.rhq.core.pc.measurement.MeasurementCollectorRunner;
import org.rhq.core.pc.measurement.MeasurementManagerMBean;
import org.rhq.core.pc.measurement.MeasurementSenderRunner;
import org.rhq.core.pc.measurement.ScheduledMeasurementInfo;
import org.rhq.core.pc.util.ComponentUtil;
import org.rhq.core.pc.util.FacetLockType;
import org.rhq.core.pc.util.LoggingThreadFactory;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;

public class MeasurementManager
extends AgentService
implements MeasurementAgentService,
ContainerService,
MeasurementManagerMBean {
    public static final String OBJECT_NAME = "rhq.pc:type=MeasurementManager";
    private static final String COLLECTOR_THREAD_POOL_NAME = "MeasurementManager.collector";
    private static final String SENDER_THREAD_POOL_NAME = "MeasurementManager.sender";
    static final int FACET_METHOD_TIMEOUT = 30000;
    static final Log LOG = LogFactory.getLog(MeasurementManager.class);
    private ScheduledThreadPoolExecutor collectorThreadPool;
    private ScheduledThreadPoolExecutor senderThreadPool;
    private MeasurementSenderRunner measurementSenderRunner;
    MeasurementCollectorRunner measurementCollectorRunner;
    private PluginContainerConfiguration configuration;
    private PriorityQueue<ScheduledMeasurementInfo> scheduledRequests = new PriorityQueue(10000);
    private InventoryManager inventoryManager;
    private Map<Integer, String> traitCache = new HashMap<Integer, String>();
    private Map<Integer, CachedValue> perMinuteCache = new HashMap<Integer, CachedValue>();
    private MeasurementReport activeReport = new MeasurementReport();
    private ReentrantReadWriteLock measurementLock = new ReentrantReadWriteLock(true);
    private AtomicLong collectedMeasurements = new AtomicLong(0L);
    private AtomicLong totalTimeCollecting = new AtomicLong(0L);
    private AtomicLong sinceLastCollectedMeasurements = new AtomicLong(0L);
    private AtomicLong sinceLastCollectedTime = new AtomicLong(System.currentTimeMillis());
    private AtomicLong lateCollections = new AtomicLong(0L);
    private AtomicLong failedCollection = new AtomicLong(0L);

    public MeasurementManager() {
        super(MeasurementAgentService.class);
    }

    @Override
    public void initialize() {
        LOG.info((Object)"Initializing Measurement Manager...");
        if (this.configuration.isStartManagementBean()) {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            try {
                server.registerMBean(this, new ObjectName(OBJECT_NAME));
            }
            catch (JMException e) {
                LOG.error((Object)"Unable to register MeasurementManagerMBean", (Throwable)e);
            }
        }
        this.inventoryManager = PluginContainer.getInstance().getInventoryManager();
        int threadPoolSize = this.configuration.getMeasurementCollectionThreadPoolSize();
        long collectionInitialDelaySecs = this.configuration.getMeasurementCollectionInitialDelay();
        if (this.configuration.isInsideAgent()) {
            this.collectorThreadPool = new ScheduledThreadPoolExecutor(threadPoolSize, new LoggingThreadFactory(COLLECTOR_THREAD_POOL_NAME, true));
            this.senderThreadPool = new ScheduledThreadPoolExecutor(2, new LoggingThreadFactory(SENDER_THREAD_POOL_NAME, true));
            this.measurementSenderRunner = new MeasurementSenderRunner(this);
            this.measurementCollectorRunner = new MeasurementCollectorRunner(this);
            this.senderThreadPool.scheduleAtFixedRate(this.measurementSenderRunner, collectionInitialDelaySecs, 30L, TimeUnit.SECONDS);
            this.collectorThreadPool.schedule(new MeasurementCollectionRequester(), collectionInitialDelaySecs, TimeUnit.SECONDS);
            Resource platform = this.inventoryManager.getPlatform();
            this.reschedule(platform);
        }
        LOG.info((Object)"Measurement Manager initialized.");
    }

    private void reschedule(Resource resource) {
        ResourceContainer container;
        int resourceId;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("In Reschedule for: " + resource));
        }
        if ((resourceId = resource.getId()) != 0 && (container = this.inventoryManager.getResourceContainer(resourceId)) != null) {
            Set<MeasurementScheduleRequest> schedules = container.getMeasurementSchedule();
            if (schedules != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Rescheduling: " + resource.getId()));
                }
                this.scheduleCollection(resourceId, schedules);
            }
            for (Resource child : this.inventoryManager.getContainerChildren(resource, container)) {
                this.reschedule(child);
            }
        }
    }

    public MeasurementReport getActiveReport() {
        if (this.activeReport == null) {
            this.activeReport = new MeasurementReport();
        }
        return this.activeReport;
    }

    ReentrantReadWriteLock getLock() {
        return this.measurementLock;
    }

    public boolean checkTrait(int scheduleId, String traitValue) {
        if (this.traitCache.containsKey(scheduleId)) {
            String historic = this.traitCache.get(scheduleId);
            if (historic == null && traitValue != null || historic != null && !historic.equals(traitValue)) {
                this.traitCache.put(scheduleId, traitValue);
                return true;
            }
            return false;
        }
        this.traitCache.put(scheduleId, traitValue);
        return true;
    }

    public String getCachedTraitValue(int scheduleId) {
        return this.traitCache.get(scheduleId);
    }

    public void perMinuteItizeData(MeasurementReport report) {
        Iterator iter = report.getNumericData().iterator();
        while (iter.hasNext()) {
            MeasurementData d = (MeasurementData)iter.next();
            MeasurementDataNumeric numeric = (MeasurementDataNumeric)d;
            if (!numeric.isPerMinuteCollection()) continue;
            Double perMinuteValue = this.updatePerMinuteMetric(numeric);
            if (perMinuteValue == null) {
                iter.remove();
                continue;
            }
            numeric.setValue(perMinuteValue);
        }
    }

    @Override
    public void shutdown() {
        PluginContainer pluginContainer = PluginContainer.getInstance();
        if (this.collectorThreadPool != null) {
            LOG.debug((Object)"Shutting down measurement collector thread pool...");
            pluginContainer.shutdownExecutorService(this.collectorThreadPool, true);
        }
        if (this.senderThreadPool != null) {
            LOG.debug((Object)"Shutting down measurement sender thread pool...");
            pluginContainer.shutdownExecutorService(this.senderThreadPool, true);
        }
        if (this.configuration.isStartManagementBean()) {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            try {
                server.unregisterMBean(new ObjectName(OBJECT_NAME));
            }
            catch (JMException e) {
                LOG.warn((Object)"Unable to unregister MeasurementManagerMBean", (Throwable)e);
            }
        }
    }

    @Override
    public void setConfiguration(PluginContainerConfiguration configuration) {
        this.configuration = configuration;
    }

    public synchronized void updateCollection(Set<ResourceMeasurementScheduleRequest> scheduleRequests) {
        InventoryManager im = PluginContainer.getInstance().getInventoryManager();
        for (ResourceMeasurementScheduleRequest resourceRequest : scheduleRequests) {
            ResourceContainer resourceContainer = im.getResourceContainer(resourceRequest.getResourceId());
            if (resourceContainer != null) {
                resourceContainer.updateMeasurementSchedule(resourceRequest.getMeasurementSchedules());
                this.scheduleCollection(resourceRequest.getResourceId(), resourceRequest.getMeasurementSchedules());
                continue;
            }
            LOG.trace((Object)("Resource container was null - could not schedule collection for resource " + resourceRequest.getResourceId()));
        }
        this.clearDuplicateSchedules();
    }

    public synchronized void scheduleCollection(Set<ResourceMeasurementScheduleRequest> scheduleRequests) {
        InventoryManager im = PluginContainer.getInstance().getInventoryManager();
        for (ResourceMeasurementScheduleRequest resourceRequest : scheduleRequests) {
            ResourceContainer resourceContainer = im.getResourceContainer(resourceRequest.getResourceId());
            if (resourceContainer != null) {
                resourceContainer.setMeasurementSchedule(resourceRequest.getMeasurementSchedules());
                resourceContainer.setAvailabilitySchedule(resourceRequest.getAvailabilitySchedule());
                this.scheduleCollection(resourceRequest.getResourceId(), resourceRequest.getMeasurementSchedules());
                continue;
            }
            LOG.debug((Object)("Resource container was null, could not schedule collection for resource " + resourceRequest.getResourceId()));
        }
        this.clearDuplicateSchedules();
    }

    public synchronized void scheduleCollection(int resourceId, Set<MeasurementScheduleRequest> requests) {
        long firstCollection = System.currentTimeMillis();
        firstCollection = this.configuration != null ? (firstCollection += this.configuration.getMeasurementCollectionInitialDelay() * 1000L) : (firstCollection += 30000L);
        for (MeasurementScheduleRequest request : requests) {
            ScheduledMeasurementInfo info = new ScheduledMeasurementInfo(request, resourceId);
            info.setNextCollection(firstCollection);
            this.scheduledRequests.remove(info);
            if (!info.isEnabled()) continue;
            this.scheduledRequests.offer(info);
        }
    }

    public synchronized void unscheduleCollection(Set<Integer> resourceIds) {
        Iterator<ScheduledMeasurementInfo> itr = this.scheduledRequests.iterator();
        while (itr.hasNext()) {
            ScheduledMeasurementInfo info = itr.next();
            if (!resourceIds.contains(info.getResourceId())) continue;
            itr.remove();
        }
    }

    private void clearDuplicateSchedules() {
        HashSet<Integer> set = new HashSet<Integer>(this.scheduledRequests.size());
        Iterator<ScheduledMeasurementInfo> iter = this.scheduledRequests.iterator();
        while (iter.hasNext()) {
            ScheduledMeasurementInfo info = iter.next();
            if (set.contains(info.getScheduleId())) {
                LOG.debug((Object)("Found duplicate schedule - will remove it: " + info));
                iter.remove();
                continue;
            }
            set.add(info.getScheduleId());
        }
    }

    public Set<MeasurementData> getRealTimeMeasurementValue(int resourceId, Set<MeasurementScheduleRequest> requests) {
        MeasurementFacet measurementFacet;
        if (requests.size() == 0) {
            return Collections.emptySet();
        }
        ResourceContainer resourceContainer = PluginContainer.getInstance().getInventoryManager().getResourceContainer(resourceId);
        if (resourceContainer == null) {
            LOG.warn((Object)("Can not get resource container for resource with id " + resourceId));
            return Collections.emptySet();
        }
        Resource resource = resourceContainer.getResource();
        ResourceType resourceType = resource.getResourceType();
        if (resourceType.getMetricDefinitions().isEmpty()) {
            return Collections.emptySet();
        }
        try {
            measurementFacet = ComponentUtil.getComponent(resourceId, MeasurementFacet.class, FacetLockType.READ, 30000L, true, true);
        }
        catch (Exception e) {
            LOG.warn((Object)("Cannot get measurement facet for Resource [" + resourceId + "]. Cause: " + e));
            return Collections.emptySet();
        }
        MeasurementReport report = new MeasurementReport();
        for (MeasurementScheduleRequest request : requests) {
            request.setEnabled(true);
        }
        try {
            measurementFacet.getValues(report, Collections.unmodifiableSet(requests));
        }
        catch (Throwable t) {
            LOG.error((Object)"Could not get measurement values", t);
            return Collections.emptySet();
        }
        Iterator iterator = report.getNumericData().iterator();
        while (iterator.hasNext()) {
            MeasurementDataNumeric numeric = (MeasurementDataNumeric)iterator.next();
            if (!numeric.isPerMinuteCollection()) continue;
            CachedValue currentValue = this.perMinuteCache.get(numeric.getScheduleId());
            if (currentValue == null) {
                iterator.remove();
                continue;
            }
            numeric.setValue(this.calculatePerMinuteValue(numeric, currentValue));
        }
        HashSet<MeasurementData> values = new HashSet<MeasurementData>();
        values.addAll(report.getNumericData());
        values.addAll(report.getTraitData());
        return values;
    }

    @Override
    public long getNextExpectedCollectionTime() {
        ScheduledMeasurementInfo nextScheduledMeasurement = this.scheduledRequests.peek();
        if (nextScheduledMeasurement == null) {
            return Long.MIN_VALUE;
        }
        return nextScheduledMeasurement.getNextCollection();
    }

    public synchronized Set<ScheduledMeasurementInfo> getNextScheduledSet() {
        ScheduledMeasurementInfo first = this.scheduledRequests.peek();
        if (first == null || first.getNextCollection() > System.currentTimeMillis()) {
            return null;
        }
        HashSet<ScheduledMeasurementInfo> nextScheduledSet = new HashSet<ScheduledMeasurementInfo>();
        ScheduledMeasurementInfo next = this.scheduledRequests.peek();
        while (next != null && next.getResourceId() == first.getResourceId() && next.getNextCollection() == first.getNextCollection()) {
            nextScheduledSet.add(this.scheduledRequests.poll());
            next = this.scheduledRequests.peek();
        }
        return nextScheduledSet;
    }

    public synchronized void reschedule(Set<ScheduledMeasurementInfo> scheduledMeasurementInfos) {
        this.reschedule(scheduledMeasurementInfos, 0L);
    }

    public synchronized void reschedule(Set<ScheduledMeasurementInfo> scheduledMeasurementInfos, long adjustment) {
        for (ScheduledMeasurementInfo scheduledMeasurement : scheduledMeasurementInfos) {
            scheduledMeasurement.setNextCollection(scheduledMeasurement.getNextCollection() + scheduledMeasurement.getInterval() + adjustment);
            this.scheduledRequests.offer(scheduledMeasurement);
        }
    }

    public void sendMeasurementReport(MeasurementReport report) {
        this.collectedMeasurements.addAndGet(report.getDataCount());
        this.sinceLastCollectedMeasurements.addAndGet(report.getDataCount());
        this.totalTimeCollecting.addAndGet(report.getCollectionTime());
        if (this.configuration.getServerServices() != null) {
            try {
                this.configuration.getServerServices().getMeasurementServerService().mergeMeasurementReport(report);
            }
            catch (Exception e) {
                LOG.warn((Object)"Failure to report measurements to server", (Throwable)e);
            }
        }
    }

    private Double updatePerMinuteMetric(MeasurementDataNumeric numeric) {
        CachedValue previousValue = this.perMinuteCache.get(numeric.getScheduleId());
        this.perMinuteCache.put(numeric.getScheduleId(), new CachedValue(numeric.getTimestamp(), numeric.getValue()));
        return this.calculatePerMinuteValue(numeric, previousValue);
    }

    private Double calculatePerMinuteValue(MeasurementDataNumeric numeric, CachedValue currentValue) {
        Double perMinuteValue = null;
        if (currentValue != null) {
            long timeDifference = numeric.getTimestamp() - currentValue.timestamp;
            perMinuteValue = 60000.0 / (double)timeDifference * (numeric.getValue() - currentValue.value);
            if (numeric.getRawNumericType() == NumericType.TRENDSDOWN) {
                perMinuteValue = perMinuteValue * -1.0;
            }
            if (perMinuteValue < 0.0) {
                perMinuteValue = null;
            }
        }
        return perMinuteValue;
    }

    public Map<String, Object> getMeasurementScheduleInfoForResource(int resourceId) {
        HashMap<String, String> results = null;
        for (ScheduledMeasurementInfo info : new PriorityQueue<ScheduledMeasurementInfo>(this.scheduledRequests)) {
            if (info.getResourceId() != resourceId) continue;
            if (results == null) {
                results = new HashMap<String, String>();
            }
            String scheduleId = String.valueOf(info.getScheduleId());
            String interval = String.valueOf(info.getInterval()) + "ms";
            results.put(scheduleId, interval);
        }
        return results;
    }

    public String getTraitValue(ResourceContainer container, String traitName) {
        Integer traitScheduleId = null;
        Set<MeasurementScheduleRequest> schedules = container.getMeasurementSchedule();
        for (MeasurementScheduleRequest schedule : schedules) {
            if (!schedule.getName().equals(traitName)) continue;
            if (schedule.getDataType() != DataType.TRAIT) {
                throw new IllegalArgumentException("Measurement named [" + traitName + "] for resource [" + container.getResource().getName() + "] is not a trait, it is of type [" + schedule.getDataType() + "]");
            }
            traitScheduleId = schedule.getScheduleId();
        }
        if (traitScheduleId == null) {
            throw new IllegalArgumentException("There is no trait [" + traitName + "] for resource [" + container.getResource().getName() + "]");
        }
        String traitValue = this.getCachedTraitValue(traitScheduleId);
        if (traitValue == null) {
            Object value;
            HashSet<MeasurementScheduleRequest> requests = new HashSet<MeasurementScheduleRequest>();
            requests.add(new MeasurementScheduleRequest(1, traitName, 0L, true, DataType.TRAIT));
            Set<MeasurementData> dataset = this.getRealTimeMeasurementValue(container.getResource().getId(), requests);
            if (dataset != null && dataset.size() == 1 && (value = dataset.iterator().next().getValue()) != null) {
                traitValue = value.toString();
            }
        }
        return traitValue;
    }

    @Override
    public long getMeasurementsCollected() {
        return this.collectedMeasurements.get();
    }

    @Override
    public long getMeasurementsCollectedPerMinute() {
        long now = System.currentTimeMillis();
        if (now - this.sinceLastCollectedTime.get() > 60000L) {
            this.sinceLastCollectedTime.set(now);
            this.sinceLastCollectedMeasurements.set(0L);
        }
        if (now - this.sinceLastCollectedTime.get() == 0L) {
            return 0L;
        }
        long collectionTimeInMinutes = (now - this.sinceLastCollectedTime.get()) / 1000L / 60L;
        if (collectionTimeInMinutes == 0L) {
            return 0L;
        }
        long ret = this.sinceLastCollectedMeasurements.get() / collectionTimeInMinutes;
        return ret;
    }

    @Override
    public long getCurrentlyScheduleMeasurements() {
        return this.scheduledRequests.size();
    }

    @Override
    public long getTotalTimeCollectingMeasurements() {
        return this.totalTimeCollecting.get();
    }

    @Override
    public long getLateCollections() {
        return this.lateCollections.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MeasurementReport swapReport() {
        try {
            this.measurementLock.writeLock().lock();
            MeasurementReport previousReport = this.activeReport;
            this.activeReport = new MeasurementReport();
            MeasurementReport measurementReport = previousReport;
            return measurementReport;
        }
        finally {
            this.measurementLock.writeLock().unlock();
        }
    }

    void incrementLateCollections(int count) {
        this.lateCollections.addAndGet(count);
    }

    void incrementFailedCollections(int count) {
        this.failedCollection.addAndGet(count);
    }

    @Override
    public long getFailedCollections() {
        return this.failedCollection.get();
    }

    private static class CachedValue {
        long timestamp;
        double value;

        CachedValue(long timestamp, double value) {
            this.timestamp = timestamp;
            this.value = value;
        }
    }

    class MeasurementCollectionRequester
    implements Runnable {
        MeasurementCollectionRequester() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!MeasurementManager.this.collectorThreadPool.isShutdown()) {
                    long next = MeasurementManager.this.getNextExpectedCollectionTime();
                    if (next == Long.MIN_VALUE) {
                        Thread.sleep(10000L);
                        continue;
                    }
                    long delay = next - System.currentTimeMillis();
                    if (delay <= 0L) {
                        MeasurementManager.this.measurementCollectorRunner.call();
                        continue;
                    }
                    if (MeasurementManager.this.collectorThreadPool.isShutdown()) continue;
                    Thread.sleep(delay);
                }
            }
            catch (InterruptedException e) {
            }
            catch (Throwable e) {
                LOG.error((Object)"Measurement collection shutting down due to error", e);
            }
            finally {
                LOG.info((Object)"Shutting down measurement collection...");
            }
        }
    }
}

