/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.util;

import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.inventory.InventoryManager;
import org.rhq.core.pc.inventory.ResourceContainer;
import org.rhq.core.pc.util.FacetLockType;
import org.rhq.core.pluginapi.inventory.ResourceComponent;

public class ComponentUtil {
    public static ResourceType getResourceType(int resourceId) throws PluginContainerException {
        InventoryManager inventoryManager = PluginContainer.getInstance().getInventoryManager();
        ResourceContainer resourceContainer = inventoryManager.getResourceContainer(resourceId);
        if (resourceContainer == null) {
            throw new PluginContainerException("Resource component container could not be retrieved for resource: " + resourceId);
        }
        return resourceContainer.getResource().getResourceType();
    }

    public static <T> T getComponent(int resourceId, Class<T> facetInterface, FacetLockType lockType, long timeout, boolean daemonThread, boolean onlyIfStarted) throws PluginContainerException {
        InventoryManager inventoryManager = PluginContainer.getInstance().getInventoryManager();
        ResourceContainer resourceContainer = inventoryManager.getResourceContainer(resourceId);
        if (resourceContainer == null) {
            throw new PluginContainerException("Resource component container could not be retrieved for resource: " + resourceId);
        }
        return resourceContainer.createResourceComponentProxy(facetInterface, lockType, timeout, daemonThread, onlyIfStarted);
    }

    public static ResourceComponent fetchResourceComponent(int resourceId) {
        return PluginContainer.getInstance().getInventoryManager().getResourceContainer(resourceId).getResourceComponent();
    }
}

