/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.init;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.seam.init.ComponentDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyManager {
    private Map<String, Set<ComponentDescriptor>> componentDescriptors;
    private Set<ComponentDescriptor> currentTestSet;
    private Set<ComponentDescriptor> installedSet;
    private static final Comparator<ComponentDescriptor> ORDER = new Comparator<ComponentDescriptor>(){

        @Override
        public int compare(ComponentDescriptor x, ComponentDescriptor y) {
            return x.getName().compareTo(y.getName());
        }
    };

    public DependencyManager(Map<String, Set<ComponentDescriptor>> componentDescriptors) {
        this.componentDescriptors = new HashMap<String, Set<ComponentDescriptor>>(componentDescriptors);
    }

    public Set<ComponentDescriptor> installedSet() {
        this.computeInstallSet();
        return this.installedSet;
    }

    private void computeInstallSet() {
        this.installedSet = new TreeSet<ComponentDescriptor>(ORDER);
        Set<String> keys = this.componentDescriptors.keySet();
        for (String key : keys) {
            this.currentTestSet = new HashSet<ComponentDescriptor>();
            if (this.tryToInstall(key)) {
                this.installedSet.addAll(this.currentTestSet);
            }
            this.currentTestSet = null;
        }
    }

    private boolean tryToInstall(String key) {
        Set<ComponentDescriptor> descriptors = this.componentDescriptors.get(key);
        if (descriptors == null) {
            return false;
        }
        for (ComponentDescriptor descriptor : descriptors) {
            HashSet<ComponentDescriptor> saved = new HashSet<ComponentDescriptor>(this.currentTestSet);
            if (this.tryToInstall(descriptor)) {
                return true;
            }
            this.currentTestSet = saved;
        }
        return false;
    }

    private boolean tryToInstall(ComponentDescriptor descriptor) {
        if (this.isInInstallSet(descriptor.getName())) {
            return true;
        }
        this.currentTestSet.add(descriptor);
        return this.checkAllDependencies(descriptor);
    }

    private boolean checkAllDependencies(ComponentDescriptor descriptor) {
        return descriptor.isInstalled() && this.checkClassDependencies(descriptor) && this.checkComponentDependencies(descriptor) && this.checkGenericDependencies(descriptor);
    }

    private boolean checkComponentDependencies(ComponentDescriptor descriptor) {
        String[] dependencies = descriptor.getDependencies();
        if (dependencies == null) {
            return true;
        }
        for (String componentName : dependencies) {
            if (this.tryToInstall(componentName)) continue;
            return false;
        }
        return true;
    }

    private boolean checkClassDependencies(ComponentDescriptor descriptor) {
        String[] classDependencies = descriptor.getClassDependencies();
        if (classDependencies == null) {
            return true;
        }
        for (String className : classDependencies) {
            try {
                descriptor.getComponentClass().getClassLoader().loadClass(className);
            }
            catch (NoClassDefFoundError e) {
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    private boolean checkGenericDependencies(ComponentDescriptor descriptor) {
        Class[] dependencies = descriptor.getGenericDependencies();
        if (dependencies == null) {
            return true;
        }
        for (Class dependency : dependencies) {
            Set<String> searchList;
            if (this.isInInstallSet(dependency) || this.tryToSatisfyDependencyUsing(dependency, searchList = this.findPotentialComponents(dependency))) continue;
            return false;
        }
        return true;
    }

    private boolean tryToSatisfyDependencyUsing(Class dependency, Set<String> searchList) {
        for (String componentName : searchList) {
            HashSet<ComponentDescriptor> saved = new HashSet<ComponentDescriptor>(this.currentTestSet);
            if (this.tryToInstall(componentName) && this.isInInstallSet(dependency)) {
                return true;
            }
            this.currentTestSet = saved;
        }
        return false;
    }

    private Set<String> findPotentialComponents(Class dependency) {
        HashSet<String> keys = new HashSet<String>();
        for (String candidateKey : this.componentDescriptors.keySet()) {
            if (!this.componentMightSatisfy(candidateKey, dependency)) continue;
            keys.add(candidateKey);
        }
        return keys;
    }

    private boolean componentMightSatisfy(String candidateKey, Class dependency) {
        for (ComponentDescriptor descriptor : this.componentDescriptors.get(candidateKey)) {
            if (!descriptor.getComponentClass().equals(dependency)) continue;
            return true;
        }
        return false;
    }

    private boolean isInInstallSet(Class dependency) {
        for (ComponentDescriptor descriptor : this.currentTestSet) {
            if (!dependency.equals(descriptor.getComponentClass())) continue;
            return true;
        }
        for (ComponentDescriptor descriptor : this.installedSet) {
            if (!dependency.equals(descriptor.getComponentClass())) continue;
            return true;
        }
        return false;
    }

    private boolean isInInstallSet(String key) {
        for (ComponentDescriptor descriptor : this.currentTestSet) {
            if (!key.equals(descriptor.getName())) continue;
            return true;
        }
        for (ComponentDescriptor descriptor : this.installedSet) {
            if (!key.equals(descriptor.getName())) continue;
            return true;
        }
        return false;
    }
}

