/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.Map;
import java.util.Properties;

public class PropertiesFileUpdate {
    private static final String CHAR_ENCODING_8859_1 = "8859_1";
    private File file;

    public PropertiesFileUpdate(String location) {
        this.file = new File(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(String key, String value) throws IOException {
        Properties existingProps;
        block10: {
            if (value == null) {
                value = "";
            }
            if (!(existingProps = this.loadExistingProperties()).containsKey(key)) {
                boolean appendNewlineBeforeAppendingProperty = this.file.exists() && this.file.length() != 0L && !this.isFileLineSeparatorTerminated();
                FileOutputStream fos = new FileOutputStream(this.file, true);
                try {
                    PrintStream ps = new PrintStream((OutputStream)fos, true, CHAR_ENCODING_8859_1);
                    try {
                        if (appendNewlineBeforeAppendingProperty) {
                            ps.println();
                        }
                        ps.println(key + "=" + value);
                        break block10;
                    }
                    finally {
                        ps.close();
                    }
                }
                finally {
                    fos.close();
                }
            }
            if (!value.equals(existingProps.getProperty(key))) {
                Properties newProps = new Properties();
                newProps.setProperty(key, value);
                this.update(newProps);
            }
        }
        return existingProps.containsKey(key);
    }

    public void update(Properties newProps) throws IOException {
        Properties propsToUpdate = new Properties();
        propsToUpdate.putAll((Map<?, ?>)newProps);
        Properties existingProps = this.loadExistingProperties();
        for (Map.Entry<Object, Object> entry : newProps.entrySet()) {
            if (!entry.getValue().equals(existingProps.get(entry.getKey()))) continue;
            propsToUpdate.remove(entry.getKey());
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)baos, true, CHAR_ENCODING_8859_1);
        InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(this.file), CHAR_ENCODING_8859_1);
        BufferedReader in = new BufferedReader(isr);
        String line = in.readLine();
        while (line != null) {
            int equalsSign = line.indexOf(61);
            if (line.startsWith("#") || line.trim().length() == 0 || equalsSign < 0) {
                out.println(line);
            } else {
                String existingKey = line.substring(0, equalsSign);
                if (!propsToUpdate.containsKey(existingKey = this.trimString(existingKey, false, true))) {
                    out.println(line);
                } else {
                    out.println(existingKey + "=" + propsToUpdate.getProperty(existingKey));
                    propsToUpdate.remove(existingKey);
                }
            }
            line = in.readLine();
        }
        in.close();
        for (Map.Entry<Object, Object> entry : propsToUpdate.entrySet()) {
            out.println(entry.getKey() + "=" + entry.getValue());
        }
        out.close();
        FileOutputStream fos = new FileOutputStream(this.file, false);
        fos.write(baos.toByteArray());
        fos.flush();
        fos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadExistingProperties() throws IOException {
        Properties props = new Properties();
        if (this.file.exists() && this.file.length() != 0L) {
            FileInputStream is = new FileInputStream(this.file);
            try {
                props.load(is);
            }
            finally {
                is.close();
            }
        }
        return props;
    }

    private String trimString(String str, boolean trimStart, boolean trimEnd) {
        int start;
        int end = str.length();
        if (trimStart) {
            for (start = 0; start < end && str.charAt(start) == ' '; ++start) {
            }
        }
        if (trimEnd) {
            while (start < end && str.charAt(end - 1) == ' ') {
                --end;
            }
        }
        return start > 0 || end < str.length() ? str.substring(start, end) : str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFileLineSeparatorTerminated() throws IOException {
        int lastByteOfFile;
        if (!this.file.exists() || this.file.length() == 0L) {
            return false;
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.file, "r");
        try {
            randomAccessFile.seek(this.file.length() - 1L);
            lastByteOfFile = randomAccessFile.read();
        }
        finally {
            randomAccessFile.close();
        }
        boolean fileIsLineSeparatorTerminated = false;
        if (lastByteOfFile == 10 || lastByteOfFile == 13 && "\r".equals(System.getProperty("line.separator"))) {
            fileIsLineSeparatorTerminated = true;
        }
        return fileIsLineSeparatorTerminated;
    }
}

