/*
 * Decompiled with CFR 0.152.
 */
package com.jboss.jbossnetwork.product.jbpm.handlers;

import com.jboss.jbossnetwork.product.jbpm.handlers.ControlActionFacade;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.operation.OperationServicesResult;
import org.rhq.core.pluginapi.operation.OperationServicesResultCode;
import org.rhq.plugins.jbossas.JBossASServerComponent;
import org.rhq.plugins.jbossas.JBossASServerOperationsDelegate;
import org.rhq.plugins.jbossas.JBossASServerSupportedOperations;

public class InPluginControlActionFacade
implements ControlActionFacade {
    private JBossASServerComponent serverComponent;
    private JBossASServerOperationsDelegate operationsDelegate;
    private final Log log = LogFactory.getLog(this.getClass());

    public InPluginControlActionFacade(JBossASServerComponent serverComponent) {
        this.serverComponent = serverComponent;
        this.operationsDelegate = serverComponent.getOperationsDelegate();
    }

    public OperationServicesResult start() {
        try {
            this.operationsDelegate.invoke(JBossASServerSupportedOperations.START, null);
        }
        catch (InterruptedException e) {
            this.log.error((Object)"Start interrupted", (Throwable)e);
        }
        OperationServicesResultCode code = this.serverComponent.getAvailability() == AvailabilityType.UP ? OperationServicesResultCode.SUCCESS : OperationServicesResultCode.FAILURE;
        OperationServicesResult result = new OperationServicesResult(code);
        return result;
    }

    public OperationServicesResult stop() {
        try {
            this.operationsDelegate.invoke(JBossASServerSupportedOperations.SHUTDOWN, null);
        }
        catch (InterruptedException e) {
            this.log.error((Object)"Shutdown interrupted", (Throwable)e);
        }
        OperationServicesResultCode code = this.serverComponent.getAvailability() == AvailabilityType.DOWN ? OperationServicesResultCode.SUCCESS : OperationServicesResultCode.FAILURE;
        OperationServicesResult result = new OperationServicesResult(code);
        return result;
    }

    public boolean isRunning() {
        return this.serverComponent.getAvailability() == AvailabilityType.UP;
    }
}

