/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.modules.plugins.jbossas7.AS7Authenticator;
import org.rhq.modules.plugins.jbossas7.PluginStats;
import org.rhq.modules.plugins.jbossas7.json.ComplexResult;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class ASConnection {
    public static final String MANAGEMENT = "/management";
    private static final String FAILURE_DESCRIPTION = "\"failure-description\"";
    public static boolean verbose = false;
    private static final int HTTP_TEMPORARY_REDIRECT = 307;
    private static final String POST_HTTP_METHOD = "POST";
    private static final String CONTENT_LENGTH_HTTP_HEADER = "Content-Length";
    private static final String ACCEPT_HTTP_HEADER = "Accept";
    private static final String CONTENT_TYPE_HTTP_HEADER = "Content-Type";
    private static final String JSON_MIME_TYPE = "application/json";
    private final Log log = LogFactory.getLog(ASConnection.class);
    private URL url;
    private String urlString;
    private ObjectMapper mapper;
    private Authenticator passwordAuthenticator;
    private String host;
    private int port;

    public ASConnection(String host, int port, String user, String password) {
        if (host == null) {
            throw new IllegalArgumentException("Management host cannot be null.");
        }
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        this.host = host;
        this.port = port;
        try {
            this.url = new URL("http", host, port, MANAGEMENT);
            this.urlString = this.url.toString();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        this.passwordAuthenticator = new AS7Authenticator(user, password);
        Authenticator.setDefault(this.passwordAuthenticator);
        verbose = Boolean.getBoolean("as7plugin.verbose");
        this.mapper = new ObjectMapper();
        this.mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public JsonNode executeRaw(Operation operation) {
        return this.executeRaw(operation, 20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonNode executeRaw(Operation operation, int timeoutSec) {
        OutputStream out;
        HttpURLConnection conn;
        long requestStartTime = System.currentTimeMillis();
        try {
            conn = (HttpURLConnection)this.url.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod(POST_HTTP_METHOD);
            conn.addRequestProperty(CONTENT_TYPE_HTTP_HEADER, JSON_MIME_TYPE);
            conn.addRequestProperty(ACCEPT_HTTP_HEADER, JSON_MIME_TYPE);
            conn.setInstanceFollowRedirects(false);
            int timeoutMillis = timeoutSec * 1000;
            conn.setConnectTimeout(timeoutMillis);
            conn.setReadTimeout(timeoutMillis);
            if (conn.getReadTimeout() != timeoutMillis) {
                this.log.warn((Object)"Read timeout did not get set on HTTP connection - the JRE uses a broken timeout mechanism - nothing we can do.");
            }
            out = conn.getOutputStream();
        }
        catch (IOException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Failed to open connection to [" + this.urlString + "] in order to invoke [" + operation + "]: " + e));
            }
            Result failure = new Result();
            failure.setFailureDescription(e.toString());
            failure.setOutcome("failure");
            failure.setRhqThrowable(e);
            JsonNode ret = this.mapper.valueToTree((Object)failure);
            return ret;
        }
        try {
            Result noResult;
            JsonNode operationResult;
            String jsonToSend = this.mapper.writeValueAsString((Object)operation);
            if (operation != null && operation.getAddress() != null && operation.getAddress().getPath() != null && this.containsSpaces(operation.getAddress().getPath())) {
                JsonNode invalidPathResult;
                Result noResult2 = new Result();
                String outcome = "- Path '" + operation.getAddress().getPath() + "' is invalid as it contains spaces -";
                if (verbose) {
                    this.log.error((Object)outcome);
                }
                noResult2.setFailureDescription(outcome);
                noResult2.setOutcome("failure");
                JsonNode jsonNode = invalidPathResult = this.mapper.valueToTree((Object)noResult2);
                return jsonNode;
            }
            if (verbose) {
                this.log.info((Object)("JSON to send: " + jsonToSend));
            }
            this.mapper.writeValue(out, (Object)operation);
            out.flush();
            out.close();
            ResponseStatus responseStatus = new ResponseStatus(conn);
            if (this.isAuthorizationFailureResponse(responseStatus.getResponseCode())) {
                this.handleAuthorizationFailureResponse(operation, responseStatus);
            }
            String responseBody = this.getResponseBody(conn);
            if (responseStatus.getResponseCode() >= 400) {
                if (verbose) {
                    this.log.debug((Object)(operation + " failed with " + responseStatus + " - response body was [" + responseBody + "]."));
                }
                if (responseBody.contains("JBAS014807") || responseBody.contains("JBAS010850") || responseBody.contains("JBAS014793")) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Requested management resource not found: " + operation.getAddress().getPath()));
                    }
                } else {
                    this.log.warn((Object)("Received " + responseStatus + " response to " + operation + " - response body was [" + responseBody + "]."));
                }
            }
            if (!responseBody.isEmpty()) {
                try {
                    operationResult = this.mapper.readTree(responseBody);
                }
                catch (IOException ioe) {
                    this.log.error((Object)("Failed to deserialize response to " + operation + " to JsonNode - response status was " + responseStatus + ", and body was [" + responseBody + "]: " + ioe));
                    Result result = new Result();
                    result.setOutcome("failure");
                    result.setFailureDescription("Failed to deserialize response to " + operation + " to JsonNode - response status was " + responseStatus + ", and body was [" + responseBody + "]: " + ioe);
                    result.setRolledBack(responseBody.contains("rolled-back=true"));
                    result.setRhqThrowable(ioe);
                    operationResult = this.mapper.valueToTree((Object)result);
                }
                if (verbose) {
                    ObjectMapper om2 = new ObjectMapper();
                    om2.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
                    try {
                        String resultString = om2.writeValueAsString((Object)operationResult);
                        this.log.info((Object)resultString);
                    }
                    catch (IOException ioe) {
                        this.log.error((Object)("Failed to convert result of " + operation + " to string."), (Throwable)ioe);
                    }
                }
            } else {
                noResult = new Result();
                noResult.setOutcome("failure");
                noResult.setFailureDescription("- empty response body with HTTP status code " + responseStatus + " -");
                operationResult = this.mapper.valueToTree((Object)noResult);
            }
            noResult = operationResult;
            return noResult;
        }
        catch (IllegalArgumentException iae) {
            this.log.error((Object)("Illegal argument for input " + operation + ": " + iae.getMessage()));
        }
        catch (SocketTimeoutException ste) {
            JsonNode ret;
            this.log.error((Object)(operation + " timed out: " + ste.getMessage()));
            conn.disconnect();
            Result failure = new Result();
            failure.setFailureDescription(ste.getMessage());
            failure.setOutcome("failure");
            failure.setRhqThrowable(ste);
            JsonNode jsonNode = ret = this.mapper.valueToTree((Object)failure);
            return jsonNode;
        }
        catch (IOException ioe) {
            JsonNode ret;
            conn.disconnect();
            Result failure = new Result();
            failure.setFailureDescription(ioe.getMessage());
            failure.setOutcome("failure");
            failure.setRhqThrowable(ioe);
            JsonNode jsonNode = ret = this.mapper.valueToTree((Object)failure);
            return jsonNode;
        }
        finally {
            long requestEndTime = System.currentTimeMillis();
            PluginStats stats = PluginStats.getInstance();
            stats.incrementRequestCount();
            stats.addRequestTime(requestEndTime - requestStartTime);
        }
        return null;
    }

    private boolean isAuthorizationFailureResponse(int responseCode) {
        return responseCode == 401 || responseCode == 307;
    }

    private void handleAuthorizationFailureResponse(Operation operation, ResponseStatus responseStatus) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Response to " + operation + " was " + responseStatus + " - throwing InvalidPluginConfigurationException..."));
        }
        String message = responseStatus.getResponseCode() == 401 ? "Credentials for plugin to connect to AS7 management interface are invalid - update Connection Settings with valid credentials." : "Authorization to AS7 failed - did you install a management user?";
        throw new InvalidPluginConfigurationException(message);
    }

    private String getResponseMessage(HttpURLConnection conn) throws IOException {
        String responseMessage = conn.getResponseMessage();
        if (responseMessage == null && conn.getResponseCode() == 307) {
            responseMessage = "Temporary Redirect";
        }
        return responseMessage;
    }

    private boolean containsSpaces(String path) {
        boolean includesSpaces = false;
        StringTokenizer components = new StringTokenizer(path, " ");
        if (components.countTokens() > 1) {
            includesSpaces = true;
        }
        return includesSpaces;
    }

    public Result execute(Operation op) {
        return this.execute(op, false, 10);
    }

    public Result execute(Operation op, int timeoutSec) {
        return this.execute(op, false, timeoutSec);
    }

    public ComplexResult executeComplex(Operation op) {
        return (ComplexResult)this.execute(op, true, 10);
    }

    public ComplexResult executeComplex(Operation op, int timeoutSec) {
        return (ComplexResult)this.execute(op, true, timeoutSec);
    }

    public Result execute(Operation op, boolean isComplex) {
        return this.execute(op, isComplex, 10);
    }

    public Result execute(Operation op, boolean isComplex, int timeoutSec) {
        JsonNode node = this.executeRaw(op, timeoutSec);
        if (node == null) {
            this.log.warn((Object)("Operation [" + op + "] returned null."));
            Result failure = new Result();
            failure.setFailureDescription("Operation [" + op + "] returned null.");
            return failure;
        }
        try {
            String as7ResultSerialization = node.toString();
            if (as7ResultSerialization.indexOf(FAILURE_DESCRIPTION) > -1 && verbose) {
                this.log.warn((Object)("------ Detected 'failure-description' when communicating with server." + as7ResultSerialization));
            }
            Result res = isComplex ? (Result)this.mapper.readValue(node, ComplexResult.class) : (Result)this.mapper.readValue(node, Result.class);
            return res;
        }
        catch (IOException e) {
            this.log.error((Object)e.getMessage());
            if (verbose) {
                this.log.error((Object)("----------- Operation execution unparsable. Request :[" + op + "] Response:<" + node + ">"));
            }
            Result failure = new Result();
            failure.setFailureDescription("Operation <" + op + "> returned unparsable JSON, <" + node + ">.");
            return failure;
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @NotNull
    private String getResponseBody(HttpURLConnection connection) {
        InputStream inputStream;
        try {
            inputStream = connection.getInputStream();
        }
        catch (IOException e) {
            inputStream = null;
        }
        if (inputStream == null) {
            inputStream = connection.getErrorStream();
        }
        if (inputStream == null) {
            return "";
        }
        int contentLength = connection.getHeaderFieldInt(CONTENT_LENGTH_HTTP_HEADER, -1);
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        StringWriter stringWriter = contentLength != -1 ? new StringWriter(contentLength) : new StringWriter();
        BufferedWriter writer = new BufferedWriter(stringWriter);
        try {
            int cnt;
            char[] buffer = new char[1024];
            for (long numCharsCopied = 0L; (contentLength == -1 || numCharsCopied < (long)contentLength) && (cnt = reader.read(buffer)) != -1; numCharsCopied += (long)cnt) {
                writer.write(buffer, 0, cnt);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read response.", e);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException ioe) {
                this.log.debug((Object)"Failed to close writer.", (Throwable)ioe);
            }
            try {
                reader.close();
            }
            catch (IOException ioe) {
                this.log.debug((Object)"Failed to close reader.", (Throwable)ioe);
            }
        }
        return stringWriter.getBuffer().toString();
    }

    private class ResponseStatus {
        private Integer responseCode;
        private String responseMessage;

        ResponseStatus(HttpURLConnection connection) throws IOException {
            try {
                this.responseCode = connection.getResponseCode();
            }
            catch (IOException e) {
                this.responseCode = connection.getResponseCode();
            }
            try {
                this.responseMessage = connection.getResponseMessage();
            }
            catch (IOException e) {
                this.responseMessage = connection.getResponseMessage();
            }
            if (this.responseMessage == null) {
                this.responseMessage = this.getResponseCode() == 307 ? "Temporary Redirect" : "";
            }
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        @NotNull
        public String getResponseMessage() {
            return this.responseMessage;
        }

        public String toString() {
            return this.getResponseCode() + " (" + this.getResponseMessage() + ")";
        }
    }
}

