/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ManualAddFacet;
import org.rhq.core.pluginapi.inventory.ProcessScanResult;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.pluginapi.util.CommandLineOption;
import org.rhq.core.pluginapi.util.FileUtils;
import org.rhq.core.pluginapi.util.JavaCommandLine;
import org.rhq.core.pluginapi.util.ServerStartScriptDiscoveryUtility;
import org.rhq.core.pluginapi.util.StartScriptConfiguration;
import org.rhq.core.system.ProcessInfo;
import org.rhq.modules.plugins.jbossas7.AS7CommandLine;
import org.rhq.modules.plugins.jbossas7.AS7Mode;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.JBossProductType;
import org.rhq.modules.plugins.jbossas7.helper.HostConfiguration;
import org.rhq.modules.plugins.jbossas7.helper.HostPort;
import org.rhq.modules.plugins.jbossas7.helper.ServerPluginConfiguration;
import org.rhq.modules.plugins.jbossas7.json.ReadAttribute;
import org.rhq.modules.plugins.jbossas7.json.Result;
import org.w3c.dom.Document;

public abstract class BaseProcessDiscovery
implements ResourceDiscoveryComponent,
ManualAddFacet {
    private static final String JBOSS_AS_PREFIX = "jboss-as-";
    private static final String JBOSS_EAP_PREFIX = "jboss-eap-";
    private static final String HOME_DIR_SYSPROP = "jboss.home.dir";
    private static final String RHQADMIN = "rhqadmin";
    private static final String RHQADMIN_ENCRYPTED = "35c160c1f841a889d4cda53f0bfc94b6";
    private static final boolean OS_IS_WINDOWS = File.separatorChar == '\\';
    private static final Set<String> START_SCRIPT_ENV_VAR_NAMES = new LinkedHashSet<String>();
    private static final Set<CommandLineOption> START_SCRIPT_OPTION_EXCLUDES;
    private final Log log = LogFactory.getLog(this.getClass());

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext discoveryContext) throws Exception {
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>();
        List processScanResults = discoveryContext.getAutoDiscoveredProcesses();
        for (ProcessScanResult processScanResult : processScanResults) {
            try {
                ProcessInfo process = processScanResult.getProcessInfo();
                AS7CommandLine commandLine = new AS7CommandLine(process);
                DiscoveredResourceDetails details = this.buildResourceDetails(discoveryContext, process, commandLine);
                discoveredResources.add(details);
                this.log.debug((Object)("Discovered new " + discoveryContext.getResourceType().getName() + " Resource (key=[" + details.getResourceKey() + "], name=[" + details.getResourceName() + "], version=[" + details.getResourceVersion() + "])."));
            }
            catch (RuntimeException e) {
                this.log.error((Object)("Discovery of a " + discoveryContext.getResourceType().getName() + " Resource failed for " + processScanResult.getProcessInfo() + "."), (Throwable)e);
            }
            catch (Exception e) {
                this.log.error((Object)("Discovery of a " + discoveryContext.getResourceType().getName() + " Resource failed for " + processScanResult.getProcessInfo() + " - cause: " + e));
            }
        }
        return discoveredResources;
    }

    protected DiscoveredResourceDetails buildResourceDetails(ResourceDiscoveryContext discoveryContext, ProcessInfo process, AS7CommandLine commandLine) throws Exception {
        String version;
        Configuration pluginConfig = discoveryContext.getDefaultPluginConfiguration();
        ServerPluginConfiguration serverPluginConfig = new ServerPluginConfiguration(pluginConfig);
        File homeDir = this.getHomeDir(process, commandLine);
        serverPluginConfig.setHomeDir(homeDir);
        File baseDir = this.getBaseDir(process, commandLine, homeDir);
        serverPluginConfig.setBaseDir(baseDir);
        File configDir = this.getConfigDir(process, commandLine, baseDir);
        serverPluginConfig.setConfigDir(configDir);
        File hostXmlFile = this.getHostXmlFile(commandLine, configDir);
        if (!hostXmlFile.exists()) {
            throw new Exception("Server configuration file not found at the expected location (" + hostXmlFile + ").");
        }
        serverPluginConfig.setHostConfigFile(hostXmlFile);
        HostConfiguration hostConfig = this.loadHostConfiguration(hostXmlFile);
        String domainHost = this.findHost(hostXmlFile);
        pluginConfig.setSimpleValue("domainHost", domainHost);
        File logDir = this.getLogDir(process, commandLine, baseDir);
        File logFile = this.getLogFile(logDir);
        this.initLogEventSourcesConfigProp(logFile.getPath(), pluginConfig);
        HostPort managementHostPort = hostConfig.getManagementHostPort(commandLine, this.getMode());
        serverPluginConfig.setHostname(managementHostPort.host);
        serverPluginConfig.setPort(managementHostPort.port);
        pluginConfig.setSimpleValue("realm", hostConfig.getManagementSecurityRealm());
        JBossProductType productType = JBossProductType.determineJBossProductType(homeDir);
        serverPluginConfig.setProductType(productType);
        pluginConfig.setSimpleValue("hostXmlFileName", this.getHostXmlFileName(commandLine));
        ProcessInfo agentProcess = discoveryContext.getSystemInformation().getThisProcess();
        this.setStartScriptPluginConfigProps(process, commandLine, pluginConfig, agentProcess);
        this.setUserAndPasswordPluginConfigProps(serverPluginConfig, hostConfig, baseDir);
        String key = baseDir.getPath();
        HostPort hostPort = hostConfig.getDomainControllerHostPort(commandLine);
        String name = this.buildDefaultResourceName(hostPort, managementHostPort, productType);
        String description = this.buildDefaultResourceDescription(hostPort, productType);
        String versionFromHomeDir = this.determineServerVersionFromHomeDir(homeDir);
        if (productType == JBossProductType.AS) {
            version = versionFromHomeDir;
        } else {
            ProductInfo productInfo = new ProductInfo(managementHostPort.host, serverPluginConfig.getUser(), serverPluginConfig.getPassword(), managementHostPort.port);
            String productVersion = (productInfo = productInfo.getFromRemote()).fromRemote ? productInfo.productVersion : versionFromHomeDir;
            version = productType.SHORT_NAME + " " + productVersion;
        }
        return new DiscoveredResourceDetails(discoveryContext.getResourceType(), key, name, version, description, pluginConfig, process);
    }

    protected HostConfiguration loadHostConfiguration(File hostXmlFile) throws Exception {
        try {
            return new HostConfiguration(hostXmlFile);
        }
        catch (Exception e) {
            throw new Exception("Failed to load host configuration from [" + hostXmlFile + "].", e);
        }
    }

    protected File getHomeDir(ProcessInfo processInfo, JavaCommandLine javaCommandLine) {
        String home = (String)javaCommandLine.getSystemProperties().get(HOME_DIR_SYSPROP);
        File homeDir = new File(home);
        if (!homeDir.isAbsolute()) {
            if (processInfo.getExecutable() == null) {
                throw new RuntimeException("jboss.home.dir for AS7 process " + processInfo + " is a relative path, and the RHQ Agent process does not have permission to resolve it.");
            }
            String cwd = processInfo.getExecutable().getCwd();
            homeDir = new File(cwd, home);
        }
        return new File(FileUtils.getCanonicalPath((String)homeDir.getPath()));
    }

    private void setStartScriptPluginConfigProps(ProcessInfo process, AS7CommandLine commandLine, Configuration pluginConfig, ProcessInfo agentProcess) {
        File homeDir;
        File startScriptAbsolute;
        StartScriptConfiguration startScriptConfig = new StartScriptConfiguration(pluginConfig);
        ProcessInfo parentProcess = this.getPotentialStartScriptProcess(process);
        File startScript = ServerStartScriptDiscoveryUtility.getStartScript((ProcessInfo)parentProcess);
        if (startScript == null) {
            String startScriptFileName = this.getMode().getStartScriptFileName();
            startScript = new File("bin", startScriptFileName);
        }
        if (!(startScript.exists() || startScript.isAbsolute() || (startScriptAbsolute = new File(homeDir = new File(pluginConfig.getSimpleValue("homeDir")), startScript.getPath())).exists())) {
            this.log.warn((Object)("Failed to find start script file for AS7 server with command line [" + (Object)((Object)commandLine) + "] - defaulting 'startScripFile' plugin config prop to [" + startScript + "]."));
        }
        startScriptConfig.setStartScript(startScript);
        String startScriptPrefix = ServerStartScriptDiscoveryUtility.getStartScriptPrefix((ProcessInfo)process, (ProcessInfo)agentProcess);
        startScriptConfig.setStartScriptPrefix(startScriptPrefix);
        Map startScriptEnv = ServerStartScriptDiscoveryUtility.getStartScriptEnv((ProcessInfo)process, (ProcessInfo)parentProcess, START_SCRIPT_ENV_VAR_NAMES);
        startScriptConfig.setStartScriptEnv(startScriptEnv);
        List startScriptArgs = ServerStartScriptDiscoveryUtility.getStartScriptArgs((ProcessInfo)parentProcess, commandLine.getAppServerArguments(), START_SCRIPT_OPTION_EXCLUDES);
        startScriptConfig.setStartScriptArgs(startScriptArgs);
    }

    protected abstract ProcessInfo getPotentialStartScriptProcess(ProcessInfo var1);

    private void setUserAndPasswordPluginConfigProps(ServerPluginConfiguration serverPluginConfig, HostConfiguration hostConfig, File baseDir) {
        String password;
        String user;
        Properties mgmtUsers = this.getManagementUsers(hostConfig, this.getMode(), baseDir);
        if (!mgmtUsers.isEmpty()) {
            if (mgmtUsers.containsKey(RHQADMIN)) {
                user = RHQADMIN;
                String encryptedPassword = mgmtUsers.getProperty(user);
                password = RHQADMIN_ENCRYPTED.equals(encryptedPassword) ? RHQADMIN : null;
            } else {
                user = (String)mgmtUsers.keySet().iterator().next();
                password = null;
            }
        } else {
            user = RHQADMIN;
            password = RHQADMIN;
        }
        serverPluginConfig.setUser(user);
        serverPluginConfig.setPassword(password);
    }

    protected File getBaseDir(ProcessInfo process, JavaCommandLine javaCommandLine, File homeDir) {
        File baseDir;
        String baseDirString = (String)javaCommandLine.getSystemProperties().get(this.getBaseDirSystemPropertyName());
        if (baseDirString != null) {
            baseDir = new File(baseDirString);
            if (!baseDir.isAbsolute()) {
                if (process.getExecutable() == null) {
                    baseDir = new File(homeDir, baseDirString);
                    if (!baseDir.exists()) {
                        throw new RuntimeException(this.getBaseDirSystemPropertyName() + " for AS7 process " + process + " is a relative path, and the RHQ Agent process does not have permission to resolve it.");
                    }
                } else {
                    String cwd = process.getExecutable().getCwd();
                    baseDir = new File(cwd, baseDirString);
                    if (!baseDir.exists()) {
                        baseDir = new File(homeDir, baseDirString);
                    }
                }
            }
            baseDir = new File(FileUtils.getCanonicalPath((String)baseDir.getPath()));
        } else {
            baseDir = new File(homeDir, this.getDefaultBaseDirName());
        }
        return baseDir;
    }

    protected File getConfigDir(ProcessInfo process, JavaCommandLine javaCommandLine, File baseDir) {
        File configDir;
        String configDirString = (String)javaCommandLine.getSystemProperties().get(this.getConfigDirSystemPropertyName());
        if (configDirString != null) {
            configDir = new File(configDirString);
            if (!configDir.isAbsolute()) {
                if (process.getExecutable() == null) {
                    throw new RuntimeException(this.getConfigDirSystemPropertyName() + " for AS7 process " + process + " is a relative path, and the RHQ Agent process does not have permission to resolve it.");
                }
                String cwd = process.getExecutable().getCwd();
                configDir = new File(cwd, configDirString);
            }
            configDir = new File(FileUtils.getCanonicalPath((String)configDir.getPath()));
        } else {
            configDir = new File(baseDir, this.getDefaultConfigDirName());
        }
        return configDir;
    }

    protected File getLogDir(ProcessInfo process, AS7CommandLine commandLine, File baseDir) {
        File logDir;
        String logDirString = (String)commandLine.getSystemProperties().get(this.getLogDirSystemPropertyName());
        if (logDirString != null) {
            logDir = new File(logDirString);
            if (!logDir.isAbsolute()) {
                if (process.getExecutable() == null) {
                    throw new RuntimeException(this.getLogDirSystemPropertyName() + " for AS7 process " + process + " is a relative path, and the RHQ Agent process does not have permission to resolve it.");
                }
                String cwd = process.getExecutable().getCwd();
                logDir = new File(cwd, logDirString);
            }
            logDir = new File(FileUtils.getCanonicalPath((String)logDir.getPath()));
        } else {
            logDir = new File(baseDir, this.getDefaultLogDirName());
        }
        return logDir;
    }

    protected String getHostXmlFileName(AS7CommandLine commandLine) {
        AS7Mode mode = this.getMode();
        String optionValue = commandLine.getClassOption(mode.getHostConfigFileNameOption());
        if (optionValue == null) {
            optionValue = (String)commandLine.getSystemProperties().get(mode.getDefaultHostConfigSystemPropertyName());
        }
        return optionValue != null ? optionValue : mode.getDefaultHostConfigFileName();
    }

    protected File getHostXmlFile(AS7CommandLine commandLine, File configDir) {
        return new File(configDir, this.getHostXmlFileName(commandLine));
    }

    protected String getDefaultConfigDirName() {
        return "configuration";
    }

    protected String getDefaultLogDirName() {
        return "log";
    }

    protected abstract AS7Mode getMode();

    protected File getLogFile(File logDir) {
        return new File(logDir, this.getLogFileName());
    }

    protected abstract String getBaseDirSystemPropertyName();

    protected abstract String getConfigDirSystemPropertyName();

    protected abstract String getLogDirSystemPropertyName();

    protected abstract String getDefaultBaseDirName();

    protected abstract String getLogFileName();

    protected abstract String buildDefaultResourceName(HostPort var1, HostPort var2, JBossProductType var3);

    protected abstract String buildDefaultResourceDescription(HostPort var1, JBossProductType var2);

    public DiscoveredResourceDetails discoverResource(Configuration pluginConfig, ResourceDiscoveryContext context) throws InvalidPluginConfigurationException {
        ServerPluginConfiguration serverPluginConfig = new ServerPluginConfiguration(pluginConfig);
        String hostname = serverPluginConfig.getHostname();
        Integer port = serverPluginConfig.getPort();
        String user = serverPluginConfig.getUser();
        String pass = serverPluginConfig.getPassword();
        if (hostname == null || port == null) {
            throw new InvalidPluginConfigurationException("Hostname and port must both be set.");
        }
        ProductInfo productInfo = new ProductInfo(hostname, user, pass, port).getFromRemote();
        JBossProductType productType = productInfo.getProductType();
        if (productType == null) {
            throw new InvalidPluginConfigurationException("Can not connect to [" + hostname + ":" + port + "] as user [" + user + "]. Did you provide the correct credentials?");
        }
        HostPort hostPort = new HostPort(false);
        HostPort managementHostPort = new HostPort(false);
        managementHostPort.host = hostname;
        managementHostPort.port = port;
        String key = hostname + ":" + port;
        String name = this.buildDefaultResourceName(hostPort, managementHostPort, productType);
        String version = productInfo.getProductVersion();
        String description = this.buildDefaultResourceDescription(hostPort, productType);
        pluginConfig.put((Property)new PropertySimple("manuallyAdded", (Object)true));
        pluginConfig.put((Property)new PropertySimple("productType", (Object)productType.name()));
        DiscoveredResourceDetails detail = new DiscoveredResourceDetails(context.getResourceType(), key, name, version, description, pluginConfig, null);
        return detail;
    }

    private String getServerAttribute(ASConnection connection, String attributeName) {
        ReadAttribute op = new ReadAttribute(null, attributeName);
        Result res = connection.execute(op);
        if (!res.isSuccess()) {
            throw new InvalidPluginConfigurationException("Could not connect to remote server [" + res.getFailureDescription() + "]. Did you enable management?");
        }
        return (String)res.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getManagementUsers(HostConfiguration hostConfig, AS7Mode mode, File baseDir) {
        FileInputStream inputStream;
        String realm = hostConfig.getManagementSecurityRealm();
        File mgmUsersPropsFile = hostConfig.getSecurityPropertyFile(baseDir, mode, realm);
        Properties props = new Properties();
        if (!mgmUsersPropsFile.exists()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Management user properties file not found at [" + mgmUsersPropsFile + "]."));
            }
            return props;
        }
        if (!mgmUsersPropsFile.canRead()) {
            this.log.warn((Object)("Management user properties at [" + mgmUsersPropsFile + "] is not readable."));
            return props;
        }
        try {
            inputStream = new FileInputStream(mgmUsersPropsFile);
        }
        catch (FileNotFoundException e) {
            this.log.debug((Object)("Management user properties file not found at [" + mgmUsersPropsFile + "]."));
            return props;
        }
        try {
            props.load(inputStream);
        }
        catch (IOException e) {
            this.log.error((Object)("Failed to parse management users properties file at [" + mgmUsersPropsFile + "]: " + e.getMessage()));
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                this.log.error((Object)("Failed to close management users properties file at [" + mgmUsersPropsFile + "]: " + e.getMessage()));
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findHost(File hostXmlFile) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        String hostName = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            FileInputStream is = new FileInputStream(hostXmlFile);
            try {
                Document document = builder.parse(is);
                hostName = document.getDocumentElement().getAttribute("name");
            }
            finally {
                ((InputStream)is).close();
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
        }
        if (hostName == null) {
            hostName = "local";
        }
        return hostName;
    }

    private void initLogEventSourcesConfigProp(String fileName, Configuration pluginConfiguration) {
        PropertyList logEventSources = pluginConfiguration.getList("logEventSources");
        if (logEventSources == null) {
            return;
        }
        File serverLogFile = new File(fileName);
        if (serverLogFile.exists() && !serverLogFile.isDirectory()) {
            PropertyMap serverLogEventSource = new PropertyMap("logEventSource");
            serverLogEventSource.put((Property)new PropertySimple("logFilePath", (Object)serverLogFile));
            serverLogEventSource.put((Property)new PropertySimple("enabled", (Object)Boolean.FALSE));
            logEventSources.add((Property)serverLogEventSource);
        }
    }

    protected String determineServerVersionFromHomeDir(File homeDir) {
        String homeDirName = homeDir.getName();
        String version = homeDirName.startsWith(JBOSS_AS_PREFIX) ? homeDirName.substring(JBOSS_AS_PREFIX.length()) : (homeDirName.startsWith(JBOSS_EAP_PREFIX) ? homeDirName.substring(JBOSS_EAP_PREFIX.length()) : (homeDirName.indexOf(45) >= 0 ? homeDirName.substring(homeDirName.lastIndexOf(45) + 1) : ""));
        return version;
    }

    static {
        START_SCRIPT_ENV_VAR_NAMES.addAll(Arrays.asList("RUN_CONF", "STANDALONE_CONF", "DOMAIN_CONF", "MAX_FD", "PROFILER", "JAVA_HOME", "JAVA", "PRESERVE_JAVA_OPTS", "PROCESS_CONTROLLER_JAVA_OPTS", "HOST_CONTROLLER_JAVA_OPTS", "JAVAC_JAR", "JBOSS_HOME", "JBOSS_MODULES_SYSTEM_PKGS", "JBOSS_MODULEPATH", "JBOSS_BASE_DIR", "JBOSS_LOG_DIR", "JBOSS_CONFIG_DIR"));
        if (OS_IS_WINDOWS) {
            START_SCRIPT_ENV_VAR_NAMES.add("ECHO");
            START_SCRIPT_ENV_VAR_NAMES.add("NOPAUSE");
        }
        START_SCRIPT_OPTION_EXCLUDES = new HashSet<CommandLineOption>();
        START_SCRIPT_OPTION_EXCLUDES.add(new CommandLineOption("mp", null));
        START_SCRIPT_OPTION_EXCLUDES.add(new CommandLineOption(null, "pc-address"));
        START_SCRIPT_OPTION_EXCLUDES.add(new CommandLineOption(null, "pc-port"));
        START_SCRIPT_OPTION_EXCLUDES.add(new CommandLineOption("default-jvm", null));
        START_SCRIPT_OPTION_EXCLUDES.add(new CommandLineOption("Djboss.home.dir", null));
    }

    private class ProductInfo {
        private String hostname;
        private String user;
        private String pass;
        private int port;
        private String productVersion;
        private JBossProductType productType;
        private String releaseVersion;
        private String releaseCodeName;
        private boolean fromRemote = false;
        private String serverName;

        public ProductInfo(String hostname, String user, String pass, int port) {
            this.hostname = hostname;
            this.user = user;
            this.pass = pass;
            this.port = port;
        }

        public String getProductVersion() {
            return this.productVersion;
        }

        public JBossProductType getProductType() {
            return this.productType;
        }

        public ProductInfo getFromRemote() {
            ASConnection connection = new ASConnection(this.hostname, this.port, this.user, this.pass);
            try {
                String productName = BaseProcessDiscovery.this.getServerAttribute(connection, "product-name");
                this.productType = productName != null && !productName.isEmpty() ? JBossProductType.getValueByProductName(productName) : JBossProductType.AS;
                this.releaseVersion = BaseProcessDiscovery.this.getServerAttribute(connection, "release-version");
                this.releaseCodeName = BaseProcessDiscovery.this.getServerAttribute(connection, "release-codename");
                this.serverName = BaseProcessDiscovery.this.getServerAttribute(connection, "name");
                this.productVersion = BaseProcessDiscovery.this.getServerAttribute(connection, "product-version");
                if (this.productVersion == null) {
                    this.productVersion = this.releaseVersion;
                }
                this.fromRemote = true;
            }
            catch (InvalidPluginConfigurationException e) {
                BaseProcessDiscovery.this.log.debug((Object)("Could not get the product info from [" + this.hostname + ":" + this.port + "] - probably a connection failure"));
            }
            return this;
        }

        public String toString() {
            return "ProductInfo{hostname='" + this.hostname + '\'' + ", port=" + this.port + ", productVersion='" + this.productVersion + '\'' + ", productType='" + (Object)((Object)this.productType) + '\'' + ", releaseVersion='" + this.releaseVersion + '\'' + ", releaseCodeName='" + this.releaseCodeName + '\'' + ", fromRemote=" + this.fromRemote + '}';
        }
    }
}

