/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.jndi;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.event.EventContext;
import javax.naming.event.EventDirContext;
import javax.naming.ldap.LdapContext;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jnp.interfaces.NamingContextFactory;
import org.rhq.jndi.DecoratingInitialContextFactory;
import org.rhq.jndi.context.AccessCheckingContextDecoratorSetContext;
import org.rhq.jndi.context.ContextDecorator;
import org.rhq.jndi.context.URLPreferringContextDecoratorSetContext;
import org.rhq.jndi.util.DecoratorPicker;

public class AccessCheckingInitialContextFactoryBuilder
implements InitialContextFactoryBuilder {
    private static final Log LOG = LogFactory.getLog(AccessCheckingInitialContextFactoryBuilder.class);
    private static final String[] CHECKED_SCHEMES = new String[]{"java"};
    private static final Set<Class<? extends Context>> SUPPORTED_CONTEXT_INTERFACES = new HashSet<Class<? extends Context>>();
    private static final Set<InetAddress> SERVER_BIND_IPS;
    private static final int JNP_PORT;
    private static final InitialContextFactory DEFAULT_FACTORY;

    @Override
    public InitialContextFactory createInitialContextFactory(Hashtable<?, ?> environment) throws NamingException {
        String factoryClassName = (String)environment.get("java.naming.factory.initial");
        if (factoryClassName == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No java.naming.factory.initial set. Using the default factory.");
            }
            return DEFAULT_FACTORY;
        }
        ClassLoader classLoader = this.getContextClassLoader();
        try {
            Class<?> factoryClass = Class.forName(factoryClassName, true, classLoader);
            InitialContextFactory configuredFactory = (InitialContextFactory)factoryClass.newInstance();
            return AccessCheckingInitialContextFactoryBuilder.createSecureWrapper(configuredFactory, environment);
        }
        catch (Exception e) {
            throw new NamingException("Failed instantiate InitialContextFactory " + factoryClassName + " from classloader " + classLoader);
        }
    }

    private ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private static InitialContextFactory createSecureWrapper(InitialContextFactory factory, Hashtable<?, ?> environment) {
        String providerUrl = (String)environment.get("java.naming.provider.url");
        if (providerUrl == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Wrapping " + factory + " of class " + factory.getClass() + " in an access checking wrapper. No provider URL detected."));
            }
            return AccessCheckingInitialContextFactoryBuilder.getAccessCheckingFactory(factory);
        }
        try {
            URI uri = new URI(providerUrl);
            InetAddress providerHost = InetAddress.getByName(uri.getHost());
            if (uri.getPort() == JNP_PORT && SERVER_BIND_IPS.contains(providerHost)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Wrapping " + factory + " of class " + factory.getClass() + " in an access checking wrapper. The provider URL points to this server."));
                }
                return AccessCheckingInitialContextFactoryBuilder.getAccessCheckingFactory(factory);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Wrapping " + factory + " of class " + factory.getClass() + " in an URL preferring wrapper to enable remote connections."));
            }
            return AccessCheckingInitialContextFactoryBuilder.getURLPreferringFactory(factory);
        }
        catch (URISyntaxException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("The java.naming.provider.url is not a valid URI. Falling back to using the access checking wrapper for the factory " + factory + " of class " + factory.getClass() + "."), (Throwable)e);
            }
            return AccessCheckingInitialContextFactoryBuilder.getAccessCheckingFactory(factory);
        }
        catch (UnknownHostException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("The java.naming.provider.url is not resolvable. Falling back to using the URL preferring wrapper for the factory " + factory + " of class " + factory.getClass() + "."), (Throwable)e);
            }
            return AccessCheckingInitialContextFactoryBuilder.getURLPreferringFactory(factory);
        }
    }

    private static InitialContextFactory getAccessCheckingFactory(InitialContextFactory original) {
        ArrayList<DecoratorPicker<Context, ContextDecorator>> pickers = new ArrayList<DecoratorPicker<Context, ContextDecorator>>();
        pickers.add(AccessCheckingInitialContextFactoryBuilder.getURLPreferringDecoratorPicker());
        pickers.add(AccessCheckingInitialContextFactoryBuilder.getAccessCheckingDecoratorPicker());
        return new DecoratingInitialContextFactory(original, pickers);
    }

    private static InitialContextFactory getURLPreferringFactory(InitialContextFactory original) {
        ArrayList<DecoratorPicker<Context, ContextDecorator>> pickers = new ArrayList<DecoratorPicker<Context, ContextDecorator>>();
        pickers.add(AccessCheckingInitialContextFactoryBuilder.getURLPreferringDecoratorPicker());
        return new DecoratingInitialContextFactory(original, pickers);
    }

    private static DecoratorPicker<Context, ContextDecorator> getAccessCheckingDecoratorPicker() {
        DecoratorPicker<Context, ContextDecorator> ret = new DecoratorPicker<Context, ContextDecorator>();
        ret.setContext(new AccessCheckingContextDecoratorSetContext(SUPPORTED_CONTEXT_INTERFACES, CHECKED_SCHEMES));
        return ret;
    }

    private static DecoratorPicker<Context, ContextDecorator> getURLPreferringDecoratorPicker() {
        DecoratorPicker<Context, ContextDecorator> ret = new DecoratorPicker<Context, ContextDecorator>();
        ret.setContext(new URLPreferringContextDecoratorSetContext(SUPPORTED_CONTEXT_INTERFACES));
        return ret;
    }

    static {
        SUPPORTED_CONTEXT_INTERFACES.add(Context.class);
        SUPPORTED_CONTEXT_INTERFACES.add(DirContext.class);
        SUPPORTED_CONTEXT_INTERFACES.add(EventContext.class);
        SUPPORTED_CONTEXT_INTERFACES.add(EventDirContext.class);
        SUPPORTED_CONTEXT_INTERFACES.add(LdapContext.class);
        SERVER_BIND_IPS = new HashSet<InetAddress>();
        try {
            String bindingAddressString = System.getProperty("jboss.bind.address");
            InetAddress bindingAddress = InetAddress.getByName(bindingAddressString);
            if (bindingAddress.isAnyLocalAddress()) {
                Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
                while (ifaces.hasMoreElements()) {
                    NetworkInterface iface = ifaces.nextElement();
                    SERVER_BIND_IPS.addAll(Collections.list(iface.getInetAddresses()));
                }
            } else {
                SERVER_BIND_IPS.add(bindingAddress);
            }
        }
        catch (SocketException e) {
            LOG.error((Object)"Could not obtain the list of local IPs", (Throwable)e);
        }
        catch (UnknownHostException e) {
            LOG.error((Object)"Failed to get the binding address of the RHQ server.", (Throwable)e);
        }
        JNP_PORT = Integer.parseInt(System.getProperty("rhq.server.startup.namingservice.port", "2099"));
        DEFAULT_FACTORY = new InitialContextFactory(){

            @Override
            public Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
                return AccessCheckingInitialContextFactoryBuilder.createSecureWrapper((InitialContextFactory)new NamingContextFactory(), environment).getInitialContext(environment);
            }
        };
    }
}

