/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import mazz.i18n.Logger;
import org.rhq.core.clientapi.server.core.CoreServerService;
import org.rhq.core.domain.plugin.Plugin;
import org.rhq.core.pc.PluginContainerConfiguration;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.communications.command.client.RemoteIOException;

public class PluginUpdate {
    private static final Logger LOG = AgentI18NFactory.getLogger(PluginUpdate.class);
    private static final String MARKER_FILENAME = ".updatelock";
    private static final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final CoreServerService coreServerService;
    private final PluginContainerConfiguration config;

    public static boolean isCurrentlyUpdating(PluginContainerConfiguration config) {
        File marker = new File(config.getPluginDirectory(), MARKER_FILENAME);
        return marker.exists();
    }

    public static boolean waitForUpdateToComplete(PluginContainerConfiguration config, long timeout) throws InterruptedException {
        long time_limit = System.currentTimeMillis() + timeout;
        boolean currently_updating = true;
        while (currently_updating && time_limit > System.currentTimeMillis()) {
            Thread.sleep(2000L);
            currently_updating = PluginUpdate.isCurrentlyUpdating(config);
        }
        return currently_updating;
    }

    public PluginUpdate(CoreServerService core_server_service, PluginContainerConfiguration config) {
        this.coreServerService = core_server_service;
        this.config = config;
    }

    public PluginUpdate(PluginContainerConfiguration config) {
        this(null, config);
    }

    public PluginContainerConfiguration getPluginContainerConfiguration() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Plugin> updatePlugins() throws Exception {
        LOG.debug("PluginUpdate.updating", new Object[0]);
        ArrayList<Plugin> updated_plugins = new ArrayList<Plugin>();
        if (!lock.writeLock().tryLock(3600L, TimeUnit.SECONDS)) {
            throw new TimeoutException();
        }
        try {
            this.createMarkerFile();
            try {
                List disabled_plugin_names = this.config.getDisabledPlugins();
                Map<String, Plugin> current_plugins = this.getCurrentPlugins();
                List latest_plugins = this.coreServerService.getLatestPlugins();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("PluginUpdate.latest-plugins-count", new Object[]{latest_plugins.size()});
                    for (Plugin latest_plugin : latest_plugins) {
                        LOG.debug("PluginUpdate.latest-plugin", new Object[]{latest_plugin.getId(), latest_plugin.getName(), latest_plugin.getDisplayName(), latest_plugin.getVersion(), latest_plugin.getPath(), latest_plugin.getMd5(), latest_plugin.isEnabled(), latest_plugin.getDescription()});
                    }
                }
                HashMap<String, Plugin> latest_plugins_map = new HashMap<String, Plugin>(latest_plugins.size());
                for (Plugin latest_plugin : latest_plugins) {
                    String plugin_filename = latest_plugin.getPath();
                    latest_plugins_map.put(plugin_filename, latest_plugin);
                    Plugin current_plugin = current_plugins.get(plugin_filename);
                    if (current_plugin == null) {
                        updated_plugins.add(latest_plugin);
                        LOG.debug("PluginUpdate.need-missing-plugin", new Object[]{plugin_filename});
                        continue;
                    }
                    if (latest_plugin.isEnabled() && !disabled_plugin_names.contains(latest_plugin.getName())) {
                        String latest_md5 = latest_plugin.getMD5();
                        String current_md5 = current_plugin.getMD5();
                        if (!current_md5.equals(latest_md5)) {
                            updated_plugins.add(latest_plugin);
                            LOG.debug("PluginUpdate.need-to-update", new Object[]{plugin_filename, current_md5, latest_md5});
                            continue;
                        }
                        LOG.debug("PluginUpdate.already-at-latest", new Object[]{plugin_filename});
                        continue;
                    }
                    File disabled_file = this.getPluginFile(latest_plugin);
                    if (disabled_file.delete()) {
                        LOG.info("PluginUpdate.disabled-plugin-deleted", new Object[]{disabled_file});
                        continue;
                    }
                    LOG.error("PluginUpdate.disabled-plugin-delete-failed", new Object[]{disabled_file});
                }
                this.deleteIllegitimatePlugins(current_plugins, latest_plugins_map);
                Exception last_error = null;
                for (Plugin updated_plugin : updated_plugins) {
                    String name = updated_plugin.getName();
                    if (updated_plugin.isEnabled() && !disabled_plugin_names.contains(name)) {
                        try {
                            this.downloadPluginWithRetries(updated_plugin);
                        }
                        catch (Exception e) {
                            last_error = e;
                        }
                        continue;
                    }
                    LOG.info("PluginUpdate.disabled-plugin-download-skipped", new Object[]{name});
                    updated_plugin.setEnabled(false);
                }
                if (last_error != null) {
                    throw last_error;
                }
            }
            finally {
                this.deleteMarkerFile();
            }
        }
        finally {
            lock.writeLock().unlock();
        }
        LOG.info("PluginUpdate.updating-complete", new Object[0]);
        return updated_plugins;
    }

    public List<File> getCurrentPluginFiles() {
        File[] plugin_files;
        ArrayList<File> current_plugins = new ArrayList<File>();
        File plugin_dir = this.config.getPluginDirectory();
        for (File plugin_file : plugin_files = plugin_dir.listFiles()) {
            if (!plugin_file.getName().endsWith(".jar")) continue;
            current_plugins.add(plugin_file);
        }
        return current_plugins;
    }

    private void downloadPluginWithRetries(Plugin plugin) throws Exception {
        LOG.info("PluginUpdate.downloading", new Object[]{plugin.getPath()});
        int attempt = 0;
        boolean keep_trying = true;
        while (keep_trying) {
            try {
                ++attempt;
                this.getPluginArchive(plugin);
                keep_trying = false;
            }
            catch (Exception e) {
                long sleep = (long)(Math.random() * 60000.0) + 10000L;
                String errors = ThrowableUtil.getAllMessages((Throwable)e);
                if ((attempt < 3 || errors.contains(RemoteIOException.class.getName())) && attempt < 10) {
                    LOG.warn("PluginUpdate.download-failure-will-retry", new Object[]{plugin.getPath(), attempt, sleep, errors});
                    try {
                        Thread.sleep(sleep);
                    }
                    catch (Exception e2) {}
                    continue;
                }
                LOG.warn("PluginUpdate.download-failure-will-not-retry", new Object[]{plugin.getPath(), attempt, errors});
                throw e;
            }
        }
        LOG.info("PluginUpdate.downloading-complete", new Object[]{plugin.getName(), plugin.getPath()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getPluginArchive(Plugin plugin_to_get) throws Exception {
        File plugin_dir = this.config.getPluginDirectory();
        String new_plugin_filename = plugin_to_get.getPath();
        File old_plugin = new File(plugin_dir, new_plugin_filename);
        File old_plugin_backup = null;
        if (old_plugin.exists()) {
            old_plugin_backup = new File(plugin_dir, new_plugin_filename + ".OLD");
            old_plugin_backup.delete();
            boolean renamed = old_plugin.renameTo(old_plugin_backup);
            if (!renamed) {
                LOG.warn("PluginUpdate.backup-failure", new Object[]{old_plugin, old_plugin_backup});
            }
        }
        File new_plugin = new File(plugin_dir, new_plugin_filename);
        FileOutputStream new_plugin_outstream = null;
        try {
            new_plugin_outstream = new FileOutputStream(new_plugin, false);
            InputStream server_plugin_instream = this.coreServerService.getPluginArchive(plugin_to_get.getName());
            StreamUtil.copy((InputStream)server_plugin_instream, (OutputStream)new_plugin_outstream, (boolean)true);
            if (old_plugin_backup != null) {
                old_plugin_backup.delete();
            }
        }
        catch (Exception e) {
            boolean renamed;
            LOG.error((Throwable)e, "PluginUpdate.download-failure", new Object[]{plugin_to_get.getName()});
            if (new_plugin_outstream != null) {
                try {
                    new_plugin_outstream.close();
                }
                catch (Exception ignore) {
                }
                finally {
                    new_plugin.delete();
                }
            }
            if (old_plugin_backup != null && !(renamed = old_plugin_backup.renameTo(new_plugin))) {
                LOG.error("PluginUpdate.backup-restore-failure", new Object[]{old_plugin_backup, new_plugin});
            }
            throw e;
        }
    }

    private Map<String, Plugin> getCurrentPlugins() throws IOException {
        File[] plugin_files;
        HashMap<String, Plugin> plugins = new HashMap<String, Plugin>();
        File plugin_dir = this.config.getPluginDirectory();
        for (File plugin_file : plugin_files = plugin_dir.listFiles()) {
            String plugin_filename = plugin_file.getName();
            if (!plugin_filename.endsWith(".jar")) continue;
            Plugin cur_plugin = new Plugin(plugin_filename, plugin_filename);
            cur_plugin.setMD5(MessageDigestGenerator.getDigestString((File)plugin_file));
            plugins.put(plugin_filename, cur_plugin);
        }
        return plugins;
    }

    private void createMarkerFile() {
        File marker = null;
        try {
            marker = new File(this.config.getPluginDirectory(), MARKER_FILENAME);
            if (!marker.exists()) {
                new FileOutputStream(marker).close();
            }
        }
        catch (Exception e) {
            LOG.warn("PluginUpdate.marker-create-failure", new Object[]{marker, e});
        }
    }

    private void deleteMarkerFile() {
        try {
            File marker = new File(this.config.getPluginDirectory(), MARKER_FILENAME);
            if (marker.exists() && !marker.delete()) {
                LOG.warn("PluginUpdate.marker-delete-failure", new Object[]{marker});
            }
        }
        catch (Throwable t) {
            LOG.warn("PluginUpdate.marker-delete-failure", new Object[]{MARKER_FILENAME});
        }
    }

    private void deleteIllegitimatePlugins(Map<String, Plugin> current_plugins, Map<String, Plugin> latest_plugins_map) {
        for (Plugin current_plugin : current_plugins.values()) {
            File plugin;
            if (latest_plugins_map.containsKey(current_plugin.getPath()) || !(plugin = this.getPluginFile(current_plugin)).exists()) continue;
            File plugin_dir = this.config.getPluginDirectory();
            String plugin_filename = plugin.getPath();
            File plugin_backup = new File(plugin_dir, plugin_filename + ".REJECTED");
            LOG.warn("PluginUpdate.plugin-not-on-server", new Object[]{plugin_filename, plugin_backup.getName()});
            try {
                plugin_backup.delete();
                boolean renamed = plugin.renameTo(plugin_backup);
                if (renamed) continue;
                LOG.error("PluginUpdate.plugin-rename-failed", new Object[]{plugin_filename, plugin_backup.getName()});
                plugin.delete();
            }
            catch (RuntimeException e) {
                LOG.error((Throwable)e, "PluginUpdate.plugin-rename-failed", new Object[]{plugin_filename, plugin_backup.getName()});
            }
        }
    }

    private File getPluginFile(Plugin plugin) {
        File plugin_dir = this.config.getPluginDirectory();
        String plugin_filename = plugin.getPath();
        File file = new File(plugin_dir, plugin_filename);
        return file;
    }
}

