/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.promptcmd;

import java.io.File;
import java.io.PrintWriter;
import mazz.i18n.Msg;
import org.rhq.enterprise.agent.AgentConfiguration;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.agent.promptcmd.AgentPromptCommand;
import org.rhq.enterprise.communications.command.client.ClientCommandSenderConfiguration;
import org.rhq.enterprise.communications.command.client.PersistentFifo;

public class DumpSpoolPromptCommand
implements AgentPromptCommand {
    private static final Msg MSG = AgentI18NFactory.getMsg();

    @Override
    public String getPromptCommandString() {
        return MSG.getMsg("PromptCommand.dumpspool", new Object[0]);
    }

    @Override
    public boolean execute(AgentMain agent, String[] args) {
        AgentConfiguration agent_config = agent.getConfiguration();
        ClientCommandSenderConfiguration sender_config = agent_config.getClientCommandSenderConfiguration();
        if (sender_config.commandSpoolFileName == null) {
            agent.getOut().println(MSG.getMsg("PromptCommand.dumpspool.no-file", new Object[0]));
            return true;
        }
        int raw_byte_base = -2;
        if (args.length > 1) {
            if (args.length == 2) {
                if (args[1].equals(MSG.getMsg("PromptCommand.dumpspool.object", new Object[0]))) {
                    raw_byte_base = 0;
                } else if (args[1].equals(MSG.getMsg("PromptCommand.dumpspool.hexidecimal", new Object[0]))) {
                    raw_byte_base = 16;
                }
            }
        } else {
            raw_byte_base = -1;
        }
        if (raw_byte_base == -2) {
            agent.getOut().println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
            return true;
        }
        File spool_file = new File(sender_config.dataDirectory, sender_config.commandSpoolFileName);
        try {
            PersistentFifo.dumpContents((PrintWriter)agent.getOut(), (File)spool_file, (boolean)agent_config.isClientSenderCommandSpoolFileCompressed(), (int)raw_byte_base);
        }
        catch (Exception e) {
            agent.getOut().println(MSG.getMsg("PromptCommand.dumpspool.error", new Object[]{spool_file, e}));
        }
        return true;
    }

    @Override
    public String getSyntax() {
        return MSG.getMsg("PromptCommand.dumpspool.syntax", new Object[0]);
    }

    @Override
    public String getHelp() {
        return MSG.getMsg("PromptCommand.dumpspool.help", new Object[0]);
    }

    @Override
    public String getDetailedHelp() {
        return MSG.getMsg("PromptCommand.dumpspool.detailed-help", new Object[0]);
    }
}

