/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.promptcmd;

import mazz.i18n.Msg;
import org.rhq.enterprise.agent.AgentConfiguration;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.AgentPrintWriter;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.agent.promptcmd.AgentPromptCommand;
import org.rhq.enterprise.communications.command.client.ClientCommandSender;
import org.rhq.enterprise.communications.command.client.ClientCommandSenderMetrics;

public class SenderPromptCommand
implements AgentPromptCommand {
    private static final Msg MSG = AgentI18NFactory.getMsg();

    @Override
    public String getPromptCommandString() {
        return MSG.getMsg("PromptCommand.sender", new Object[0]);
    }

    @Override
    public boolean execute(AgentMain agent, String[] args) {
        AgentPrintWriter out = agent.getOut();
        try {
            if (args.length != 2) {
                out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
            } else {
                String subcommand = args[1];
                ClientCommandSender sender = agent.getClientCommandSender();
                if (sender != null) {
                    if (subcommand.equals(MSG.getMsg("PromptCommand.sender.start", new Object[0]))) {
                        out.println(MSG.getMsg("PromptCommand.sender.starting", new Object[0]));
                        sender.startSending();
                    } else if (subcommand.equals(MSG.getMsg("PromptCommand.sender.stop", new Object[0]))) {
                        out.println(MSG.getMsg("PromptCommand.sender.stopping", new Object[0]));
                        sender.stopSending(true);
                    } else if (subcommand.equals(MSG.getMsg("PromptCommand.sender.metrics", new Object[0]))) {
                        ClientCommandSenderMetrics metrics = sender.getMetrics();
                        out.println(MSG.getMsg("PromptCommand.sender.metrics-output", new Object[]{metrics}));
                    } else if (!subcommand.equals(MSG.getMsg("PromptCommand.sender.status", new Object[0]))) {
                        out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
                    }
                    if (sender.isSending()) {
                        out.println(MSG.getMsg("PromptCommand.sender.is-sending", new Object[0]));
                    } else {
                        out.println(MSG.getMsg("PromptCommand.sender.is-not-sending", new Object[0]));
                    }
                    out.println(MSG.getMsg("PromptCommand.sender.server-endpoint", new Object[]{sender.getRemoteCommunicator().getRemoteEndpoint()}));
                } else {
                    out.println(MSG.getMsg("PromptCommand.sender.agent-not-started", new Object[0]));
                    AgentConfiguration agent_config = agent.getConfiguration();
                    out.println(MSG.getMsg("PromptCommand.sender.server-endpoint-config", new Object[]{agent_config.getServerLocatorUri()}));
                }
            }
        }
        catch (Exception e) {
            out.println(MSG.getMsg("PromptCommand.sender.failure", new Object[0]));
            e.printStackTrace(out);
        }
        return true;
    }

    @Override
    public String getSyntax() {
        return MSG.getMsg("PromptCommand.sender.syntax", new Object[0]);
    }

    @Override
    public String getHelp() {
        return MSG.getMsg("PromptCommand.sender.help", new Object[0]);
    }

    @Override
    public String getDetailedHelp() {
        return MSG.getMsg("PromptCommand.sender.detailed-help", new Object[0]);
    }
}

