/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Map;
import jline.Completor;
import jline.ConsoleReader;
import jline.SimpleCompletor;
import org.rhq.enterprise.agent.AgentInputReader;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.promptcmd.AgentPromptCommand;

public class JLineAgentInputReader
implements AgentInputReader {
    private final ConsoleReader jline;
    private final AgentMain agent;
    private final boolean consoleInput;

    public JLineAgentInputReader(AgentMain agent) throws IOException {
        this.jline = new ConsoleReader();
        this.agent = agent;
        this.addCompletor();
        this.consoleInput = true;
    }

    public JLineAgentInputReader(AgentMain agent, FileInputStream fis) throws IOException {
        this.jline = new ConsoleReader((InputStream)fis, (Writer)agent.getOut());
        this.agent = agent;
        this.addCompletor();
        this.consoleInput = false;
    }

    public void addCompletor() {
        Map<String, Class<? extends AgentPromptCommand>> cmds = this.agent.getPromptCommands();
        if (cmds != null) {
            String[] cmdArray = cmds.keySet().toArray(new String[0]);
            this.jline.addCompletor((Completor)new SimpleCompletor(cmdArray));
        }
    }

    @Override
    public boolean isConsole() {
        return this.consoleInput;
    }

    @Override
    public String readLine() throws IOException {
        return this.jline.readLine();
    }

    @Override
    public String readLineNoEcho() throws IOException {
        String input = null;
        while (true) {
            input = this.jline.readLine(Character.valueOf('*'));
            if (!this.isConsole()) break;
            this.agent.getOut().write(this.agent.getI18NMsg().getMsg("AgentNativePromptInfo.prompt-confirm", new Object[0]));
            this.agent.getOut().println();
            String confirmation = this.jline.readLine(Character.valueOf('*'));
            this.agent.getOut().println();
            if (input.equals(confirmation)) break;
            this.agent.getOut().write(this.agent.getI18NMsg().getMsg("AgentNativePromptInfo.prompt-confirm-failed", new Object[0]));
            this.agent.getOut().println();
        }
        return input;
    }

    @Override
    public void close() throws IOException {
        InputStream input = this.jline.getInput();
        if (input != null) {
            input.close();
        }
    }
}

