/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.promptcmd;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import mazz.i18n.Msg;
import org.rhq.core.system.ProcessInfo;
import org.rhq.core.system.SystemInfo;
import org.rhq.core.system.SystemInfoFactory;
import org.rhq.core.system.pquery.ProcessInfoQuery;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.AgentPrintWriter;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.agent.promptcmd.AgentPromptCommand;

public class PiqlPromptCommand
implements AgentPromptCommand {
    private static final Msg MSG = AgentI18NFactory.getMsg();

    @Override
    public String getPromptCommandString() {
        return MSG.getMsg("PromptCommand.piql", new Object[0]);
    }

    @Override
    public boolean execute(AgentMain agent, String[] args) {
        String piql;
        AgentPrintWriter out = agent.getOut();
        boolean verbose = false;
        if (args.length == 2) {
            piql = args[1];
        } else if (args.length == 3 && args[1].equals(MSG.getMsg("PromptCommand.piql.verbose", new Object[0]))) {
            piql = args[2];
            verbose = true;
        } else {
            out.println(MSG.getMsg("PromptCommand.help.syntax-label", new Object[]{this.getSyntax()}));
            return true;
        }
        try {
            SystemInfo info = SystemInfoFactory.createSystemInfo();
            List processes = info.getAllProcesses();
            ProcessInfoQuery query = new ProcessInfoQuery(processes);
            List results = query.query(piql);
            out.println(MSG.getMsg("PromptCommand.piql.results-header", new Object[]{piql}));
            for (ProcessInfo process : results) {
                if (verbose) {
                    out.println(MSG.getMsg("PromptCommand.piql.results-full", new Object[]{process.getPid(), process.getParentPid(), process.getName(), new Date(process.getTime().getStartTime()), process.getTime().getSys(), process.getTime().getUser(), Arrays.toString(process.getCommandLine())}));
                    continue;
                }
                out.println(MSG.getMsg("PromptCommand.piql.results-short", new Object[]{process.getPid(), process.getName()}));
            }
        }
        catch (UnsupportedOperationException uoe) {
            out.println(MSG.getMsg("PromptCommand.piql.no-native-support", new Object[]{uoe.getMessage()}));
        }
        catch (Exception e) {
            out.println(MSG.getMsg("PromptCommand.piql.failure", new Object[]{e.getMessage()}));
        }
        return true;
    }

    @Override
    public String getSyntax() {
        return MSG.getMsg("PromptCommand.piql.syntax", new Object[0]);
    }

    @Override
    public String getHelp() {
        return MSG.getMsg("PromptCommand.piql.help", new Object[0]);
    }

    @Override
    public String getDetailedHelp() {
        return MSG.getMsg("PromptCommand.piql.detailed-help", new Object[0]);
    }
}

