/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderkit.compiler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.faces.FacesException;
import org.ajax4jsf.Messages;
import org.ajax4jsf.renderkit.compiler.ElementBase;
import org.ajax4jsf.renderkit.compiler.Invoker;
import org.ajax4jsf.renderkit.compiler.MethodParameterElement;
import org.ajax4jsf.renderkit.compiler.PreparedTemplate;
import org.ajax4jsf.renderkit.compiler.RendererInvoker;
import org.ajax4jsf.renderkit.compiler.RendererUtilsInvoker;
import org.ajax4jsf.renderkit.compiler.ResourceElement;
import org.ajax4jsf.renderkit.compiler.StaticInvoker;
import org.ajax4jsf.renderkit.compiler.TemplateContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodCallElement
extends ElementBase {
    public static final String UTILS_PREFIX = "utils.";
    static final Log _log = LogFactory.getLog(MethodCallElement.class);
    private String _name = null;
    private List<MethodParameterElement> parameters = new ArrayList<MethodParameterElement>(3);
    private volatile Invoker invoker;

    @Override
    public void encode(TemplateContext context) throws IOException {
        this.getValue(context);
    }

    @Override
    public void encode(TemplateContext context, String breakPoint) throws IOException {
        this.encode(context);
    }

    @Override
    public Object getValue(TemplateContext context) throws FacesException {
        if (null == this.invoker) {
            throw new FacesException(Messages.getMessage((String)"RENDERER_METHOD_NOT_SET_ERROR"));
        }
        Object[] values = this.computeParameterValues(context);
        return this.invoker.invokeMethod(context, values);
    }

    public Object[] computeParameterValues(TemplateContext context) {
        Object[] ps = new Object[this.parameters.size()];
        for (int i = 0; i < ps.length; ++i) {
            ps[i] = this.parameters.get((int)i).valueGetter.getValueOrDefault(context);
        }
        return ps;
    }

    public void addParameter(MethodParameterElement parameter) {
        this.parameters.add(parameter);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String methodName) {
        if (methodName.startsWith(UTILS_PREFIX)) {
            this._name = methodName.substring(UTILS_PREFIX.length());
            this.invoker = this.getRendererUtilsInvoker(this._name);
        } else if (methodName.indexOf(46) >= 0) {
            this._name = methodName;
            this.invoker = this.getStaticInvoker(this._name);
        } else {
            this._name = methodName;
            this.invoker = this.getRendererInvoker(this._name);
        }
    }

    public Invoker getStaticInvoker(String methodName) {
        StaticInvoker invoker = new StaticInvoker(methodName);
        return invoker;
    }

    public Invoker getRendererInvoker(String methodName) {
        RendererInvoker invoker = new RendererInvoker(methodName);
        return invoker;
    }

    public Invoker getRendererUtilsInvoker(String methodName) {
        RendererUtilsInvoker invoker = new RendererUtilsInvoker(methodName);
        return invoker;
    }

    @Override
    public String getTag() {
        return "f:call";
    }

    @Override
    public void setParent(PreparedTemplate parent) throws SAXException {
        super.setParent(parent);
        if (this.getName() == null) {
            throw new SAXException(Messages.getMessage((String)"NO_NAME_ATTRIBUTE_ERROR", (Object)this.getTag()));
        }
    }

    @Override
    public String getString(TemplateContext context) throws FacesException {
        Object result = this.getValue(context);
        if (null == result || result.toString().length() == 0) {
            result = "";
        }
        return result.toString();
    }

    protected Class<? extends ElementBase>[] getAllowedClasses() {
        return new Class[]{MethodParameterElement.class, ResourceElement.class};
    }
}

