/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.resource.image;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import org.ajax4jsf.resource.image.DiffusionFilterOp;

public class Quantize {
    static final boolean QUICK = false;
    static final int MAX_RGB = 255;
    static final int MAX_NODES = 266817;
    static final int MAX_TREE_DEPTH = 8;
    static final int MAX_CHILDREN = 16;

    public static BufferedImage process(BufferedImage source, int maxColors, boolean dither, boolean alphaToBitmask) {
        int type = source.getType();
        int[] pixels = type == 1 || type == 2 || type == 3 ? ((DataBufferInt)source.getRaster().getDataBuffer()).getData() : source.getRGB(0, 0, source.getWidth(), source.getHeight(), null, 0, source.getWidth());
        Cube cube = new Cube(source, pixels, maxColors, dither, alphaToBitmask);
        cube.classification();
        cube.reduction();
        return cube.assignment();
    }

    static class Cube {
        BufferedImage source;
        int[] pixels;
        int maxColors;
        byte[][] colorMap;
        Node root;
        int depth;
        boolean dither;
        boolean alphaToBitmask;
        boolean addTransparency;
        int firstColor = 0;
        int numColors;
        int numNodes;

        Cube(BufferedImage source, int[] pixels, int maxColors, boolean dither, boolean alphaToBitmask) {
            this.source = source;
            this.pixels = pixels;
            this.maxColors = maxColors;
            this.dither = dither;
            this.alphaToBitmask = alphaToBitmask;
            int i = maxColors;
            this.depth = 1;
            while (i != 0) {
                i /= 4;
                ++this.depth;
            }
            if (this.depth > 1) {
                --this.depth;
            }
            if (this.depth > 8) {
                this.depth = 8;
            } else if (this.depth < 2) {
                this.depth = 2;
            }
            this.root = new Node(this);
        }

        void classification() {
            this.addTransparency = false;
            this.firstColor = 0;
            for (int i = 0; i < this.pixels.length; ++i) {
                int pixel = this.pixels[i];
                int red = pixel >> 16 & 0xFF;
                int green = pixel >> 8 & 0xFF;
                int blue = pixel >> 0 & 0xFF;
                int alpha = pixel >> 24 & 0xFF;
                if (this.alphaToBitmask) {
                    int n = alpha = alpha < 128 ? 0 : 255;
                }
                if (alpha > 0) {
                    if (this.numNodes > 266817) {
                        this.root.pruneLevel();
                        --this.depth;
                    }
                    Node node = this.root;
                    for (int level = 1; level <= this.depth; ++level) {
                        int id = (red > node.midRed ? 1 : 0) << 0 | (green > node.midGreen ? 1 : 0) << 1 | (blue > node.midBlue ? 1 : 0) << 2 | (alpha > node.midAlpha ? 1 : 0) << 3;
                        node = node.children[id] == null ? new Node(node, id, level) : node.children[id];
                        ++node.numPixels;
                    }
                    ++node.unique;
                    node.totalRed += red;
                    node.totalGreen += green;
                    node.totalBlue += blue;
                    node.totalAlpha += alpha;
                    continue;
                }
                if (this.addTransparency) continue;
                this.addTransparency = true;
                ++this.numColors;
                this.firstColor = 1;
            }
        }

        void reduction() {
            int threshold = 1;
            while (this.numColors > this.maxColors) {
                this.numColors = this.firstColor;
                threshold = this.root.reduce(threshold, Integer.MAX_VALUE);
            }
        }

        BufferedImage assignment() {
            int depth;
            this.colorMap = new byte[4][this.numColors];
            if (this.addTransparency) {
                this.colorMap[0][0] = 0;
                this.colorMap[1][0] = 0;
                this.colorMap[2][0] = 0;
                this.colorMap[3][0] = 0;
            }
            this.numColors = this.firstColor;
            this.root.mapColors();
            for (depth = 1; depth <= 8 && 1 << depth < this.numColors; ++depth) {
            }
            IndexColorModel icm = this.alphaToBitmask ? (this.addTransparency ? new IndexColorModel(depth, this.numColors, this.colorMap[0], this.colorMap[1], this.colorMap[2], 0) : new IndexColorModel(depth, this.numColors, this.colorMap[0], this.colorMap[1], this.colorMap[2])) : new IndexColorModel(depth, this.numColors, this.colorMap[0], this.colorMap[1], this.colorMap[2], this.colorMap[3]);
            BufferedImage dest = new BufferedImage(this.source.getWidth(), this.source.getHeight(), 13, icm);
            boolean firstOut = true;
            if (this.dither) {
                new DiffusionFilterOp().filter(this.source, dest);
            } else {
                Search search = new Search();
                byte[] dst = ((DataBufferByte)dest.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < this.pixels.length; ++i) {
                    int id;
                    int pixel = this.pixels[i];
                    int red = pixel >> 16 & 0xFF;
                    int green = pixel >> 8 & 0xFF;
                    int blue = pixel >> 0 & 0xFF;
                    int alpha = pixel >> 24 & 0xFF;
                    if (this.alphaToBitmask) {
                        int n = alpha = alpha < 128 ? 0 : 255;
                    }
                    if (i == 0) {
                        String fix = "" + alpha;
                    }
                    if (alpha == 0 && this.addTransparency) {
                        dst[i] = 0;
                        continue;
                    }
                    Node node = this.root;
                    while (node.children[id = (red > node.midRed ? 1 : 0) << 0 | (green > node.midGreen ? 1 : 0) << 1 | (blue > node.midBlue ? 1 : 0) << 2 | (alpha > node.midAlpha ? 1 : 0) << 3] != null) {
                        node = node.children[id];
                    }
                    search.distance = Integer.MAX_VALUE;
                    node.parent.closestColor(red, green, blue, alpha, search);
                    dst[i] = (byte)search.colorIndex;
                }
            }
            return dest;
        }

        static class Node {
            Cube cube;
            Node parent;
            Node[] children;
            int numChildren;
            int id;
            int level;
            int midRed;
            int midGreen;
            int midBlue;
            int midAlpha;
            int numPixels;
            int unique;
            int totalRed;
            int totalGreen;
            int totalBlue;
            int totalAlpha;
            int colorIndex;

            Node(Cube cube) {
                this.cube = cube;
                this.parent = this;
                this.children = new Node[16];
                this.id = 0;
                this.level = 0;
                this.numPixels = Integer.MAX_VALUE;
                this.midRed = 128;
                this.midGreen = 128;
                this.midBlue = 128;
                this.midAlpha = 128;
            }

            Node(Node parent, int id, int level) {
                this.cube = parent.cube;
                this.parent = parent;
                this.children = new Node[16];
                this.id = id;
                this.level = level;
                ++this.cube.numNodes;
                if (level == this.cube.depth) {
                    ++this.cube.numColors;
                }
                ++parent.numChildren;
                parent.children[id] = this;
                int bi = 1 << 8 - level >> 1;
                this.midRed = parent.midRed + ((id & 1) > 0 ? bi : -bi);
                this.midGreen = parent.midGreen + ((id & 2) > 0 ? bi : -bi);
                this.midBlue = parent.midBlue + ((id & 4) > 0 ? bi : -bi);
                this.midAlpha = parent.midAlpha + ((id & 8) > 0 ? bi : -bi);
            }

            void pruneChild() {
                --this.parent.numChildren;
                this.parent.unique += this.unique;
                this.parent.totalRed += this.totalRed;
                this.parent.totalGreen += this.totalGreen;
                this.parent.totalBlue += this.totalBlue;
                this.parent.totalAlpha += this.totalAlpha;
                this.parent.children[this.id] = null;
                --this.cube.numNodes;
                this.cube = null;
                this.parent = null;
            }

            void pruneLevel() {
                if (this.numChildren != 0) {
                    for (int id = 0; id < 16; ++id) {
                        if (this.children[id] == null) continue;
                        this.children[id].pruneLevel();
                    }
                }
                if (this.level == this.cube.depth) {
                    this.pruneChild();
                }
            }

            int reduce(int threshold, int nextThreshold) {
                if (this.numChildren != 0) {
                    for (int id = 0; id < 16; ++id) {
                        if (this.children[id] == null) continue;
                        nextThreshold = this.children[id].reduce(threshold, nextThreshold);
                    }
                }
                if (this.numPixels <= threshold) {
                    this.pruneChild();
                } else {
                    if (this.unique != 0) {
                        ++this.cube.numColors;
                    }
                    if (this.numPixels < nextThreshold) {
                        nextThreshold = this.numPixels;
                    }
                }
                return nextThreshold;
            }

            void mapColors() {
                if (this.numChildren != 0) {
                    for (int id = 0; id < 16; ++id) {
                        if (this.children[id] == null) continue;
                        this.children[id].mapColors();
                    }
                }
                if (this.unique != 0) {
                    int add = this.unique >> 1;
                    this.cube.colorMap[0][this.cube.numColors] = (byte)((this.totalRed + add) / this.unique);
                    this.cube.colorMap[1][this.cube.numColors] = (byte)((this.totalGreen + add) / this.unique);
                    this.cube.colorMap[2][this.cube.numColors] = (byte)((this.totalBlue + add) / this.unique);
                    this.cube.colorMap[3][this.cube.numColors] = (byte)((this.totalAlpha + add) / this.unique);
                    this.colorIndex = this.cube.numColors++;
                }
            }

            void closestColor(int red, int green, int blue, int alpha, Search search) {
                int distance;
                if (this.numChildren != 0) {
                    for (int id = 0; id < 16; ++id) {
                        if (this.children[id] == null) continue;
                        this.children[id].closestColor(red, green, blue, alpha, search);
                    }
                }
                if (this.unique != 0 && (distance = Node.distance(this.cube.colorMap[0][this.colorIndex] & 0xFF, this.cube.colorMap[1][this.colorIndex] & 0xFF, this.cube.colorMap[2][this.colorIndex] & 0xFF, this.cube.colorMap[3][this.colorIndex] & 0xFF, red, green, blue, alpha)) < search.distance) {
                    search.distance = distance;
                    search.colorIndex = this.colorIndex;
                }
            }

            static final int distance(int r1, int g1, int b1, int a1, int r2, int g2, int b2, int a2) {
                int da = a1 - a2;
                int dr = r1 - r2;
                int dg = g1 - g2;
                int db = b1 - b2;
                return da * da + dr * dr + dg * dg + db * db;
            }

            public String toString() {
                StringBuffer buf = new StringBuffer();
                if (this.parent == this) {
                    buf.append("root");
                } else {
                    buf.append("node");
                }
                buf.append(' ');
                buf.append(this.level);
                buf.append(" [");
                buf.append(this.midRed);
                buf.append(',');
                buf.append(this.midGreen);
                buf.append(',');
                buf.append(this.midBlue);
                buf.append(',');
                buf.append(this.midAlpha);
                buf.append(']');
                return new String(buf);
            }
        }

        static class Search {
            int distance;
            int colorIndex;

            Search() {
            }
        }
    }
}

