/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.modcluster;

import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.bean.EmsBean;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.jmx.MBeanResourceComponent;
import org.rhq.plugins.modcluster.helper.JBossHelper;
import org.rhq.plugins.modcluster.model.ProxyInfo;

public class WebappContextComponent
extends MBeanResourceComponent<MBeanResourceComponent<?>> {
    private static final Log log = LogFactory.getLog(WebappContextComponent.class);

    protected EmsBean loadBean() {
        return ((MBeanResourceComponent)this.getResourceContext().getParentResourceComponent()).getEmsBean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvailabilityType getAvailability() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            ProxyInfo.Context currentContext;
            Thread.currentThread().setContextClassLoader(this.getEmsBean().getClass().getClassLoader());
            String rawProxyInfo = JBossHelper.getRawProxyInfo(this.getEmsBean());
            ProxyInfo proxyInfo = new ProxyInfo(rawProxyInfo);
            ProxyInfo.Context context = ProxyInfo.Context.fromString(this.resourceContext.getResourceKey());
            int indexOfCurrentContext = proxyInfo.getAvailableContexts().indexOf(context);
            if (indexOfCurrentContext != -1 && (currentContext = proxyInfo.getAvailableContexts().get(indexOfCurrentContext)).isEnabled()) {
                AvailabilityType availabilityType = AvailabilityType.UP;
                return availabilityType;
            }
            AvailabilityType availabilityType = AvailabilityType.DOWN;
            return availabilityType;
        }
        catch (Exception e) {
            log.info((Object)e);
            AvailabilityType availabilityType = AvailabilityType.DOWN;
            return availabilityType;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult invokeOperation(String name, Configuration parameters) throws Exception {
        if ("enableContext".equals(name) || "disableContext".equals(name) || "stopContext".equals(name)) {
            ProxyInfo.Context context = ProxyInfo.Context.fromString(this.resourceContext.getResourceKey());
            Object[] configuration = null;
            configuration = "stopContext".equals(name) ? new Object[]{context.getHost(), context.getPath(), parameters.getSimple("timeout").getLongValue(), TimeUnit.valueOf(parameters.getSimple("unit").getStringValue())} : new Object[]{context.getHost(), context.getPath()};
            if (context.getPath().equals("/")) {
                configuration[1] = "ROOT";
            }
            log.info((Object)(name + " - " + context.getHost() + " " + context.getPath()));
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getEmsBean().getClass().getClassLoader());
                Object resultObject = this.getEmsBean().getOperation(name).invoke(configuration);
                if (resultObject instanceof OperationResult) {
                    OperationResult operationResult = (OperationResult)resultObject;
                    return operationResult;
                }
                OperationResult operationResult = new OperationResult(String.valueOf(resultObject));
                return operationResult;
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
        throw new Exception("Operation " + name + " not available mod_cluster WebApp service.");
    }
}

