/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.modcluster;

import java.util.HashSet;
import java.util.Set;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jmx.MBeanResourceComponent;
import org.rhq.plugins.modcluster.helper.JBossHelper;
import org.rhq.plugins.modcluster.model.ProxyInfo;

public class WebappContextDiscoveryComponent
implements ResourceDiscoveryComponent<MBeanResourceComponent<?>> {
    private static final String JVM_ROUTE_PROPERTY = "jvmRoute";
    private static final String ENGINE_OBJECT_NAME = "engineObjectName";

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<MBeanResourceComponent<?>> context) {
        String jvmRoute = this.getJvmRoute(context);
        EmsBean configBean = ((MBeanResourceComponent)context.getParentResourceComponent()).getEmsBean();
        String rawProxyInfo = JBossHelper.getRawProxyInfo(configBean);
        ProxyInfo proxyInfo = new ProxyInfo(rawProxyInfo);
        HashSet<DiscoveredResourceDetails> entities = new HashSet<DiscoveredResourceDetails>();
        for (ProxyInfo.Context availableContext : proxyInfo.getAvailableContexts()) {
            if (!availableContext.getJvmRoute().equals(jvmRoute)) continue;
            DiscoveredResourceDetails detail = new DiscoveredResourceDetails(context.getResourceType(), availableContext.createKey(), availableContext.createName(), null, "Webapp Context", null, null);
            entities.add(detail);
        }
        return entities;
    }

    protected EmsBean loadBean(MBeanResourceComponent<?> context, String objectName) {
        EmsConnection emsConnection = context.getEmsConnection();
        if (emsConnection != null) {
            EmsBean bean = emsConnection.getBean(objectName);
            if (bean == null) {
                emsConnection.queryBeans(objectName);
                bean = emsConnection.getBean(objectName);
            }
            return bean;
        }
        return null;
    }

    private String getJvmRoute(ResourceDiscoveryContext<MBeanResourceComponent<?>> context) {
        String[] engineObjectNames;
        Configuration pluginConfig = ((MBeanResourceComponent)context.getParentResourceComponent()).getResourceContext().getPluginConfiguration();
        for (String engineObjectName : engineObjectNames = pluginConfig.getSimple(ENGINE_OBJECT_NAME).getStringValue().split("\\|")) {
            EmsBean engineBean = this.loadBean((MBeanResourceComponent)context.getParentResourceComponent(), engineObjectName);
            if (engineBean == null) continue;
            return engineBean.getAttribute(JVM_ROUTE_PROPERTY).refresh().toString();
        }
        return null;
    }
}

