/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.jar;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.jar.JarFile;
import org.jboss.virtual.plugins.context.jar.AbstractJarHandler;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VirtualFileHandler;

public class JarHandler
extends AbstractJarHandler {
    private static final long serialVersionUID = 1L;

    public JarHandler(VFSContext context, VirtualFileHandler parent, URL url, String name) throws IOException {
        super(context, parent, url, name);
        this.vfsUrl = new URL("vfs" + url.toString());
        try {
            JarURLConnection connection = (JarURLConnection)url.openConnection();
            this.initJarFile(connection.getJarFile());
        }
        catch (IOException original) {
            IOException e = new IOException("Error opening jar file: " + url + " reason=" + original.getMessage());
            e.setStackTrace(original.getStackTrace());
            throw e;
        }
    }

    public JarHandler(VFSContext context, VirtualFileHandler parent, File file, URL url, String name) throws IOException {
        super(context, parent, url, name);
        this.vfsUrl = new URL("vfs" + url.toString());
        try {
            this.initJarFile(new JarFile(file));
        }
        catch (IOException original) {
            IOException e = new IOException("Error opening jar file: " + url + " reason=" + original.getMessage());
            e.setStackTrace(original.getStackTrace());
            throw e;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        JarFile parentJar = super.getJar();
        this.initJarFile(parentJar);
    }
}

