/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.ssl;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.jboss.logging.Logger;

public class ClientSocketFactory
extends SocketFactory
implements HandshakeCompletedListener,
Serializable {
    public static final String HANDSHAKE_COMPLETE_LISTENER = "org.jboss.security.ssl.HandshakeCompletedListener";
    static final long serialVersionUID = -2762336418317218104L;
    private static Logger log = Logger.getLogger(ClientSocketFactory.class);
    private boolean wantsClientAuth = true;
    private boolean needsClientAuth = false;

    public boolean isWantsClientAuth() {
        return this.wantsClientAuth;
    }

    public void setWantsClientAuth(boolean wantsClientAuth) {
        this.wantsClientAuth = wantsClientAuth;
    }

    public boolean isNeedsClientAuth() {
        return this.needsClientAuth;
    }

    public void setNeedsClientAuth(boolean needsClientAuth) {
        this.needsClientAuth = needsClientAuth;
    }

    public Socket createSocket(String serverHost, int serverPort) throws IOException, UnknownHostException {
        InetAddress serverAddr = InetAddress.getByName(serverHost);
        return this.createSocket(serverAddr, serverPort);
    }

    public Socket createSocket(String serverHost, int serverPort, InetAddress clientAddr, int clientPort) throws IOException, UnknownHostException {
        InetAddress serverAddr = InetAddress.getByName(serverHost);
        return this.createSocket(serverAddr, serverPort, clientAddr, clientPort);
    }

    public Socket createSocket(InetAddress serverAddr, int serverPort) throws IOException {
        return this.createSocket(serverAddr, serverPort, null, 0);
    }

    public Socket createSocket(InetAddress serverAddr, int serverPort, InetAddress clientAddr, int clientPort) throws IOException {
        SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        SSLSocket socket = (SSLSocket)factory.createSocket(serverAddr, serverPort, clientAddr, clientPort);
        socket.addHandshakeCompletedListener(this);
        socket.setNeedClientAuth(this.needsClientAuth);
        socket.setWantClientAuth(this.wantsClientAuth);
        return socket;
    }

    public boolean equals(Object obj) {
        return obj instanceof ClientSocketFactory;
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public void handshakeCompleted(HandshakeCompletedEvent event) {
        if (log.isTraceEnabled()) {
            String cipher = event.getCipherSuite();
            SSLSession session = event.getSession();
            String peerHost = session.getPeerHost();
            log.debug((Object)("SSL handshakeCompleted, cipher=" + cipher + ", peerHost=" + peerHost));
        }
        try {
            Properties env = System.getProperties();
            HandshakeCompletedListener listener = (HandshakeCompletedListener)((Hashtable)env).get(HANDSHAKE_COMPLETE_LISTENER);
            if (listener != null) {
                listener.handshakeCompleted(event);
            }
        }
        catch (Throwable e) {
            log.debug((Object)"Failed to forward handshakeCompleted", e);
        }
    }
}

