/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5;

import java.io.File;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedProperty;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.measurement.calltime.CallTimeData;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.util.ResponseTimeConfiguration;
import org.rhq.core.pluginapi.util.ResponseTimeLogParser;
import org.rhq.plugins.jbossas5.ManagedComponentComponent;
import org.rhq.plugins.jbossas5.ProfileServiceComponent;
import org.rhq.plugins.jbossas5.helper.MoreKnownComponentTypes;
import org.rhq.plugins.jbossas5.util.ManagedComponentUtils;
import org.rhq.plugins.jbossas5.util.RegularExpressionNameMatcher;
import org.rhq.plugins.jbossas5.util.ResourceComponentUtils;

public class WebApplicationContextComponent
extends ManagedComponentComponent {
    public static final String VIRTUAL_HOST_PROPERTY = "virtualHost";
    public static final String CONTEXT_PATH_PROPERTY = "contextPath";
    private static final String RESPONSE_TIME_METRIC = "responseTime";
    public static final String RESPONSE_TIME_LOG_FILE_CONFIG_PROP = "responseTimeLogFile";
    private static final String VIRTUAL_HOST_TRAIT = "virtualHost";
    private static final String CLUSTERED_TRAIT = "clustered";
    private static final String DISTRIBUTABLE_MANAGED_PROPERTY = "Distributable";
    private static final String SERVLET_COMPONENT_NAMES_REGEX_TEMPLATE = "jboss.web:J2EEApplication=none,J2EEServer=none,WebModule=//%virtualHost%%contextPath%,j2eeType=Servlet,name=[^,]+";
    private static final String SERVLET_METRIC_PREFIX = "Servlet.";
    private static final String SERVLET_MAXIMUM_RESPONSE_TIME_METRIC = "Servlet.maximumResponseTime";
    private static final String SERVLET_MINIMUM_RESPONSE_TIME_METRIC = "Servlet.minimumResponseTime";
    private static final String SERVLET_AVERAGE_RESPONSE_TIME_METRIC = "Servlet.averageResponseTime";
    private static final String SERVLET_TOTAL_RESPONSE_TIME_METRIC = "Servlet.totalResponseTime";
    private static final String SERVLET_REQUEST_COUNT_METRIC = "Servlet.requestCount";
    private static final String SERVLET_ERROR_COUNT_METRIC = "Servlet.errorCount";
    private final Log log = LogFactory.getLog(this.getClass());
    private String servletComponentNamesRegex;
    private ResponseTimeLogParser logParser;
    private Boolean clustered;

    @Override
    public void start(ResourceContext<ProfileServiceComponent<?>> resourceContext) throws Exception {
        super.start(resourceContext);
        Configuration pluginConfig = this.getResourceContext().getPluginConfiguration();
        this.servletComponentNamesRegex = ResourceComponentUtils.replacePropertyExpressionsInTemplate(SERVLET_COMPONENT_NAMES_REGEX_TEMPLATE, pluginConfig);
        ResponseTimeConfiguration responseTimeConfig = new ResponseTimeConfiguration(pluginConfig);
        File logFile = responseTimeConfig.getLogFile();
        if (logFile != null) {
            this.logParser = new ResponseTimeLogParser(logFile);
            this.logParser.setExcludes(responseTimeConfig.getExcludes());
            this.logParser.setTransforms(responseTimeConfig.getTransforms());
        }
    }

    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) throws Exception {
        ProfileServiceComponent warComponent = (ProfileServiceComponent)this.getResourceContext().getParentResourceComponent();
        ManagementView managementView = warComponent.getConnection().getManagementView();
        ManagedComponent component = this.getManagedComponent();
        for (MeasurementScheduleRequest request : requests) {
            String metricName = request.getName();
            try {
                if (metricName.startsWith(SERVLET_METRIC_PREFIX)) {
                    Double value = this.getServletMetric(managementView, metricName);
                    MeasurementDataNumeric metric = new MeasurementDataNumeric(request, value);
                    report.addData(metric);
                    continue;
                }
                if (metricName.equals("virtualHost")) {
                    Configuration pluginConfig = this.getResourceContext().getPluginConfiguration();
                    String virtualHost = pluginConfig.getSimple("virtualHost").getStringValue();
                    MeasurementDataTrait trait = new MeasurementDataTrait(request, virtualHost);
                    report.addData(trait);
                    continue;
                }
                if (metricName.equals(RESPONSE_TIME_METRIC)) {
                    if (this.logParser != null) {
                        try {
                            CallTimeData callTimeData = new CallTimeData(request);
                            this.logParser.parseLog(callTimeData);
                            report.addData(callTimeData);
                        }
                        catch (Exception e) {
                            this.log.error((Object)"Failed to retrieve HTTP call-time data.", (Throwable)e);
                        }
                        continue;
                    }
                    this.log.error((Object)("The 'responseTime' metric is enabled for WAR resource '" + this.getComponentName() + "', but no value is defined for the '" + RESPONSE_TIME_LOG_FILE_CONFIG_PROP + "' connection property."));
                    continue;
                }
                if (metricName.equals(CLUSTERED_TRAIT)) {
                    if (this.clustered == null) {
                        this.retrieveClusteredProperty();
                    }
                    if (this.clustered == null) continue;
                    MeasurementDataTrait trait = new MeasurementDataTrait(request, this.clustered.toString());
                    report.addData(trait);
                    continue;
                }
                String metricNameToUse = metricName;
                if (this.clustered.booleanValue() && !"runState".equals(metricName)) {
                    metricNameToUse = WebApplicationContextComponent.toUpperCaseFirstLetter(metricName);
                }
                String value = this.getMeasurement(component, metricNameToUse);
                if (this.clustered.booleanValue() && !"runState".equals(metricName) && value == null) {
                    value = this.getMeasurement(component, metricName);
                }
                this.addValueToMeasurementReport(report, request, value);
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to collect metric '" + metricName + "' for " + this.getResourceContext().getResourceType() + " Resource with key " + this.getResourceContext().getResourceKey() + "."), (Throwable)e);
            }
        }
    }

    @Deprecated
    public boolean isClustered() {
        if (this.clustered == null) {
            return false;
        }
        return this.clustered;
    }

    private void retrieveClusteredProperty() {
        try {
            ManagedProperty distributableProp = this.getManagedComponent().getProperty(DISTRIBUTABLE_MANAGED_PROPERTY);
            if (distributableProp != null) {
                Boolean distributable = (Boolean)WebApplicationContextComponent.getInnerValue(distributableProp.getValue());
                this.clustered = distributable != null && distributable != false;
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("Failed to determine whether the web app context " + this.getResourceContext().getResourceKey() + " is clustered or not."), (Throwable)e);
        }
    }

    private Double getServletMetric(ManagementView managementView, String metricName) throws Exception {
        ComponentType servletComponentType = MoreKnownComponentTypes.MBean.Servlet.getType();
        Set<ManagedComponent> servletComponents = ManagedComponentUtils.getManagedComponents(managementView, servletComponentType, this.servletComponentNamesRegex, new RegularExpressionNameMatcher());
        long min = Long.MAX_VALUE;
        long max = 0L;
        long processingTime = 0L;
        int requestCount = 0;
        int errorCount = 0;
        for (ManagedComponent servletComponent : servletComponents) {
            Integer intValue;
            Long longValue;
            if (metricName.equals(SERVLET_MINIMUM_RESPONSE_TIME_METRIC)) {
                longValue = (Long)ManagedComponentUtils.getSimplePropertyValue(servletComponent, "minTime");
                if (longValue >= min) continue;
                min = longValue;
                continue;
            }
            if (metricName.equals(SERVLET_MAXIMUM_RESPONSE_TIME_METRIC)) {
                longValue = (Long)ManagedComponentUtils.getSimplePropertyValue(servletComponent, "maxTime");
                if (longValue <= max) continue;
                max = longValue;
                continue;
            }
            if (metricName.equals(SERVLET_AVERAGE_RESPONSE_TIME_METRIC)) {
                longValue = (Long)ManagedComponentUtils.getSimplePropertyValue(servletComponent, "processingTime");
                processingTime += longValue.longValue();
                Integer intValue2 = (Integer)ManagedComponentUtils.getSimplePropertyValue(servletComponent, "requestCount");
                requestCount += intValue2.intValue();
                continue;
            }
            if (metricName.equals(SERVLET_REQUEST_COUNT_METRIC)) {
                intValue = (Integer)ManagedComponentUtils.getSimplePropertyValue(servletComponent, "requestCount");
                requestCount += intValue.intValue();
                continue;
            }
            if (metricName.equals(SERVLET_ERROR_COUNT_METRIC)) {
                intValue = (Integer)ManagedComponentUtils.getSimplePropertyValue(servletComponent, "errorCount");
                errorCount += intValue.intValue();
                continue;
            }
            if (!metricName.equals(SERVLET_TOTAL_RESPONSE_TIME_METRIC)) continue;
            longValue = (Long)ManagedComponentUtils.getSimplePropertyValue(servletComponent, "processingTime");
            processingTime += longValue.longValue();
        }
        Double result = metricName.equals(SERVLET_AVERAGE_RESPONSE_TIME_METRIC) ? Double.valueOf(requestCount > 0 ? (double)processingTime / (double)requestCount : Double.NaN) : (metricName.equals(SERVLET_MINIMUM_RESPONSE_TIME_METRIC) ? Double.valueOf(min != Long.MAX_VALUE ? (double)min : Double.NaN) : (metricName.equals(SERVLET_MAXIMUM_RESPONSE_TIME_METRIC) ? Double.valueOf(max != 0L ? (double)max : Double.NaN) : (metricName.equals(SERVLET_ERROR_COUNT_METRIC) ? Double.valueOf(errorCount) : (metricName.equals(SERVLET_REQUEST_COUNT_METRIC) ? Double.valueOf(requestCount) : (metricName.equals(SERVLET_TOTAL_RESPONSE_TIME_METRIC) ? Double.valueOf(processingTime) : Double.valueOf(Double.NaN))))));
        return result;
    }

    private static String toUpperCaseFirstLetter(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        char first = name.charAt(0);
        return Character.toUpperCase(first) + name.substring(1);
    }
}

