/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.plugins.tomcat;

import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.on.plugins.tomcat.TomcatUserDatabaseComponent;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.plugins.jmx.MBeanResourceComponent;

public class TomcatUserComponent
extends MBeanResourceComponent<TomcatUserDatabaseComponent>
implements DeleteResourceFacet {
    public static final String CONFIG_FULL_NAME = "fullName";
    public static final String CONFIG_GROUPS = "groups";
    public static final String CONFIG_PASSWORD = "password";
    public static final String CONFIG_ROLES = "roles";
    public static final String CONFIG_USERNAME = "username";
    public static final String PLUGIN_CONFIG_NAME = "name";
    public static final String RESOURCE_TYPE_NAME = "Tomcat User";
    private static final Pattern PATTERN_GROUP_NAME = Pattern.compile("groupname=\"(.*)\"");
    private static final Pattern PATTERN_ROLE_NAME = Pattern.compile("rolename=(.*),");

    public Configuration loadResourceConfiguration() {
        Configuration configuration = super.loadResourceConfiguration();
        try {
            this.resetConfig(CONFIG_GROUPS, PATTERN_GROUP_NAME, configuration);
            this.resetConfig(CONFIG_ROLES, PATTERN_ROLE_NAME, configuration);
        }
        catch (Exception e) {
            log.error((Object)"Failed to reset group or role property value", (Throwable)e);
        }
        return configuration;
    }

    private void resetConfig(String property, Pattern pattern, Configuration configuration) {
        EmsAttribute attribute = this.getEmsBean().getAttribute(property);
        Object valueObject = attribute.refresh();
        String[] vals = (String[])valueObject;
        if (vals.length > 0) {
            String delim = "";
            StringBuilder sb = new StringBuilder();
            Matcher matcher = pattern.matcher("");
            for (String val : vals) {
                matcher.reset(val);
                matcher.find();
                sb.append(delim);
                sb.append(matcher.group(1));
                delim = "\n";
            }
            configuration.put((Property)new PropertySimple(property, (Object)sb.toString()));
        } else {
            configuration.put((Property)new PropertySimple(property, null));
        }
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        Configuration reportConfiguration = report.getConfiguration();
        PropertySimple newGroups = reportConfiguration.getSimple(CONFIG_GROUPS);
        PropertySimple newRoles = reportConfiguration.getSimple(CONFIG_ROLES);
        this.resetConfig(CONFIG_GROUPS, PATTERN_GROUP_NAME, reportConfiguration);
        this.resetConfig(CONFIG_ROLES, PATTERN_ROLE_NAME, reportConfiguration);
        PropertySimple currentGroups = reportConfiguration.getSimple(CONFIG_GROUPS);
        PropertySimple currentRoles = reportConfiguration.getSimple(CONFIG_ROLES);
        reportConfiguration.remove(CONFIG_GROUPS);
        reportConfiguration.remove(CONFIG_ROLES);
        super.updateResourceConfiguration(report);
        reportConfiguration.put((Property)newGroups);
        reportConfiguration.put((Property)newRoles);
        if (ConfigurationUpdateStatus.SUCCESS != report.getStatus()) {
            return;
        }
        try {
            this.consolidateSettings(newGroups, currentGroups, "addGroup", "removeGroup", "groupname");
        }
        catch (Exception e) {
            newGroups.setErrorMessage(ThrowableUtil.getStackAsString((Throwable)e));
            report.setErrorMessage("Failed setting resource configuration - see property error messages for details");
            log.info((Object)"Failure setting Tomcat User Groups configuration value", (Throwable)e);
            return;
        }
        try {
            this.consolidateSettings(newRoles, currentRoles, "addRole", "removeRole", "role");
        }
        catch (Exception e) {
            newRoles.setErrorMessage(ThrowableUtil.getStackAsString((Throwable)e));
            report.setErrorMessage("Failed setting resource configuration - see property error messages for details");
            log.info((Object)"Failure setting Tomcat User Roles configuration value", (Throwable)e);
            return;
        }
        try {
            ((TomcatUserDatabaseComponent)this.getResourceContext().getParentResourceComponent()).save();
        }
        catch (Exception e) {
            report.setErrorMessage("Failed to persist configuration change.  Changes will not survive Tomcat restart unless a successful Save operation is performed.");
        }
    }

    private void consolidateSettings(PropertySimple newVals, PropertySimple currentVals, String addOp, String removeOp, String arg) throws Exception {
        String currentValsLongString = currentVals.getStringValue();
        String newValsLongString = newVals.getStringValue();
        StringTokenizer tokenizer = null;
        Configuration opConfig = new Configuration();
        if (null != newValsLongString) {
            tokenizer = new StringTokenizer(newValsLongString, "\n");
            while (tokenizer.hasMoreTokens()) {
                String newVal = tokenizer.nextToken().trim();
                if (null != currentValsLongString && currentValsLongString.contains(newVal)) continue;
                opConfig.put((Property)new PropertySimple(arg, (Object)newVal));
                try {
                    this.invokeOperation(addOp, opConfig);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Could not add " + arg + "=" + newVal + ". Please check spelling/existence.");
                }
            }
        }
        if (null != currentValsLongString) {
            tokenizer = new StringTokenizer(currentValsLongString, "\n");
            while (tokenizer.hasMoreTokens()) {
                String currentVal = tokenizer.nextToken().trim();
                if (null != newValsLongString && newValsLongString.contains(currentVal)) continue;
                opConfig.put((Property)new PropertySimple(arg, (Object)currentVal));
                try {
                    this.invokeOperation(removeOp, opConfig);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Could not remove " + arg + "=" + currentVal + ". Please check spelling/existence.");
                }
            }
        }
    }

    public void deleteResource() throws Exception {
        Configuration opConfig = new Configuration();
        ResourceContext resourceContext = this.getResourceContext();
        PropertySimple nameProperty = resourceContext.getPluginConfiguration().getSimple(PLUGIN_CONFIG_NAME);
        String name = nameProperty.getStringValue();
        nameProperty = new PropertySimple(CONFIG_USERNAME, (Object)name.substring(1, name.length() - 1));
        opConfig.put((Property)nameProperty);
        ((TomcatUserDatabaseComponent)resourceContext.getParentResourceComponent()).invokeOperation("removeUser", opConfig);
    }
}

