/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.sso;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.io.IOException;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.SessionEvent;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.session.ManagerBase;
import org.jboss.web.tomcat.security.ExtendedSingleSignOn;
import org.jboss.web.tomcat.service.session.JBossManager;
import org.jboss.web.tomcat.service.sso.SSOClusterManager;
import org.jboss.web.tomcat.service.sso.SingleSignOnEntry;
import org.jboss.web.tomcat.service.sso.TreeCacheSSOClusterManager;

public class ClusteredSingleSignOn
extends ExtendedSingleSignOn
implements LifecycleListener {
    public static final int DEFAULT_PROCESS_EXPIRES_INTERVAL = 60;
    public static final int DEFAULT_MAX_EMPTY_LIFE = 1800;
    private String clusterManagerClass = TreeCacheSSOClusterManager.class.getName();
    private SSOClusterManager ssoClusterManager = null;
    private String treeCacheName = "jboss.cache:service=TomcatClusteringCache";
    private Set activeManagers = Collections.synchronizedSet(new HashSet());
    private int maxEmptyLife = 1800000;
    private int processExpiresInterval = 60000;
    private long lastProcessExpires = System.currentTimeMillis();
    private Map emptySSOs = new ConcurrentHashMap();
    private final Object mutex = new Object();

    public SSOClusterManager getClusterManager() {
        return this.ssoClusterManager;
    }

    public void setClusterManager(SSOClusterManager clusterManager) {
        if (this.started && clusterManager != this.ssoClusterManager) {
            throw new IllegalStateException("already started -- cannot set a new SSOClusterManager");
        }
        this.ssoClusterManager = clusterManager;
        if (clusterManager != null) {
            this.clusterManagerClass = clusterManager.getClass().getName();
        }
    }

    public String getClusterManagerClass() {
        return this.clusterManagerClass;
    }

    public void setClusterManagerClass(String managerClass) {
        if (!this.started) {
            this.clusterManagerClass = managerClass;
        } else if (this.ssoClusterManager == null) {
            try {
                this.createClusterManager(managerClass);
            }
            catch (LifecycleException e) {
                this.getContainer().getLogger().error((Object)("Exception creating SSOClusterManager " + managerClass), (Throwable)e);
            }
        } else {
            this.getContainer().getLogger().error((Object)("Cannot set clusterManagerClass to " + managerClass + "; already started using " + this.clusterManagerClass));
        }
    }

    public String getTreeCacheName() {
        return this.treeCacheName;
    }

    public void setTreeCacheName(String cacheName) throws Exception {
        this.treeCacheName = cacheName;
        if (this.ssoClusterManager != null && this.ssoClusterManager instanceof TreeCacheSSOClusterManager) {
            ((TreeCacheSSOClusterManager)this.ssoClusterManager).setCacheName(cacheName);
        }
    }

    public int getMaxEmptyLife() {
        return this.maxEmptyLife / 1000;
    }

    public void setMaxEmptyLife(int maxEmptyLife) {
        if (maxEmptyLife < 0) {
            throw new IllegalArgumentException("maxEmptyLife must be >= 0");
        }
        this.maxEmptyLife = maxEmptyLife * 1000;
    }

    public int getProcessExpiresInterval() {
        return this.processExpiresInterval / 1000;
    }

    public void setProcessExpiresInterval(int processExpiresInterval) {
        if (processExpiresInterval < 0) {
            throw new IllegalArgumentException("processExpiresInterval must be >= 0");
        }
        this.processExpiresInterval = processExpiresInterval * 1000;
    }

    public long getLastProcessExpires() {
        return this.lastProcessExpires;
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("authenticator.alreadyStarted"));
        }
        this.createClusterManager(this.getClusterManagerClass());
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (this.ssoClusterManager != null) {
            this.ssoClusterManager.start();
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("authenticator.notStarted"));
        }
        if (this.ssoClusterManager != null) {
            this.ssoClusterManager.stop();
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionEvent(SessionEvent event) {
        if (!"destroySession".equals(event.getType())) {
            return;
        }
        Session session = event.getSession();
        if (this.getContainer().getLogger().isDebugEnabled()) {
            this.getContainer().getLogger().debug((Object)("Process session destroyed on " + session));
        }
        String ssoId = null;
        Map map = this.reverse;
        synchronized (map) {
            ssoId = (String)this.reverse.get(session);
        }
        if (ssoId == null) {
            return;
        }
        try {
            if (this.isSessionTimedOut(session) || this.isManagerStopped(session)) {
                this.removeSession(ssoId, session);
                this.processExpires();
            } else {
                this.logout(ssoId);
            }
        }
        catch (Exception e) {
            this.getContainer().getLogger().error((Object)("Caught exception updating SSO " + ssoId + " following destruction of session " + session.getIdInternal()), (Throwable)e);
        }
    }

    private boolean isSessionTimedOut(Session session) {
        return session.getMaxInactiveInterval() > 0 && System.currentTimeMillis() - session.getLastAccessedTime() >= (long)(session.getMaxInactiveInterval() * 1000);
    }

    private boolean isManagerStopped(Session session) {
        boolean stopped = false;
        Manager manager = session.getManager();
        if (manager instanceof ManagerBase) {
            ObjectName mgrName = ((ManagerBase)manager).getObjectName();
            stopped = !this.activeManagers.contains(mgrName);
        } else if (manager instanceof JBossManager) {
            ObjectName mgrName = ((JBossManager)manager).getObjectName();
            stopped = !this.activeManagers.contains(mgrName);
        } else if (manager instanceof Lifecycle) {
            stopped = !this.activeManagers.contains(manager);
        }
        return stopped;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        Lifecycle source;
        boolean removed;
        String type = event.getType();
        if (("before_stop".equals(type) || "stop".equals(type) || "after_stop".equals(type)) && (removed = (source = event.getLifecycle()) instanceof ManagerBase ? this.activeManagers.remove(((ManagerBase)source).getObjectName()) : (source instanceof JBossManager ? this.activeManagers.remove(((JBossManager)source).getObjectName()) : this.activeManagers.remove(source)))) {
            source.removeLifecycleListener((LifecycleListener)this);
            if (this.getContainer().getLogger().isDebugEnabled()) {
                this.getContainer().getLogger().debug((Object)("ClusteredSSO: removed stopped manager " + source.toString()));
            }
        }
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        SingleSignOnEntry entry;
        request.removeNote("org.apache.catalina.request.SSOID");
        if (this.getContainer().getLogger().isDebugEnabled()) {
            this.getContainer().getLogger().debug((Object)("Process request for '" + request.getRequestURI() + "'"));
        }
        if (request.getUserPrincipal() != null) {
            if (this.getContainer().getLogger().isDebugEnabled()) {
                this.getContainer().getLogger().debug((Object)(" Principal '" + request.getUserPrincipal().getName() + "' has already been authenticated"));
            }
            this.getNext().invoke(request, response);
            return;
        }
        Cookie cookie = null;
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            cookies = new Cookie[]{};
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!"JSESSIONIDSSO".equals(cookies[i].getName())) continue;
            cookie = cookies[i];
            break;
        }
        if (cookie == null) {
            if (this.getContainer().getLogger().isDebugEnabled()) {
                this.getContainer().getLogger().debug((Object)" SSO cookie is not present");
            }
            this.getNext().invoke(request, response);
            return;
        }
        String ssoId = cookie.getValue();
        if (this.getContainer().getLogger().isDebugEnabled()) {
            this.getContainer().getLogger().debug((Object)(" Checking for cached principal for " + ssoId));
        }
        if ((entry = this.getSingleSignOnEntry(cookie.getValue())) != null && this.isValid(ssoId, entry)) {
            Principal ssoPrinc = entry.getPrincipal();
            if (this.getContainer().getLogger().isDebugEnabled()) {
                this.getContainer().getLogger().debug((Object)(" Found cached principal '" + (ssoPrinc == null ? "NULL" : ssoPrinc.getName()) + "' with auth type '" + entry.getAuthType() + "'"));
            }
            request.setNote("org.apache.catalina.request.SSOID", (Object)cookie.getValue());
            if (!this.getRequireReauthentication() && ssoPrinc != null) {
                request.setAuthType(entry.getAuthType());
                request.setUserPrincipal(ssoPrinc);
            }
        } else {
            if (this.getContainer().getLogger().isDebugEnabled()) {
                this.getContainer().getLogger().debug((Object)" No cached principal found, erasing SSO cookie");
            }
            cookie.setMaxAge(0);
            response.addCookie(cookie);
        }
        this.getNext().invoke(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associate(String ssoId, Session session) {
        if (this.getContainer().getLogger().isDebugEnabled()) {
            this.getContainer().getLogger().debug((Object)("Associate sso id " + ssoId + " with session " + session));
        }
        SingleSignOnEntry sso = this.getSingleSignOnEntry(ssoId);
        boolean added = false;
        if (sso != null) {
            added = sso.addSession(this, session);
        }
        Map map = this.reverse;
        synchronized (map) {
            this.reverse.put(session, ssoId);
        }
        if (added) {
            Manager manager = session.getManager();
            ObjectName mgrKey = null;
            if (manager instanceof ManagerBase) {
                mgrKey = ((ManagerBase)manager).getObjectName();
            } else if (manager instanceof JBossManager) {
                mgrKey = ((JBossManager)manager).getObjectName();
            } else if (manager instanceof Lifecycle) {
                mgrKey = manager;
            } else {
                this.getContainer().getLogger().warn((Object)("Manager for session " + session.getIdInternal() + " does not implement Lifecycle; web app shutdown may " + " lead to incorrect SSO invalidations"));
            }
            if (mgrKey != null) {
                Set set = this.activeManagers;
                synchronized (set) {
                    if (!this.activeManagers.contains(mgrKey)) {
                        this.activeManagers.add(mgrKey);
                        ((Lifecycle)manager).addLifecycleListener((LifecycleListener)this);
                    }
                }
            }
            if (this.ssoClusterManager != null) {
                this.ssoClusterManager.addSession(ssoId, session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregister(String ssoId, Session session) {
        Map map = this.reverse;
        synchronized (map) {
            this.reverse.remove(session);
        }
        SingleSignOnEntry sso = this.getSingleSignOnEntry(ssoId);
        if (sso == null) {
            return;
        }
        boolean removed = sso.removeSession(session);
        if (removed && this.ssoClusterManager != null) {
            this.ssoClusterManager.removeSession(ssoId, session);
        }
        if (sso.getSessionCount() == 0) {
            Map map2 = this.cache;
            synchronized (map2) {
                sso = (SingleSignOnEntry)this.cache.remove(ssoId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(String ssoId) {
        if (this.getContainer().getLogger().isDebugEnabled()) {
            this.getContainer().getLogger().debug((Object)("Deregistering sso id '" + ssoId + "'"));
        }
        this.emptySSOs.remove(ssoId);
        SingleSignOnEntry sso = null;
        Map map = this.cache;
        synchronized (map) {
            sso = (SingleSignOnEntry)this.cache.remove(ssoId);
        }
        if (sso == null) {
            return;
        }
        Session[] sessions = sso.findSessions();
        for (int i = 0; i < sessions.length; ++i) {
            if (this.getContainer().getLogger().isDebugEnabled()) {
                this.getContainer().getLogger().debug((Object)(" Invalidating session " + sessions[i]));
            }
            Map map2 = this.reverse;
            synchronized (map2) {
                this.reverse.remove(sessions[i]);
            }
            sessions[i].expire();
        }
    }

    protected void logout(String ssoId) {
        this.deregister(ssoId);
        if (this.ssoClusterManager != null) {
            this.ssoClusterManager.logout(ssoId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SingleSignOnEntry getSingleSignOnEntry(String ssoId) {
        SingleSignOnEntry sso = this.localLookup(ssoId);
        if (sso == null && this.ssoClusterManager != null && (sso = this.ssoClusterManager.lookup(ssoId)) != null) {
            Map map = this.cache;
            synchronized (map) {
                this.cache.put(ssoId, sso);
            }
        }
        return sso;
    }

    protected boolean reauthenticate(String ssoId, Realm realm, Request request) {
        Principal reauthPrincipal;
        String username;
        if (ssoId == null || realm == null) {
            return false;
        }
        boolean reauthenticated = false;
        SingleSignOnEntry entry = this.getSingleSignOnEntry(ssoId);
        if (entry != null && entry.getCanReauthenticate() && (username = entry.getUsername()) != null && (reauthPrincipal = realm.authenticate(username, entry.getPassword())) != null) {
            reauthenticated = true;
            request.setAuthType(entry.getAuthType());
            request.setUserPrincipal(reauthPrincipal);
            entry.setPrincipal(reauthPrincipal);
        }
        return reauthenticated;
    }

    public void register(String ssoId, Principal principal, String authType, String username, String password) {
        this.registerLocal(ssoId, principal, authType, username, password);
        if (this.ssoClusterManager != null) {
            this.ssoClusterManager.register(ssoId, authType, username, password);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSession(String ssoId, Session session) {
        SingleSignOnEntry entry;
        if (this.getContainer().getLogger().isDebugEnabled()) {
            this.getContainer().getLogger().debug((Object)("Removing session " + session.toString() + " from sso id " + ssoId));
        }
        if ((entry = this.getSingleSignOnEntry(ssoId)) == null) {
            return;
        }
        boolean removed = entry.removeSession(session);
        if (removed && this.ssoClusterManager != null) {
            this.ssoClusterManager.removeSession(ssoId, session);
        }
        Map map = this.reverse;
        synchronized (map) {
            this.reverse.remove(session);
        }
    }

    public void update(String ssoId, Principal principal, String authType, String username, String password) {
        boolean needToBroadcast = this.updateLocal(ssoId, principal, authType, username, password);
        if (needToBroadcast && this.ssoClusterManager != null) {
            this.ssoClusterManager.updateCredentials(ssoId, authType, username, password);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SingleSignOnEntry localLookup(String ssoId) {
        Map map = this.cache;
        synchronized (map) {
            return (SingleSignOnEntry)this.cache.get(ssoId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerLocal(String ssoId, Principal principal, String authType, String username, String password) {
        if (this.getContainer().getLogger().isDebugEnabled()) {
            this.getContainer().getLogger().debug((Object)("Registering sso id '" + ssoId + "' for user '" + principal.getName() + "' with auth type '" + authType + "'"));
        }
        Map map = this.cache;
        synchronized (map) {
            this.cache.put(ssoId, new SingleSignOnEntry(principal, authType, username, password));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateLocal(String ssoId, Principal principal, String authType, String username, String password) {
        boolean shouldBroadcast = false;
        SingleSignOnEntry sso = this.getSingleSignOnEntry(ssoId);
        if (sso != null) {
            if (!sso.getCanReauthenticate()) {
                if (this.getContainer().getLogger().isDebugEnabled()) {
                    this.getContainer().getLogger().debug((Object)("Update sso id " + ssoId + " to auth type " + authType));
                }
                SingleSignOnEntry singleSignOnEntry = sso;
                synchronized (singleSignOnEntry) {
                    shouldBroadcast = sso.updateCredentials(principal, authType, username, password);
                }
            }
            if (sso.getPrincipal() == null && principal != null) {
                if (this.getContainer().getLogger().isDebugEnabled()) {
                    this.getContainer().getLogger().debug((Object)("Update sso id " + ssoId + " with principal " + principal.getName()));
                }
                SingleSignOnEntry singleSignOnEntry = sso;
                synchronized (singleSignOnEntry) {
                    sso.setPrincipal(principal);
                }
            }
        }
        return shouldBroadcast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remoteUpdate(String ssoId, String authType, String username, String password) {
        SingleSignOnEntry sso = this.getSingleSignOnEntry(ssoId);
        if (sso != null && !sso.getCanReauthenticate()) {
            if (this.getContainer().getLogger().isDebugEnabled()) {
                this.getContainer().getLogger().debug((Object)("Update sso id " + ssoId + " to auth type " + authType));
            }
            SingleSignOnEntry singleSignOnEntry = sso;
            synchronized (singleSignOnEntry) {
                Principal p = sso.getPrincipal();
                sso.updateCredentials(p, authType, username, password);
            }
        }
    }

    protected void notifySSOEmpty(String ssoId) {
        Long obj = this.emptySSOs.put(ssoId, new Long(System.currentTimeMillis()));
        if (obj == null && this.getContainer().getLogger().isDebugEnabled()) {
            this.getContainer().getLogger().debug((Object)("Notified that SSO " + ssoId + " is empty"));
        }
    }

    protected void notifySSONotEmpty(String ssoId) {
        Object obj = this.emptySSOs.remove(ssoId);
        if (obj != null && this.getContainer().getLogger().isDebugEnabled()) {
            this.getContainer().getLogger().debug((Object)("Notified that SSO " + ssoId + " is no longer empty"));
        }
    }

    private void createClusterManager(String className) throws LifecycleException {
        if (this.ssoClusterManager != null) {
            return;
        }
        if (className != null) {
            SSOClusterManager mgr = null;
            try {
                ClassLoader tcl = Thread.currentThread().getContextClassLoader();
                Class<?> clazz = tcl.loadClass(className);
                mgr = (SSOClusterManager)clazz.newInstance();
                mgr.setSingleSignOnValve(this);
                if (mgr instanceof TreeCacheSSOClusterManager) {
                    ((TreeCacheSSOClusterManager)mgr).setCacheName(this.getTreeCacheName());
                }
                this.ssoClusterManager = mgr;
                this.clusterManagerClass = className;
            }
            catch (Throwable t) {
                throw new LifecycleException("Cannot create SSOClusterManager using " + className, t);
            }
            if (this.started) {
                this.ssoClusterManager.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processExpires() {
        long now = 0L;
        Object object = this.mutex;
        synchronized (object) {
            now = System.currentTimeMillis();
            if (now - this.lastProcessExpires <= (long)this.processExpiresInterval) {
                return;
            }
            this.lastProcessExpires = now;
        }
        this.clearExpiredSSOs(now);
    }

    private synchronized void clearExpiredSSOs(long now) {
        for (Map.Entry entry : this.emptySSOs.entrySet()) {
            if (now - (Long)entry.getValue() <= (long)this.maxEmptyLife) continue;
            String ssoId = (String)entry.getKey();
            if (this.getContainer().getLogger().isDebugEnabled()) {
                this.getContainer().getLogger().debug((Object)("Invalidating expired SSO " + ssoId));
            }
            this.logout(ssoId);
        }
    }

    private boolean isValid(String ssoId, SingleSignOnEntry entry) {
        Long expired;
        boolean valid = true;
        if (entry.getSessionCount() == 0 && (expired = (Long)this.emptySSOs.get(ssoId)) != null && System.currentTimeMillis() - expired > (long)this.maxEmptyLife) {
            valid = false;
            if (this.getContainer().getLogger().isDebugEnabled()) {
                this.getContainer().getLogger().debug((Object)("Invalidating expired SSO " + ssoId));
            }
            this.logout(ssoId);
        }
        return valid;
    }

    static {
        info = ClusteredSingleSignOn.class.getName();
    }
}

