/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos.applets;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Random;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Channel;
import org.jgroups.ChannelFactory;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.JChannelFactory;
import org.jgroups.Message;
import org.jgroups.View;

public class DrawApplet
extends Applet
implements Runnable,
MouseMotionListener,
ActionListener {
    private Graphics graphics = null;
    private Panel panel = null;
    private Panel sub_panel = null;
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();
    private DataOutputStream outstream;
    private DataInputStream instream;
    private final Random random = new Random(System.currentTimeMillis());
    private Button clear_button;
    private Button leave_button;
    private Label mbr_label;
    private final Font default_font = new Font("Helvetica", 0, 12);
    private final String groupname = "DrawGroup";
    private Channel channel = null;
    private Thread receiver = null;
    private int member_size = 1;
    private int red = 0;
    private int green = 0;
    private int blue = 0;
    private Color default_color = null;
    private final ChannelFactory factory = new JChannelFactory();
    private String props = "TUNNEL(router_host=janet;router_port=12002):PING(gossip_host=janet;gossip_port=12002):FD:STABLE:NAKACK:UNICAST:FRAG:FLUSH:GMS:VIEW_ENFORCER:QUEUE";
    private final Vector members = new Vector();
    private boolean fl = true;
    Log log = LogFactory.getLog(this.getClass());

    public void init() {
        System.out.println("INIT");
        this.setLayout(new BorderLayout());
        String tmp_props = this.getParameter("properties");
        if (tmp_props != null) {
            System.out.println("Setting parameters " + tmp_props);
            this.props = tmp_props;
        }
        try {
            this.channel = this.factory.createChannel(this.props);
            this.showStatus("Connecting to group DrawGroup");
            this.channel.connect("DrawGroup");
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
        this.receiver = new Thread((Runnable)this, "DrawThread");
        this.receiver.start();
        this.go();
    }

    public void start() {
        System.out.println("------- START");
    }

    public void destroy() {
        System.out.println("------- DESTROY");
        if (this.receiver != null && this.receiver.isAlive()) {
            this.fl = false;
            this.receiver.interrupt();
            try {
                this.receiver.join(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.receiver = null;
        this.showStatus("Disconnecting from DrawGroup");
        this.channel.disconnect();
        this.showStatus("Disconnected");
    }

    public void paint(Graphics g) {
        Rectangle bounds = this.panel.getBounds();
        Color old = this.graphics.getColor();
        if (bounds == null || this.graphics == null) {
            return;
        }
        this.graphics.setColor(Color.black);
        this.graphics.drawRect(0, 0, bounds.width - 1, bounds.height - 1);
        this.graphics.setColor(old);
    }

    private void selectColor() {
        this.red = Math.abs(this.random.nextInt()) % 255;
        this.green = Math.abs(this.random.nextInt()) % 255;
        this.blue = Math.abs(this.random.nextInt()) % 255;
        this.default_color = new Color(this.red, this.green, this.blue);
    }

    public void go() {
        try {
            this.panel = new Panel();
            this.sub_panel = new Panel();
            this.resize(200, 200);
            this.add("Center", this.panel);
            this.clear_button = new Button("Clear");
            this.clear_button.setFont(this.default_font);
            this.clear_button.addActionListener(this);
            this.leave_button = new Button("Exit");
            this.leave_button.setFont(this.default_font);
            this.leave_button.addActionListener(this);
            this.mbr_label = new Label("0 mbr(s)");
            this.mbr_label.setFont(this.default_font);
            this.sub_panel.add("South", this.clear_button);
            this.sub_panel.add("South", this.leave_button);
            this.sub_panel.add("South", this.mbr_label);
            this.add("South", this.sub_panel);
            this.panel.addMouseMotionListener(this);
            this.setVisible(true);
            this.mbr_label.setText(this.member_size + " mbrs");
            this.graphics = this.panel.getGraphics();
            this.selectColor();
            this.graphics.setColor(this.default_color);
            this.panel.setBackground(Color.white);
            this.clear_button.setForeground(Color.blue);
            this.leave_button.setForeground(Color.blue);
        }
        catch (Exception e) {
            this.log.error((Object)e);
            return;
        }
    }

    public void run() {
        Message msg = null;
        int my_x = 10;
        int my_y = 10;
        int r = 0;
        int g = 0;
        int b = 0;
        while (this.fl) {
            my_x = 10;
            my_y = 10;
            try {
                Object tmp = this.channel.receive(0L);
                if (tmp instanceof View) {
                    this.viewAccepted((View)tmp);
                    continue;
                }
                if (!(tmp instanceof Message)) continue;
                msg = (Message)tmp;
                if (msg == null || msg.getLength() == 0) {
                    this.log.error((Object)"DrawApplet.run(): msg or msg.buffer is null !");
                    continue;
                }
                this.instream = new DataInputStream(new ByteArrayInputStream(msg.getRawBuffer(), msg.getOffset(), msg.getLength()));
                r = this.instream.readInt();
                if (r == -13) {
                    this.clearPanel();
                    continue;
                }
                g = this.instream.readInt();
                b = this.instream.readInt();
                my_x = this.instream.readInt();
                my_y = this.instream.readInt();
            }
            catch (ChannelNotConnectedException conn) {
                break;
            }
            catch (Exception e) {
                this.log.error((Object)e);
            }
            if (this.graphics == null) continue;
            this.graphics.setColor(new Color(r, g, b));
            this.graphics.fillOval(my_x, my_y, 10, 10);
            this.graphics.setColor(this.default_color);
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        int[] tmp = new int[]{0};
        int x = e.getX();
        int y = e.getY();
        this.graphics.fillOval(x, y, 10, 10);
        try {
            this.out.reset();
            this.outstream = new DataOutputStream(this.out);
            this.outstream.writeInt(this.red);
            this.outstream.writeInt(this.green);
            this.outstream.writeInt(this.blue);
            this.outstream.writeInt(x);
            this.outstream.writeInt(y);
            this.channel.send(new Message(null, null, this.out.toByteArray()));
            this.out.reset();
        }
        catch (Exception ex) {
            this.log.error((Object)ex);
        }
    }

    public void clearPanel() {
        Rectangle bounds = null;
        if (this.panel == null || this.graphics == null) {
            return;
        }
        bounds = this.panel.getBounds();
        this.graphics.clearRect(1, 1, bounds.width - 2, bounds.height - 2);
    }

    public void sendClearPanelMsg() {
        int[] tmp = new int[]{0};
        this.clearPanel();
        try {
            this.out.reset();
            this.outstream = new DataOutputStream(this.out);
            this.outstream.writeInt(-13);
            this.channel.send(new Message(null, null, this.out.toByteArray()));
            this.outstream.flush();
        }
        catch (Exception ex) {
            this.log.error((Object)ex);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command == "Clear") {
            System.out.println("Members are " + this.members);
            this.sendClearPanelMsg();
        } else if (command == "Exit") {
            try {
                this.destroy();
                this.setVisible(false);
            }
            catch (Exception ex) {
                this.log.error((Object)ex);
            }
        } else {
            System.out.println("Unknown action");
        }
    }

    public void viewAccepted(View v) {
        Vector mbrs = v.getMembers();
        if (v != null) {
            System.out.println("View accepted: " + v);
            this.member_size = v.size();
            if (this.mbr_label != null) {
                this.mbr_label.setText(this.member_size + " mbr(s)");
            }
            this.members.removeAllElements();
            for (int i = 0; i < mbrs.size(); ++i) {
                this.members.addElement(mbrs.elementAt(i));
            }
        }
    }
}

