/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache.augeas;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.augeas.config.AugeasModuleConfig;
import org.rhq.augeas.util.Glob;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.rhqtransform.AugeasRhqException;
import org.rhq.rhqtransform.impl.PluginDescriptorBasedAugeasConfiguration;

public class AugeasConfigurationApache
extends PluginDescriptorBasedAugeasConfiguration {
    public static final String INCLUDE_DIRECTIVE = "Include";
    private static final String INCLUDE_FILES_PATTERN = "^[\t ]*Include[\t ]+(.*)$";
    private static final String SERVER_ROOT_PATTERN = "^[\t ]*ServerRoot[\t ]+[\"]?([^\"\n]*)[\"]?$";
    private final Pattern includePattern = Pattern.compile("^[\t ]*Include[\t ]+(.*)$");
    private final Pattern serverRootPattern = Pattern.compile("^[\t ]*ServerRoot[\t ]+[\"]?([^\"\n]*)[\"]?$");
    private static final Log LOG = LogFactory.getLog(AugeasConfigurationApache.class);
    private String serverRootPath;
    private AugeasModuleConfig module;
    private List<File> allConfigFiles;

    public String getServerRootPath() {
        return this.serverRootPath;
    }

    public AugeasConfigurationApache(String path, Configuration configuration) throws AugeasRhqException {
        super(path, configuration);
        this.serverRootPath = configuration.getSimpleValue("serverRoot", null);
        if (this.modules.isEmpty()) {
            throw new AugeasRhqException("There is not configuration for this resource.");
        }
        try {
            this.module = (AugeasModuleConfig)this.modules.get(0);
            ArrayList<String> foundIncludes = new ArrayList<String>();
            this.loadIncludes((String)this.module.getIncludedGlobs().get(0), foundIncludes);
            this.allConfigFiles = AugeasConfigurationApache.getIncludeFiles(this.serverRootPath, foundIncludes);
        }
        catch (Exception e) {
            throw new AugeasRhqException((Throwable)e);
        }
    }

    public String getAugeasModuleName() {
        return this.module.getModuletName();
    }

    public List<String> getIncludes(File file) {
        ArrayList<String> includeFiles = new ArrayList<String>();
        return includeFiles;
    }

    public List<File> getAllConfigurationFiles() {
        return this.allConfigFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIncludes(String expression, List<String> foundIncludes) {
        try {
            ArrayList files = new ArrayList();
            File check = new File(expression);
            File root = new File(check.isAbsolute() ? Glob.rootPortion((String)expression) : this.serverRootPath);
            files.addAll(Glob.match((File)root, (String)expression, (Comparator)Glob.ALPHABETICAL_COMPARATOR));
            for (File fl : files) {
                if (!fl.exists() || !fl.isFile()) continue;
                foundIncludes.add(fl.getAbsolutePath());
                BufferedReader br = null;
                try {
                    String strLine;
                    br = new BufferedReader(new InputStreamReader(new FileInputStream(fl)));
                    while ((strLine = br.readLine()) != null) {
                        Matcher serverRootMatcher;
                        Matcher m = this.includePattern.matcher(strLine);
                        if (m.matches()) {
                            String glob = m.group(1);
                            this.module.addIncludedGlob(glob);
                            this.loadIncludes(glob, foundIncludes);
                        }
                        if (!(serverRootMatcher = this.serverRootPattern.matcher(strLine)).matches()) continue;
                        this.serverRootPath = serverRootMatcher.group(1);
                    }
                }
                finally {
                    if (br == null) continue;
                    br.close();
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void loadFiles() {
        for (AugeasModuleConfig module : this.modules) {
            List includeGlobs = module.getIncludedGlobs();
            if (includeGlobs.size() <= 0) {
                throw new IllegalStateException("Expecting at least once inclusion pattern for configuration files.");
            }
            ArrayList files = new ArrayList();
            for (String incl : includeGlobs) {
                File check = new File(incl);
                File root = new File(check.isAbsolute() ? Glob.rootPortion((String)incl) : this.serverRootPath);
                files.addAll(Glob.match((File)root, (String)incl, (Comparator)Glob.ALPHABETICAL_COMPARATOR));
            }
            if (module.getExcludedGlobs() != null) {
                List excludeGlobs = module.getExcludedGlobs();
                Glob.excludeAll(files, (List)excludeGlobs);
            }
            for (File configFile : files) {
                if (!configFile.isAbsolute()) {
                    LOG.warn((Object)("Configuration files inclusion patterns contain a non-absolute file: " + configFile));
                    continue;
                }
                if (!configFile.exists()) {
                    LOG.warn((Object)("Configuration files inclusion patterns refer to a non-existent file: " + configFile));
                    continue;
                }
                if (configFile.isDirectory()) {
                    LOG.warn((Object)("Configuration files inclusion patterns refer to a directory: " + configFile));
                    continue;
                }
                if (module.getConfigFiles().contains(configFile.getAbsolutePath())) continue;
                module.addConfigFile(configFile.getAbsolutePath());
            }
        }
    }

    private static List<File> getIncludeFiles(String serverRoot, List<String> foundIncludes) {
        ArrayList<File> ret = new ArrayList<File>();
        for (String path : foundIncludes) {
            File check = new File(path);
            File root = new File(check.isAbsolute() ? Glob.rootPortion((String)path) : serverRoot);
            for (File f : Glob.match((File)root, (String)path, (Comparator)Glob.ALPHABETICAL_COMPARATOR)) {
                ret.add(f);
            }
        }
        return ret;
    }
}

