/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import javax.ejb.EJBException;
import javax.ejb.TransactionRequiredLocalException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionRequiredException;
import javax.transaction.TransactionRolledbackException;
import org.jboss.ejb.plugins.AbstractTxInterceptor;
import org.jboss.ejb.plugins.SecurityActions;
import org.jboss.ejb.plugins.TxRetryExceptionHandler;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvocationType;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.XmlLoadable;
import org.jboss.tm.JBossTransactionRolledbackException;
import org.jboss.tm.JBossTransactionRolledbackLocalException;
import org.jboss.tm.TransactionTimeoutConfiguration;
import org.jboss.util.NestedException;
import org.jboss.util.deadlock.ApplicationDeadlockException;
import org.w3c.dom.Element;

public class TxInterceptorCMT
extends AbstractTxInterceptor
implements XmlLoadable {
    public static int MAX_RETRIES = 5;
    public static Random random = new Random();
    private boolean exceptionRollback = true;
    private TxRetryExceptionHandler[] retryHandlers = null;

    public static ApplicationDeadlockException isADE(Throwable t) {
        while (t != null) {
            if (t instanceof ApplicationDeadlockException) {
                return (ApplicationDeadlockException)t;
            }
            if (t instanceof RemoteException) {
                t = ((RemoteException)t).detail;
                continue;
            }
            if (t instanceof EJBException) {
                t = ((EJBException)t).getCausedByException();
                continue;
            }
            return null;
        }
        return null;
    }

    public void importXml(Element ielement) {
        try {
            Element element = MetaData.getOptionalChild(ielement, "retry-handlers");
            if (element == null) {
                return;
            }
            ArrayList list = new ArrayList();
            Iterator handlers = MetaData.getChildrenByTagName(element, "handler");
            while (handlers.hasNext()) {
                Element handler = (Element)handlers.next();
                String className = MetaData.getElementContent(handler).trim();
                Class<?> clazz = SecurityActions.getContextClassLoader().loadClass(className);
                list.add(clazz.newInstance());
            }
            this.retryHandlers = list.toArray(new TxRetryExceptionHandler[list.size()]);
        }
        catch (Exception ex) {
            this.log.warn((Object)"Unable to importXml for the TxInterceptorCMT", (Throwable)ex);
        }
    }

    public void create() throws Exception {
        super.create();
        BeanMetaData bmd = this.getContainer().getBeanMetaData();
        this.exceptionRollback = bmd.getExceptionRollback();
        if (!this.exceptionRollback) {
            this.exceptionRollback = bmd.getApplicationMetaData().getExceptionRollback();
        }
    }

    public Object invokeHome(Invocation invocation) throws Exception {
        Transaction oldTransaction = invocation.getTransaction();
        for (int i = 0; i < MAX_RETRIES; ++i) {
            try {
                return this.runWithTransactions(invocation);
            }
            catch (Exception ex) {
                this.checkRetryable(i, ex, oldTransaction);
                continue;
            }
        }
        throw new RuntimeException("Unreachable");
    }

    public Object invoke(Invocation invocation) throws Exception {
        Transaction oldTransaction = invocation.getTransaction();
        for (int i = 0; i < MAX_RETRIES; ++i) {
            try {
                return this.runWithTransactions(invocation);
            }
            catch (Exception ex) {
                this.checkRetryable(i, ex, oldTransaction);
                continue;
            }
        }
        throw new RuntimeException("Unreachable");
    }

    private void checkRetryable(int i, Exception ex, Transaction oldTransaction) throws Exception {
        if (i + 1 >= MAX_RETRIES || oldTransaction != null) {
            throw ex;
        }
        ApplicationDeadlockException deadlock = TxInterceptorCMT.isADE(ex);
        if (deadlock != null) {
            if (!deadlock.retryable()) {
                throw deadlock;
            }
            this.log.debug((Object)(deadlock.getMessage() + " retrying tx " + (i + 1)));
        } else if (this.retryHandlers != null) {
            boolean retryable = false;
            for (int j = 0; j < this.retryHandlers.length && !(retryable = this.retryHandlers[j].retry(ex)); ++j) {
            }
            if (!retryable) {
                throw ex;
            }
            this.log.debug((Object)(ex.getMessage() + " retrying tx " + (i + 1)));
        } else {
            throw ex;
        }
        Thread.sleep(random.nextInt(1 + i), random.nextInt(1000));
    }

    private void printMethod(Method m, byte type) {
        String txName;
        switch (type) {
            case 4: {
                txName = "TX_MANDATORY";
                break;
            }
            case 5: {
                txName = "TX_NEVER";
                break;
            }
            case 0: {
                txName = "TX_NOT_SUPPORTED";
                break;
            }
            case 1: {
                txName = "TX_REQUIRED";
                break;
            }
            case 3: {
                txName = "TX_REQUIRES_NEW";
                break;
            }
            case 2: {
                txName = "TX_SUPPORTS";
                break;
            }
            default: {
                txName = "TX_UNKNOWN";
            }
        }
        String methodName = m != null ? m.getName() : "<no method>";
        if (this.log.isTraceEnabled()) {
            if (m != null && (type == 1 || type == 3)) {
                this.log.trace((Object)(txName + " for " + methodName + " timeout=" + this.container.getBeanMetaData().getTransactionTimeout(methodName)));
            } else {
                this.log.trace((Object)(txName + " for " + methodName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object runWithTransactions(Invocation invocation) throws Exception {
        block46: {
            block45: {
                block44: {
                    block43: {
                        block42: {
                            block41: {
                                block40: {
                                    oldTransaction = invocation.getTransaction();
                                    newTransaction = null;
                                    trace = this.log.isTraceEnabled();
                                    if (trace) {
                                        this.log.trace((Object)("Current transaction in MI is " + oldTransaction));
                                    }
                                    type = invocation.getType();
                                    transType = this.container.getBeanMetaData().getTransactionMethod(invocation.getMethod(), type);
                                    if (trace) {
                                        this.printMethod(invocation.getMethod(), transType);
                                    }
                                    threadTx = this.tm.suspend();
                                    if (trace) {
                                        this.log.trace((Object)("Thread came in with tx " + threadTx));
                                    }
                                    try {
                                        switch (transType) {
                                            case 0: {
                                                try {
                                                    invocation.setTransaction(null);
                                                    var8_8 = this.invokeNext(invocation, false);
                                                    var10_14 = null;
                                                    invocation.setTransaction(oldTransaction);
                                                }
                                                catch (Throwable var9_26) {
                                                    var10_15 = null;
                                                    invocation.setTransaction(oldTransaction);
                                                    throw var9_26;
                                                }
                                            }
                                            var21_18 = null;
                                            if (threadTx == null) return var8_8;
                                            break block40;
                                            case 1: {
                                                oldTimeout = 0;
                                                theTransaction = oldTransaction;
                                                if (oldTransaction == null) {
                                                    oldTimeout = this.startTransaction(invocation);
                                                    newTransaction = this.tm.getTransaction();
                                                    if (trace) {
                                                        this.log.trace((Object)("Starting new tx " + newTransaction));
                                                    }
                                                    invocation.setTransaction(newTransaction);
                                                    theTransaction = newTransaction;
                                                } else {
                                                    this.tm.resume(oldTransaction);
                                                }
                                                try {
                                                    result = this.invokeNext(invocation, oldTransaction != null);
                                                    this.checkTransactionStatus(theTransaction, type);
                                                    var11_31 = result;
                                                    var13_32 = null;
                                                    if (trace) {
                                                    }
                                                    ** GOTO lbl64
                                                }
                                                catch (Throwable var12_34) {
                                                    var13_33 = null;
                                                    if (trace) {
                                                        this.log.trace((Object)"TxInterceptorCMT: In finally");
                                                    }
                                                    if (newTransaction != null) {
                                                        this.endTransaction(invocation, newTransaction, oldTransaction, oldTimeout);
                                                        throw var12_34;
                                                    }
                                                    this.tm.suspend();
                                                    throw var12_34;
                                                }
                                                this.log.trace((Object)"TxInterceptorCMT: In finally");
lbl64:
                                                // 2 sources

                                                if (newTransaction != null) {
                                                    this.endTransaction(invocation, newTransaction, oldTransaction, oldTimeout);
                                                    break block41;
                                                } else {
                                                    this.tm.suspend();
                                                }
                                                break block41;
                                            }
                                            case 2: {
                                                if (oldTransaction != null) {
                                                    this.tm.resume(oldTransaction);
                                                }
                                                try {
                                                    result = this.invokeNext(invocation, oldTransaction != null);
                                                    if (oldTransaction != null) {
                                                        this.checkTransactionStatus(oldTransaction, type);
                                                    }
                                                    theTransaction = result;
                                                    var15_35 = null;
                                                }
                                                catch (Throwable var14_37) {
                                                    var15_36 = null;
                                                    this.tm.suspend();
                                                    throw var14_37;
                                                }
                                                this.tm.suspend();
                                                break block42;
                                            }
                                            case 3: {
                                                oldTimeout = this.startTransaction(invocation);
                                                newTransaction = this.tm.getTransaction();
                                                invocation.setTransaction(newTransaction);
                                                try {
                                                    result = this.invokeNext(invocation, false);
                                                    this.checkTransactionStatus(newTransaction, type);
                                                    var10_17 = result;
                                                    var17_38 = null;
                                                }
                                                catch (Throwable var16_40) {
                                                    var17_39 = null;
                                                    this.endTransaction(invocation, newTransaction, oldTransaction, oldTimeout);
                                                    throw var16_40;
                                                }
                                                this.endTransaction(invocation, newTransaction, oldTransaction, oldTimeout);
                                                break block43;
                                            }
                                            case 4: {
                                                if (oldTransaction == null) {
                                                    if (type == InvocationType.LOCAL) throw new TransactionRequiredLocalException("Transaction Required");
                                                    if (type != InvocationType.LOCALHOME) throw new TransactionRequiredException("Transaction Required");
                                                    throw new TransactionRequiredLocalException("Transaction Required");
                                                }
                                                this.tm.resume(oldTransaction);
                                                try {
                                                    result = this.invokeNext(invocation, true);
                                                    this.checkTransactionStatus(oldTransaction, type);
                                                    var9_30 = result;
                                                    var19_41 = null;
                                                }
                                                catch (Throwable var18_43) {
                                                    var19_42 = null;
                                                    this.tm.suspend();
                                                    throw var18_43;
                                                }
                                                this.tm.suspend();
                                                break block44;
                                            }
                                            case 5: {
                                                if (oldTransaction != null) {
                                                    throw new EJBException("Transaction not allowed");
                                                }
                                                var8_13 = this.invokeNext(invocation, false);
                                                break block45;
                                            }
                                            default: {
                                                this.log.error((Object)("Unknown TX attribute " + transType + " for method" + invocation.getMethod()));
                                                break;
                                            }
                                        }
                                        break block46;
                                    }
                                    catch (Throwable var20_44) {
                                        var21_25 = null;
                                        if (threadTx == null) throw var20_44;
                                        this.tm.resume(threadTx);
                                        throw var20_44;
                                    }
                                }
                                this.tm.resume(threadTx);
                                return var8_8;
                            }
                            var21_19 = null;
                            if (threadTx == null) return var11_31;
                            this.tm.resume(threadTx);
                            return var11_31;
                        }
                        var21_20 = null;
                        if (threadTx == null) return theTransaction;
                        this.tm.resume(threadTx);
                        return theTransaction;
                    }
                    var21_21 = null;
                    if (threadTx == null) return var10_17;
                    this.tm.resume(threadTx);
                    return var10_17;
                }
                var21_22 = null;
                if (threadTx == null) return var9_30;
                this.tm.resume(threadTx);
                return var9_30;
            }
            var21_23 = null;
            if (threadTx == null) return var8_13;
            this.tm.resume(threadTx);
            return var8_13;
        }
        var21_24 = null;
        if (threadTx == null) return null;
        this.tm.resume(threadTx);
        return null;
    }

    private int startTransaction(Invocation invocation) throws Exception {
        int oldTimeout = -1;
        if (this.tm instanceof TransactionTimeoutConfiguration) {
            oldTimeout = ((TransactionTimeoutConfiguration)this.tm).getTransactionTimeout();
            int newTimeout = this.container.getBeanMetaData().getTransactionTimeout(invocation.getMethod());
            this.tm.setTransactionTimeout(newTimeout);
        }
        this.tm.begin();
        return oldTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void endTransaction(Invocation invocation, Transaction tx, Transaction oldTx, int oldTimeout) throws TransactionRolledbackException, SystemException {
        Transaction current = this.tm.getTransaction();
        if (tx == null) {
            if (current != null) throw new IllegalStateException("Wrong transaction association: expected " + tx + " was " + current);
        }
        if (!tx.equals(current)) {
            throw new IllegalStateException("Wrong transaction association: expected " + tx + " was " + current);
        }
        try {
            try {
                if (tx.getStatus() == 1) {
                    tx.rollback();
                }
                tx.commit();
            }
            catch (RollbackException e) {
                this.throwJBossException((Exception)((Object)e), invocation.getType());
                Object var8_7 = null;
                invocation.setTransaction(oldTx);
                this.tm.suspend();
                if (oldTimeout == -1) return;
                this.tm.setTransactionTimeout(oldTimeout);
                return;
            }
            catch (HeuristicMixedException e) {
                this.throwJBossException((Exception)((Object)e), invocation.getType());
                Object var8_8 = null;
                invocation.setTransaction(oldTx);
                this.tm.suspend();
                if (oldTimeout == -1) return;
                this.tm.setTransactionTimeout(oldTimeout);
                return;
            }
            catch (HeuristicRollbackException e) {
                this.throwJBossException((Exception)((Object)e), invocation.getType());
                Object var8_9 = null;
                invocation.setTransaction(oldTx);
                this.tm.suspend();
                if (oldTimeout == -1) return;
                this.tm.setTransactionTimeout(oldTimeout);
                return;
            }
            catch (SystemException e) {
                this.throwJBossException((Exception)((Object)e), invocation.getType());
                Object var8_10 = null;
                invocation.setTransaction(oldTx);
                this.tm.suspend();
                if (oldTimeout == -1) return;
                this.tm.setTransactionTimeout(oldTimeout);
                return;
            }
            catch (IllegalStateException e) {
                this.throwJBossException(e, invocation.getType());
                Object var8_11 = null;
                invocation.setTransaction(oldTx);
                this.tm.suspend();
                if (oldTimeout == -1) return;
                this.tm.setTransactionTimeout(oldTimeout);
                return;
            }
            Object var8_6 = null;
            invocation.setTransaction(oldTx);
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            invocation.setTransaction(oldTx);
            this.tm.suspend();
            if (oldTimeout == -1) throw throwable;
            this.tm.setTransactionTimeout(oldTimeout);
            throw throwable;
        }
        this.tm.suspend();
        if (oldTimeout == -1) return;
        this.tm.setTransactionTimeout(oldTimeout);
    }

    protected void throwJBossException(Exception e, InvocationType type) throws TransactionRolledbackException {
        NestedException rollback;
        if (e instanceof NestedException && (rollback = (NestedException)e).getCause() instanceof Exception) {
            e = (Exception)rollback.getCause();
        }
        if (type == InvocationType.LOCAL || type == InvocationType.LOCALHOME) {
            throw new JBossTransactionRolledbackLocalException(e);
        }
        throw new JBossTransactionRolledbackException(e);
    }

    protected void checkTransactionStatus(Transaction tx, InvocationType type) throws TransactionRolledbackException {
        if (this.exceptionRollback) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("No exception from ejb, checking transaction status: " + tx));
            }
            int status = 5;
            try {
                status = tx.getStatus();
            }
            catch (Throwable t) {
                this.log.debug((Object)"Ignored error trying to retrieve transaction status", t);
            }
            if (status != 0) {
                Exception e = new Exception("Transaction cannot be committed (probably transaction timeout): " + tx);
                this.throwJBossException(e, type);
            }
        }
    }

    public void sample(Object s) {
    }

    public Map retrieveStatistic() {
        return null;
    }

    public void resetStatistic() {
    }
}

