/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
import org.jboss.logging.Logger;

public interface JDBCParameterSetter {
    public static final JDBCParameterSetter CLOB = new JDBCAbstractParameterSetter(){

        protected void setNotNull(PreparedStatement ps, int index, int jdbcType, Object value, Logger log) throws SQLException {
            String string = value.toString();
            ps.setCharacterStream(index, (Reader)new StringReader(string), string.length());
        }
    };
    public static final JDBCParameterSetter BINARY = new JDBCAbstractParameterSetter(){

        protected void setNotNull(PreparedStatement ps, int index, int jdbcType, Object value, Logger log) throws SQLException {
            byte[] bytes = JDBCUtil.convertObjectToByteArray(value);
            ps.setBytes(index, bytes);
        }
    };
    public static final JDBCParameterSetter BLOB = new JDBCAbstractParameterSetter(){

        protected void setNotNull(PreparedStatement ps, int index, int jdbcType, Object value, Logger log) throws SQLException {
            byte[] bytes = JDBCUtil.convertObjectToByteArray(value);
            ps.setBinaryStream(index, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
        }
    };
    public static final JDBCParameterSetter NUMERIC = new JDBCAbstractParameterSetter(){

        protected void setNotNull(PreparedStatement ps, int index, int jdbcType, Object value, Logger log) throws SQLException {
            if (value instanceof BigDecimal) {
                ps.setBigDecimal(index, (BigDecimal)value);
            } else {
                ps.setObject(index, value, jdbcType, 0);
            }
        }
    };
    public static final JDBCParameterSetter OBJECT = new JDBCAbstractParameterSetter(){

        protected void setNotNull(PreparedStatement ps, int index, int jdbcType, Object value, Logger log) throws SQLException {
            ps.setObject(index, value, jdbcType);
        }
    };

    public void set(PreparedStatement var1, int var2, int var3, Object var4, Logger var5) throws SQLException;

    public static abstract class JDBCAbstractParameterSetter
    implements JDBCParameterSetter {
        public void set(PreparedStatement ps, int index, int jdbcType, Object value, Logger log) throws SQLException {
            if (log.isTraceEnabled()) {
                log.trace((Object)("param: i=" + index + ", " + "type=" + JDBCUtil.getJDBCTypeName(jdbcType) + ", " + "value=" + (value == null ? "NULL" : value)));
            }
            if (value == null) {
                ps.setNull(index, jdbcType);
            } else {
                value = JDBCUtil.coerceToSQLType(jdbcType, value);
                this.setNotNull(ps, index, jdbcType, value, log);
            }
        }

        protected abstract void setNotNull(PreparedStatement var1, int var2, int var3, Object var4, Logger var5) throws SQLException;
    }
}

