/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata;

import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.jboss.deployment.DeploymentException;
import org.jboss.metadata.EjbRefMetaData;
import org.jboss.metadata.EnvEntryMetaData;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.ResourceEnvRefMetaData;
import org.jboss.metadata.ResourceRefMetaData;
import org.jboss.metadata.serviceref.ServiceRefDelegate;
import org.jboss.wsf.spi.serviceref.ServiceRefMetaData;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientMetaData {
    private String displayName;
    private String jndiName;
    private ArrayList environmentEntries = new ArrayList();
    private HashMap ejbReferences = new HashMap();
    private HashMap<String, ServiceRefMetaData> serviceReferences = new HashMap();
    private HashMap resourceReferences = new HashMap();
    private HashMap resourceEnvReferences = new HashMap();
    private HashMap resourceEnvReferenceLinks = new HashMap();
    private String callbackHandler;
    private URLClassLoader resourceCl;

    public void setResourceClassLoader(URLClassLoader resourceCl) {
        this.resourceCl = resourceCl;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getJndiName() {
        String name = this.jndiName;
        if (name == null) {
            name = this.displayName;
        }
        return name;
    }

    public ArrayList getEnvironmentEntries() {
        return this.environmentEntries;
    }

    public HashMap getEjbReferences() {
        return this.ejbReferences;
    }

    public HashMap getResourceReferences() {
        return this.resourceReferences;
    }

    public HashMap getResourceEnvReferences() {
        return this.resourceEnvReferences;
    }

    public String getCallbackHandler() {
        return this.callbackHandler;
    }

    public HashMap<String, ServiceRefMetaData> getServiceReferences() {
        return this.serviceReferences;
    }

    public void importClientXml(Element element) throws DeploymentException {
        ResourceEnvRefMetaData refMetaData;
        Element resourceRef;
        this.displayName = MetaData.getOptionalChildContent(element, "display-name");
        Iterator iterator = MetaData.getChildrenByTagName(element, "env-entry");
        while (iterator.hasNext()) {
            Element envEntry = (Element)iterator.next();
            EnvEntryMetaData envEntryMetaData = new EnvEntryMetaData();
            envEntryMetaData.importEjbJarXml(envEntry);
            this.environmentEntries.add(envEntryMetaData);
        }
        iterator = MetaData.getChildrenByTagName(element, "ejb-ref");
        while (iterator.hasNext()) {
            Element ejbRef = (Element)iterator.next();
            EjbRefMetaData ejbRefMetaData = new EjbRefMetaData();
            ejbRefMetaData.importEjbJarXml(ejbRef);
            this.ejbReferences.put(ejbRefMetaData.getName(), ejbRefMetaData);
        }
        iterator = MetaData.getChildrenByTagName(element, "service-ref");
        while (iterator.hasNext()) {
            Element serviceRef = (Element)iterator.next();
            ServiceRefMetaData refMetaData2 = new ServiceRefDelegate().newServiceRefMetaData();
            refMetaData2.importStandardXml(serviceRef);
            this.serviceReferences.put(refMetaData2.getServiceRefName(), refMetaData2);
        }
        Element callbackElement = MetaData.getOptionalChild(element, "callback-handler");
        if (callbackElement != null) {
            this.callbackHandler = MetaData.getElementContent(callbackElement);
        }
        iterator = MetaData.getChildrenByTagName(element, "resource-ref");
        while (iterator.hasNext()) {
            resourceRef = (Element)iterator.next();
            ResourceRefMetaData resourceRefMetaData = new ResourceRefMetaData();
            resourceRefMetaData.importEjbJarXml(resourceRef);
            this.resourceReferences.put(resourceRefMetaData.getRefName(), resourceRefMetaData);
        }
        iterator = MetaData.getChildrenByTagName(element, "resource-env-ref");
        while (iterator.hasNext()) {
            resourceRef = (Element)iterator.next();
            refMetaData = new ResourceEnvRefMetaData();
            refMetaData.importEjbJarXml(resourceRef);
            this.resourceEnvReferences.put(refMetaData.getRefName(), refMetaData);
        }
        iterator = MetaData.getChildrenByTagName(element, "message-destination-ref");
        while (iterator.hasNext()) {
            resourceRef = (Element)iterator.next();
            refMetaData = new ResourceEnvRefMetaData();
            refMetaData.importEjbJarXml(resourceRef);
            String refName = refMetaData.getRefName();
            String link = refMetaData.getLink();
            if (link != null) {
                ArrayList<ResourceEnvRefMetaData> linkedRefs = (ArrayList<ResourceEnvRefMetaData>)this.resourceEnvReferenceLinks.get(link);
                if (linkedRefs == null) {
                    linkedRefs = new ArrayList<ResourceEnvRefMetaData>();
                    this.resourceEnvReferenceLinks.put(link, linkedRefs);
                }
                linkedRefs.add(refMetaData);
            }
            this.resourceEnvReferences.put(refName, refMetaData);
        }
    }

    public void importJbossClientXml(Element element) throws DeploymentException {
        String resRefName;
        Element resourceRef;
        Object refMetaData;
        this.jndiName = MetaData.getOptionalChildContent(element, "jndi-name");
        Iterator iterator = MetaData.getChildrenByTagName(element, "ejb-ref");
        while (iterator.hasNext()) {
            Element ejbRef = (Element)iterator.next();
            String ejbRefName = MetaData.getElementContent(MetaData.getUniqueChild(ejbRef, "ejb-ref-name"));
            EjbRefMetaData ejbRefMetaData = (EjbRefMetaData)this.ejbReferences.get(ejbRefName);
            if (ejbRefMetaData == null) {
                throw new DeploymentException("ejb-ref " + ejbRefName + " found in jboss-client.xml but not in application-client.xml");
            }
            ejbRefMetaData.importJbossXml(ejbRef);
        }
        iterator = MetaData.getChildrenByTagName(element, "service-ref");
        while (iterator.hasNext()) {
            Element serviceRef = (Element)iterator.next();
            String serviceRefName = MetaData.getUniqueChildContent(serviceRef, "service-ref-name");
            refMetaData = this.serviceReferences.get(serviceRefName);
            if (refMetaData == null) {
                throw new DeploymentException("service-ref " + serviceRefName + " found in jboss-client.xml but not in application-client.xml");
            }
            refMetaData.importJBossXml(serviceRef);
        }
        iterator = MetaData.getChildrenByTagName(element, "resource-ref");
        while (iterator.hasNext()) {
            resourceRef = (Element)iterator.next();
            resRefName = MetaData.getElementContent(MetaData.getUniqueChild(resourceRef, "res-ref-name"));
            ResourceRefMetaData resourceRefMetaData = (ResourceRefMetaData)this.resourceReferences.get(resRefName);
            if (resourceRefMetaData == null) {
                throw new DeploymentException("resource-ref " + resRefName + " found in jboss-client.xml but not in application-client.xml");
            }
            resourceRefMetaData.importJbossXml(resourceRef);
        }
        iterator = MetaData.getChildrenByTagName(element, "resource-env-ref");
        while (iterator.hasNext()) {
            resourceRef = (Element)iterator.next();
            resRefName = MetaData.getElementContent(MetaData.getUniqueChild(resourceRef, "resource-env-ref-name"));
            refMetaData = (ResourceEnvRefMetaData)this.resourceEnvReferences.get(resRefName);
            if (refMetaData == null) {
                ArrayList linkedRefs = (ArrayList)this.resourceEnvReferenceLinks.get(resRefName);
                if (linkedRefs != null) {
                    for (int n = 0; n < linkedRefs.size(); ++n) {
                        refMetaData = (ResourceEnvRefMetaData)linkedRefs.get(n);
                        ((ResourceEnvRefMetaData)refMetaData).importJbossXml(resourceRef);
                    }
                    continue;
                }
                throw new DeploymentException("resource-env-ref " + resRefName + " found in jboss-client.xml but not in application-client.xml");
            }
            ((ResourceEnvRefMetaData)refMetaData).importJbossXml(resourceRef);
        }
    }
}

