/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.filter;

import java.lang.reflect.Method;
import java.net.URL;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.jboss.util.collection.WeakSet;

public class TCLFilter
extends Filter {
    private WeakSet matchSet = new WeakSet();
    private WeakSet missSet = new WeakSet();
    private String deployURL;
    private boolean acceptOnMatch = true;

    public boolean isAcceptOnMatch() {
        return this.acceptOnMatch;
    }

    public void setAcceptOnMatch(boolean acceptOnMatch) {
        this.acceptOnMatch = acceptOnMatch;
    }

    public String getDeployURL() {
        return this.deployURL;
    }

    public void setDeployURL(String deployURL) {
        this.deployURL = deployURL;
    }

    public int decide(LoggingEvent event) {
        int ok = 0;
        if (this.acceptOnMatch) {
            if (this.isMatchingTCL()) {
                ok = 1;
            }
        } else if (this.isMatchingTCL()) {
            ok = -1;
        }
        return ok;
    }

    private boolean isMatchingTCL() {
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        if (this.matchSet.contains(tcl)) {
            return true;
        }
        if (this.missSet.contains(tcl)) {
            return false;
        }
        boolean match = false;
        block0: for (ClassLoader cl = tcl; cl != null; cl = cl.getParent()) {
            URL[] urls = TCLFilter.getClassLoaderURLs(cl);
            for (int n = 0; n < urls.length; ++n) {
                URL u = urls[n];
                String file = u.getFile();
                if (file.indexOf(this.deployURL) <= 0) continue;
                match = true;
                continue block0;
            }
        }
        if (match) {
            this.matchSet.add(tcl);
        } else {
            this.missSet.add(tcl);
        }
        return match;
    }

    private static URL[] getClassLoaderURLs(ClassLoader cl) {
        URL[] urls = new URL[]{};
        try {
            Object[] args;
            Class<?> returnType = urls.getClass();
            Class[] parameterTypes = new Class[]{};
            Method getURLs = cl.getClass().getMethod("getURLs", parameterTypes);
            if (returnType.isAssignableFrom(getURLs.getReturnType())) {
                args = new Object[]{};
                urls = (URL[])getURLs.invoke((Object)cl, args);
            }
            if ((urls == null || urls.length == 0) && returnType.isAssignableFrom((getURLs = cl.getClass().getMethod("getClasspath", parameterTypes)).getReturnType())) {
                args = new Object[]{};
                urls = (URL[])getURLs.invoke((Object)cl, args);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return urls;
    }
}

