/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.alertSnmp;

import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.notification.SenderResult;
import org.rhq.core.domain.resource.Resource;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSender;
import org.rhq.enterprise.server.plugins.alertSnmp.SnmpInfo;
import org.rhq.enterprise.server.plugins.alertSnmp.SnmpTrapSender;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class SnmpSender
extends AlertSender {
    private final Log log = LogFactory.getLog(SnmpSender.class);

    public SenderResult send(Alert alert) {
        SnmpInfo info = SnmpInfo.load(this.alertParameters);
        if (info.error != null) {
            return SenderResult.getSimpleFailure((String)info.error);
        }
        this.log.debug((Object)("Sending SNMP trap to: " + info));
        try {
            AlertManagerLocal alertManager = LookupUtil.getAlertManager();
            ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
            SnmpTrapSender snmpTrapSender = new SnmpTrapSender(this.preferences);
            List lineage = resourceManager.getResourceLineage(alert.getAlertDefinition().getResource().getId());
            String platformName = ((Resource)lineage.get(0)).getName();
            String conditions = alertManager.prettyPrintAlertConditions(alert, false);
            String alertUrl = alertManager.prettyPrintAlertURL(alert);
            String hierarchy = this.getResourceHierarchyAsString(lineage);
            Date bootTime = new Date();
            String result = snmpTrapSender.sendSnmpTrap(alert, this.alertParameters, platformName, conditions, bootTime, alertUrl, hierarchy);
            return SenderResult.getSimpleSuccess((String)result);
        }
        catch (Throwable t) {
            return SenderResult.getSimpleFailure((String)("failed - cause: " + t));
        }
    }

    private String getResourceHierarchyAsString(List<Resource> lineage) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Resource resource : lineage) {
            stringBuilder.append(resource.getName());
            if (lineage.indexOf(resource) == lineage.size() - 1) continue;
            stringBuilder.append("::");
        }
        return stringBuilder.toString();
    }

    public String previewConfiguration() {
        SnmpInfo info = SnmpInfo.load(this.alertParameters);
        return info.toString();
    }
}

