/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.CollectionAction;
import org.hibernate.cache.CacheException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;

public final class CollectionUpdateAction
extends CollectionAction {
    private final boolean emptySnapshot;

    public CollectionUpdateAction(PersistentCollection collection, CollectionPersister persister, Serializable id, boolean emptySnapshot, SessionImplementor session) throws CacheException {
        super(persister, collection, id, session);
        this.emptySnapshot = emptySnapshot;
    }

    public void execute() throws HibernateException {
        Serializable id = this.getKey();
        SessionImplementor session = this.getSession();
        CollectionPersister persister = this.getPersister();
        PersistentCollection collection = this.getCollection();
        boolean affectedByFilters = persister.isAffectedByEnabledFilters(session);
        boolean stats = session.getFactory().getStatistics().isStatisticsEnabled();
        long startTime = 0L;
        if (stats) {
            startTime = System.currentTimeMillis();
        }
        if (!collection.wasInitialized()) {
            if (!collection.hasQueuedOperations()) {
                throw new AssertionFailure("no queued adds");
            }
        } else if (!affectedByFilters && collection.empty()) {
            if (!this.emptySnapshot) {
                persister.remove(id, session);
            }
        } else if (collection.needsRecreate(persister)) {
            if (affectedByFilters) {
                throw new HibernateException("cannot recreate collection while filter is enabled: " + MessageHelper.collectionInfoString(persister, id, persister.getFactory()));
            }
            if (!this.emptySnapshot) {
                persister.remove(id, session);
            }
            persister.recreate(collection, id, session);
        } else {
            persister.deleteRows(collection, id, session);
            persister.updateRows(collection, id, session);
            persister.insertRows(collection, id, session);
        }
        this.getSession().getPersistenceContext().getCollectionEntry(collection).afterAction(collection);
        this.evict();
        if (stats) {
            this.getSession().getFactory().getStatisticsImplementor().updateCollection(this.getPersister().getRole(), System.currentTimeMillis() - startTime);
        }
    }
}

