/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.exe;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jbpm.JbpmException;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.Comment;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.log.SignalLog;
import org.jbpm.graph.log.TokenCreateLog;
import org.jbpm.graph.log.TokenEndLog;
import org.jbpm.logging.exe.LoggingInstance;
import org.jbpm.logging.log.CompositeLog;
import org.jbpm.logging.log.ProcessLog;
import org.jbpm.msg.MessageService;
import org.jbpm.scheduler.SchedulerService;
import org.jbpm.svc.Services;
import org.jbpm.taskmgmt.exe.TaskMgmtInstance;
import org.jbpm.util.EqualsUtil;

public class Token
implements Serializable {
    private static final long serialVersionUID = 1L;
    long id = 0L;
    int version = 0;
    protected String name = null;
    protected Date start = null;
    protected Date end = null;
    protected Node node = null;
    protected Date nodeEnter = null;
    protected ProcessInstance processInstance = null;
    protected Token parent = null;
    protected Map children = null;
    protected List comments = null;
    protected ProcessInstance subProcessInstance = null;
    protected int nextLogIndex = 0;
    boolean isAbleToReactivateParent = true;
    boolean isTerminationImplicit = false;
    boolean isSuspended = false;
    boolean isLocked = false;

    public Token() {
    }

    public Token(ProcessInstance processInstance) {
        this.start = new Date();
        this.processInstance = processInstance;
        this.node = processInstance.getProcessDefinition().getStartState();
        this.isTerminationImplicit = processInstance.getProcessDefinition().isTerminationImplicit();
    }

    public Token(Token parent, String name) {
        this.start = new Date();
        this.processInstance = parent.getProcessInstance();
        this.name = name;
        this.node = parent.getNode();
        this.parent = parent;
        parent.addChild(this);
        this.isTerminationImplicit = parent.isTerminationImplicit();
        parent.addLog(new TokenCreateLog(this));
        Services.assignId(this);
    }

    void addChild(Token token) {
        if (this.children == null) {
            this.children = new HashMap();
        }
        this.children.put(token.getName(), token);
    }

    public void signal() {
        if (this.node == null) {
            throw new JbpmException("token '" + this + "' can't be signalled cause it is currently not positioned in a node");
        }
        if (this.node.getDefaultLeavingTransition() == null) {
            throw new JbpmException("couldn't signal token '" + this + "' : node '" + this.node + "' doesn't have a default transition");
        }
        this.signal(this.node.getDefaultLeavingTransition(), new ExecutionContext(this));
    }

    public void signal(String transitionName) {
        if (this.node == null) {
            throw new JbpmException("token '" + this + "' can't be signalled cause it is currently not positioned in a node");
        }
        if (this.node.getDefaultLeavingTransition() == null) {
            throw new JbpmException("couldn't signal token '" + this + "' : node '" + this.node + "' doesn't have a default transition");
        }
        this.signal(this.node.getLeavingTransition(transitionName), new ExecutionContext(this));
    }

    public void signal(Transition transition) {
        this.signal(transition, new ExecutionContext(this));
    }

    void signal(ExecutionContext executionContext) {
        this.signal(this.node.getDefaultLeavingTransition(), executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void signal(Transition transition, ExecutionContext executionContext) {
        if (transition == null) {
            throw new JbpmException("couldn't signal without specifying  a leaving transition : transition is null");
        }
        if (executionContext == null) {
            throw new JbpmException("couldn't signal without an execution context: executionContext is null");
        }
        if (this.isSuspended) {
            throw new JbpmException("can't signal token '" + this.name + "' (" + this.id + "): it is suspended");
        }
        if (this.isLocked) {
            throw new JbpmException("can't continue execution on locked tokens.  signalling the same token that executes an action is not allowed");
        }
        this.startCompositeLog(new SignalLog(transition));
        try {
            Node signalNode = this.node;
            signalNode.fireEvent("before-signal", executionContext);
            this.node.leave(executionContext, transition);
            this.checkImplicitTermination();
            signalNode.fireEvent("after-signal", executionContext);
        }
        finally {
            this.endCompositeLog();
        }
    }

    public void end() {
        this.end(true);
    }

    public void end(boolean verifyParentTermination) {
        if (this.end == null) {
            this.isAbleToReactivateParent = false;
            this.end = new Date();
            if (this.children != null) {
                Iterator iter = this.children.values().iterator();
                while (iter.hasNext()) {
                    Token child = (Token)iter.next();
                    if (child.hasEnded()) continue;
                    child.end();
                }
            }
            if (this.parent != null) {
                this.parent.addLog(new TokenEndLog(this));
            }
            if (verifyParentTermination) {
                this.notifyParentOfTokenEnd();
            }
        }
    }

    public void addComment(String message) {
        this.addComment(new Comment(message));
    }

    public void addComment(Comment comment) {
        if (this.comments == null) {
            this.comments = new ArrayList();
        }
        this.comments.add(comment);
        comment.setToken(this);
    }

    public List getComments() {
        return this.comments;
    }

    void notifyParentOfTokenEnd() {
        if (this.isRoot()) {
            this.processInstance.end();
        } else if (!this.parent.hasActiveChildren()) {
            this.parent.end();
        }
    }

    public boolean hasActiveChildren() {
        boolean foundActiveChildToken = false;
        if (this.children != null) {
            Iterator iter = this.children.values().iterator();
            while (iter.hasNext() && !foundActiveChildToken) {
                Token child = (Token)iter.next();
                if (child.hasEnded()) continue;
                foundActiveChildToken = true;
            }
        }
        return foundActiveChildToken;
    }

    public void addLog(ProcessLog processLog) {
        LoggingInstance li = (LoggingInstance)this.processInstance.getInstance(LoggingInstance.class);
        if (li != null) {
            processLog.setToken(this);
            li.addLog(processLog);
        }
    }

    public void startCompositeLog(CompositeLog compositeLog) {
        LoggingInstance li = (LoggingInstance)this.processInstance.getInstance(LoggingInstance.class);
        if (li != null) {
            compositeLog.setToken(this);
            li.startCompositeLog(compositeLog);
        }
    }

    public void endCompositeLog() {
        LoggingInstance li = (LoggingInstance)this.processInstance.getInstance(LoggingInstance.class);
        if (li != null) {
            li.endCompositeLog();
        }
    }

    public String toString() {
        return "Token(" + this.getFullName() + ")";
    }

    public boolean hasEnded() {
        return this.end != null;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public boolean hasChild(String name) {
        return this.children != null ? this.children.containsKey(name) : false;
    }

    public Token getChild(String name) {
        Token child = null;
        if (this.children != null) {
            child = (Token)this.children.get(name);
        }
        return child;
    }

    public String getFullName() {
        if (this.parent == null) {
            return "/";
        }
        if (this.parent.getParent() == null) {
            return "/" + this.name;
        }
        return this.parent.getFullName() + "/" + this.name;
    }

    public List getChildrenAtNode(Node aNode) {
        ArrayList foundChildren = new ArrayList();
        this.getChildrenAtNode(aNode, foundChildren);
        return foundChildren;
    }

    void getChildrenAtNode(Node aNode, List foundTokens) {
        if (aNode.equals(this.node)) {
            foundTokens.add(this);
        } else if (this.children != null && !this.children.isEmpty()) {
            Iterator it = this.children.values().iterator();
            while (it.hasNext()) {
                Token aChild = (Token)it.next();
                aChild.getChildrenAtNode(aNode, foundTokens);
            }
        }
    }

    public void collectChildrenRecursively(List tokens) {
        if (this.children != null) {
            Iterator iter = this.children.values().iterator();
            while (iter.hasNext()) {
                Token child = (Token)iter.next();
                tokens.add(child);
                child.collectChildrenRecursively(tokens);
            }
        }
    }

    public Token findToken(String relativeTokenPath) {
        if (relativeTokenPath == null) {
            return null;
        }
        String path = relativeTokenPath.trim();
        if ("".equals(path) || ".".equals(path)) {
            return this;
        }
        if ("..".equals(path)) {
            return this.parent;
        }
        if (path.startsWith("/")) {
            Token root = this.processInstance.getRootToken();
            return root.findToken(path.substring(1));
        }
        if (path.startsWith("./")) {
            return this.findToken(path.substring(2));
        }
        if (path.startsWith("../")) {
            if (this.parent != null) {
                return this.parent.findToken(path.substring(3));
            }
            return null;
        }
        int slashIndex = path.indexOf(47);
        if (slashIndex == -1) {
            return this.children != null ? this.children.get(path) : null;
        }
        Token token = null;
        String name = path.substring(0, slashIndex);
        token = (Token)this.children.get(name);
        if (token != null) {
            return token.findToken(path.substring(slashIndex + 1));
        }
        return null;
    }

    public Map getActiveChildren() {
        HashMap<String, Token> activeChildren = new HashMap<String, Token>();
        if (this.children != null) {
            Iterator iter = this.children.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Token child = (Token)entry.getValue();
                if (child.hasEnded()) continue;
                String childName = (String)entry.getKey();
                activeChildren.put(childName, child);
            }
        }
        return activeChildren;
    }

    public void checkImplicitTermination() {
        if (this.isTerminationImplicit && this.node.hasNoLeavingTransitions()) {
            this.end();
            if (this.processInstance.isTerminatedImplicitly()) {
                this.processInstance.end();
            }
        }
    }

    public boolean isTerminatedImplicitly() {
        if (this.end != null) {
            return true;
        }
        Map leavingTransitions = this.node.getLeavingTransitionsMap();
        if (leavingTransitions != null && leavingTransitions.size() > 0) {
            return false;
        }
        Iterator iter = this.getActiveChildren().values().iterator();
        while (iter.hasNext()) {
            Token child = (Token)iter.next();
            if (child.isTerminatedImplicitly()) continue;
            return false;
        }
        return true;
    }

    public int nextLogIndex() {
        return this.nextLogIndex++;
    }

    public void suspend() {
        this.isSuspended = true;
        this.suspendTimers();
        this.suspendMessages();
        this.suspendTaskInstances();
        if (this.children != null) {
            Iterator iter = this.children.values().iterator();
            while (iter.hasNext()) {
                Token child = (Token)iter.next();
                child.suspend();
            }
        }
    }

    void suspendTimers() {
        SchedulerService schedulerService = (SchedulerService)Services.getCurrentService("scheduler", false);
        if (schedulerService != null) {
            schedulerService.suspendTimers(this);
        }
    }

    void suspendMessages() {
        MessageService messageService = (MessageService)Services.getCurrentService("message", false);
        if (messageService != null) {
            messageService.suspendMessages(this);
        }
    }

    void suspendTaskInstances() {
        TaskMgmtInstance taskMgmtInstance;
        TaskMgmtInstance taskMgmtInstance2 = taskMgmtInstance = this.processInstance != null ? this.processInstance.getTaskMgmtInstance() : null;
        if (taskMgmtInstance != null) {
            taskMgmtInstance.suspend(this);
        }
    }

    public void resume() {
        this.isSuspended = false;
        this.resumeTimers();
        this.resumeMessages();
        this.resumeTaskInstances();
        if (this.children != null) {
            Iterator iter = this.children.values().iterator();
            while (iter.hasNext()) {
                Token child = (Token)iter.next();
                child.resume();
            }
        }
    }

    void resumeTimers() {
        SchedulerService schedulerService = (SchedulerService)Services.getCurrentService("scheduler", false);
        if (schedulerService != null) {
            schedulerService.resumeTimers(this);
        }
    }

    void resumeMessages() {
        MessageService messageService = (MessageService)Services.getCurrentService("message", false);
        if (messageService != null) {
            messageService.resumeMessages(this);
        }
    }

    void resumeTaskInstances() {
        TaskMgmtInstance taskMgmtInstance;
        TaskMgmtInstance taskMgmtInstance2 = taskMgmtInstance = this.processInstance != null ? this.processInstance.getTaskMgmtInstance() : null;
        if (taskMgmtInstance != null) {
            taskMgmtInstance.resume(this);
        }
    }

    public boolean equals(Object o) {
        return EqualsUtil.equals(this, o);
    }

    public ProcessInstance createSubProcessInstance(ProcessDefinition subProcessDefinition) {
        this.subProcessInstance = new ProcessInstance(subProcessDefinition);
        this.setSubProcessInstance(this.subProcessInstance);
        this.subProcessInstance.setSuperProcessToken(this);
        this.processInstance.addCascadeProcessInstance(this.subProcessInstance);
        return this.subProcessInstance;
    }

    public void lock() {
        this.isLocked = true;
    }

    public void unlock() {
        this.isLocked = false;
    }

    public long getId() {
        return this.id;
    }

    public Date getStart() {
        return this.start;
    }

    public Date getEnd() {
        return this.end;
    }

    public String getName() {
        return this.name;
    }

    public ProcessInstance getProcessInstance() {
        return this.processInstance;
    }

    public Map getChildren() {
        return this.children;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public Token getParent() {
        return this.parent;
    }

    public void setParent(Token parent) {
        this.parent = parent;
    }

    public void setProcessInstance(ProcessInstance processInstance) {
        this.processInstance = processInstance;
    }

    public ProcessInstance getSubProcessInstance() {
        return this.subProcessInstance;
    }

    public Date getNodeEnter() {
        return this.nodeEnter;
    }

    public void setNodeEnter(Date nodeEnter) {
        this.nodeEnter = nodeEnter;
    }

    public boolean isAbleToReactivateParent() {
        return this.isAbleToReactivateParent;
    }

    public void setAbleToReactivateParent(boolean isAbleToReactivateParent) {
        this.isAbleToReactivateParent = isAbleToReactivateParent;
    }

    public boolean isTerminationImplicit() {
        return this.isTerminationImplicit;
    }

    public void setTerminationImplicit(boolean isTerminationImplicit) {
        this.isTerminationImplicit = isTerminationImplicit;
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    public void setSubProcessInstance(ProcessInstance subProcessInstance) {
        this.subProcessInstance = subProcessInstance;
    }
}

