/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.xml;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

public class Problem
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int LEVEL_FATAL = 1;
    public static final int LEVEL_ERROR = 2;
    public static final int LEVEL_WARNING = 3;
    public static final int LEVEL_INFO = 4;
    protected int level;
    protected String description;
    protected String resource;
    protected String folder;
    protected Integer line;
    protected Throwable exception;

    static String getTypeDescription(int level) {
        if (level == 1) {
            return "FATAL";
        }
        if (level == 2) {
            return "ERROR";
        }
        if (level == 3) {
            return "WARNING";
        }
        if (level == 4) {
            return "INFO";
        }
        return null;
    }

    public Problem(int level, String description) {
        this.level = level;
        this.description = description;
    }

    public Problem(int level, String description, Throwable exception) {
        this.level = level;
        this.description = description;
        this.exception = exception;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[" + Problem.getTypeDescription(this.level) + "]");
        if (this.resource != null) {
            buffer.append(" " + this.resource);
        }
        if (this.line != null) {
            buffer.append("(" + this.line + ")");
        }
        if (this.folder != null) {
            buffer.append(" " + this.folder);
        }
        if (this.description != null) {
            buffer.append(" " + this.description);
        }
        return buffer.toString();
    }

    public static boolean containsProblemsOfLevel(Collection c, int level) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            Problem problem = (Problem)iter.next();
            if (problem.level > level) continue;
            return true;
        }
        return false;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public String getFolder() {
        return this.folder;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    public Integer getLine() {
        return this.line;
    }

    public void setLine(Integer line) {
        this.line = line;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public int getLevel() {
        return this.level;
    }
}

