/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.msg;

import java.io.Serializable;
import org.jbpm.JbpmException;
import org.jbpm.command.ExecuteActionCommand;
import org.jbpm.command.ExecuteNodeCommand;
import org.jbpm.graph.exe.Token;
import org.jbpm.util.EqualsUtil;

public abstract class Message
implements Serializable {
    protected long id;
    protected String destination = null;
    protected String exception;
    protected Token token;
    protected boolean isSuspended = false;

    public static Message createCopy(Message message) {
        Message copy = null;
        if (message instanceof ExecuteNodeCommand) {
            copy = new ExecuteNodeCommand((ExecuteNodeCommand)message);
        } else if (message instanceof ExecuteActionCommand) {
            copy = new ExecuteActionCommand((ExecuteActionCommand)message);
        } else {
            throw new JbpmException("jBPM internal panic: can't create copy of message '" + message + "'");
        }
        return copy;
    }

    public boolean equals(Object o) {
        return EqualsUtil.equals(this, o);
    }

    public long getId() {
        return this.id;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getException() {
        return this.exception;
    }

    public void setException(String exception) {
        this.exception = exception;
    }

    public Token getToken() {
        return this.token;
    }

    public void setToken(Token token) {
        this.token = token;
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    public void setSuspended(boolean isSuspended) {
        this.isSuspended = isSuspended;
    }
}

