/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hibernate.session;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public class HibernateContext {
    public static Session getUnmanagedSession(String name) throws HibernateException, IllegalStateException {
        SessionFactory sf = HibernateContext.locateSessionFactory(name);
        return sf.openSession(sf.getCurrentSession().connection());
    }

    public static void releaseUnmanagedSession(Session unmanagedSession) throws HibernateException {
        unmanagedSession.close();
    }

    public static Session getSession(String name) {
        return HibernateContext.locateSessionFactory(name).getCurrentSession();
    }

    private static SessionFactory locateSessionFactory(String name) throws HibernateException {
        InitialContext context = null;
        try {
            SessionFactory factory;
            context = new InitialContext();
            SessionFactory sessionFactory = factory = (SessionFactory)context.lookup(name);
            return sessionFactory;
        }
        catch (NamingException e) {
            throw new HibernateException("Unable to locate SessionFactory in JNDI under name [" + name + "]", (Throwable)e);
        }
        finally {
            HibernateContext.release(context);
        }
    }

    private static void release(InitialContext ctx) {
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

