/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.multiplex;

import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import org.jboss.remoting.transport.multiplex.VirtualServerSocketFactory;
import org.jboss.remoting.transport.multiplex.VirtualSocketFactory;

public class FactoryExample {
    void runFactoryExample() {
        ServerSocketFactory serverSocketFactory = VirtualServerSocketFactory.getDefault();
        ((VirtualServerSocketFactory)serverSocketFactory).setOnServer();
        SocketFactory socketFactory = VirtualSocketFactory.getDefault();
        this.useServerSocketFactory(serverSocketFactory);
        this.useSocketFactory(socketFactory);
    }

    void useServerSocketFactory(final ServerSocketFactory serverSocketFactory) {
        new Thread(){

            public void run() {
                try {
                    ServerSocket serverSocket = serverSocketFactory.createServerSocket(5555);
                    Socket socket = serverSocket.accept();
                    int b = socket.getInputStream().read();
                    socket.getOutputStream().write(b);
                    socket.close();
                    serverSocket.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    public void useSocketFactory(SocketFactory socketFactory) {
        try {
            Thread.sleep(1000L);
            Socket socket = socketFactory.createSocket("localhost", 5555);
            socket.getOutputStream().write(7);
            System.out.println(socket.getInputStream().read());
            socket.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        new FactoryExample().runFactoryExample();
    }
}

