/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.url;

import java.io.InputStream;
import java.net.URL;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.enterprise.server.plugins.url.UrlProvider;

public class HttpProvider
extends UrlProvider {
    private final Log log = LogFactory.getLog(HttpProvider.class);
    private String username;
    private String password;
    private String proxyUrl;
    private int proxyPort;
    private String proxyUsername;
    private String proxyPassword;

    @Override
    protected void setRootUrl(URL url) {
        if (!url.getProtocol().startsWith("http")) {
            throw new UnsupportedOperationException("This content source cannot support a protocol other than HTTP: url=" + url);
        }
        super.setRootUrl(url);
    }

    @Override
    protected void setIndexUrl(URL url) {
        if (!url.getProtocol().startsWith("http")) {
            throw new UnsupportedOperationException("This content source cannot support a protocol other than HTTP: index-url=" + url);
        }
        super.setIndexUrl(url);
    }

    @Override
    public void initialize(Configuration configuration) throws Exception {
        this.username = configuration.getSimpleValue("username", null);
        this.password = configuration.getSimpleValue("password", null);
        this.proxyUrl = configuration.getSimpleValue("proxyUrl", null);
        this.proxyUsername = configuration.getSimpleValue("proxyUsername", null);
        this.proxyPassword = configuration.getSimpleValue("proxyPassword", null);
        String port = configuration.getSimpleValue("proxyPort", null);
        if (port != null) {
            this.proxyPort = Integer.parseInt(port);
        }
        super.initialize(configuration);
    }

    @Override
    public void shutdown() {
        this.username = null;
        this.password = null;
        this.proxyUrl = null;
        this.proxyUsername = null;
        this.proxyPassword = null;
        this.proxyPort = 0;
        super.shutdown();
    }

    @Override
    public void testConnection() throws Exception {
        HttpClient client = new HttpClient();
        HeadMethod method = new HeadMethod(this.getRootUrl().toString());
        this.prepareHttpClient(client, (HttpMethodBase)method);
        int status = client.executeMethod((HttpMethod)method);
        if (status != 200) {
            throw new Exception("Content source failed connection test with status code=" + status);
        }
    }

    @Override
    public InputStream getInputStream(String location) throws Exception {
        URL fullUrl = new URL(this.getRootUrl().toString() + location);
        InputStream stream = this.getInputStreamForUrl(fullUrl);
        return stream;
    }

    @Override
    protected InputStream getIndexInputStream() throws Exception {
        InputStream stream = this.getInputStreamForUrl(this.getIndexUrl());
        return stream;
    }

    protected InputStream getInputStreamForUrl(URL url) throws Exception {
        String fullLocation = url.toString();
        HttpClient client = new HttpClient();
        GetMethod method = new GetMethod(fullLocation);
        this.prepareHttpClient(client, (HttpMethodBase)method);
        int status = client.executeMethod((HttpMethod)method);
        switch (status) {
            case 200: {
                break;
            }
            case 404: {
                throw new Exception("Could not find the content at URL [" + fullLocation + "]. Make sure the content source defines a valid URL.");
            }
            case 401: 
            case 403: {
                throw new Exception("Invalid login credentials specified for user [" + this.username + "]. Make sure " + "this user is valid and the password specified for this content source is correct.");
            }
            default: {
                throw new Exception("Failed to retrieve content. status code=" + status);
            }
        }
        InputStream stream = method.getResponseBodyAsStream();
        return stream;
    }

    protected void prepareHttpClient(HttpClient client, HttpMethodBase method) throws Exception {
        this.configureProxy(client);
        method.setFollowRedirects(true);
        if (this.username != null) {
            method.setDoAuthentication(true);
            URI fullUri = method.getURI();
            AuthScope authScope = new AuthScope(fullUri.getHost(), fullUri.getPort(), AuthScope.ANY_REALM);
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.username, this.password);
            client.getState().setCredentials(authScope, (Credentials)credentials);
        }
    }

    protected void configureProxy(HttpClient client) {
        if (this.proxyUrl != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Configuring HTTP proxy. url [" + this.proxyUrl + "]; port [" + this.proxyPort + "]"));
            }
            HostConfiguration hostConfiguration = client.getHostConfiguration();
            hostConfiguration.setProxy(this.proxyUrl, this.proxyPort);
            if (this.proxyUsername != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Configuring feed for authenticating proxy. proxy-user: " + this.proxyUsername));
                }
                AuthScope proxyAuthScope = new AuthScope(this.proxyUrl, this.proxyPort, AuthScope.ANY_REALM);
                UsernamePasswordCredentials proxyCredentials = new UsernamePasswordCredentials(this.proxyUsername, this.proxyPassword);
                client.getState().setProxyCredentials(proxyAuthScope, (Credentials)proxyCredentials);
            }
        }
    }
}

