/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.mysql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.plugins.database.DatabaseComponent;
import org.rhq.plugins.database.DatabaseQueryUtility;
import org.rhq.plugins.mysql.MySqlComponent;

public class MySqlUserComponent
implements MeasurementFacet,
DatabaseComponent {
    private String userName;
    private String host;
    private MySqlComponent parent;
    private Log log = LogFactory.getLog(this.getClass());
    private ResourceContext context;

    public Connection getConnection() {
        return this.parent.getConnection();
    }

    public void removeConnection() {
        this.parent.removeConnection();
    }

    public void start(ResourceContext rc) throws InvalidPluginConfigurationException, Exception {
        this.parent = (MySqlComponent)rc.getParentResourceComponent();
        this.context = rc;
        this.userName = this.context.getPluginConfiguration().getSimple("userName").getStringValue();
        this.host = this.context.getPluginConfiguration().getSimple("host").getStringValue();
    }

    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void getValues(MeasurementReport mr, Set<MeasurementScheduleRequest> requests) throws Exception {
        Connection conn = this.getConnection();
        ResultSet rs = null;
        Statement stmt = null;
        int activeConnections = 0;
        int totalConnections = 0;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery("select User,Host,State from information_schema.processlist where User='" + this.userName + "'");
            while (rs.next()) {
                String hostVal = rs.getString(2);
                String state = rs.getString(3);
                if (!hostVal.startsWith(this.host)) continue;
                if (state.length() > 1) {
                    ++activeConnections;
                }
                ++totalConnections;
            }
        }
        catch (SQLException sqle) {
            DatabaseQueryUtility.close((Statement)stmt, rs);
            catch (Throwable throwable) {
                DatabaseQueryUtility.close((Statement)stmt, rs);
                throw throwable;
            }
        }
        DatabaseQueryUtility.close((Statement)stmt, (ResultSet)rs);
        for (MeasurementScheduleRequest request : requests) {
            if (request.getName().equals("TotalConnections")) {
                mr.addData(new MeasurementDataNumeric(request, new Double(totalConnections)));
                continue;
            }
            if (!request.getName().equals("ActiveConnections")) continue;
            mr.addData(new MeasurementDataNumeric(request, new Double(activeConnections)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public AvailabilityType getAvailability() {
        Statement stmt;
        ResultSet rs;
        AvailabilityType result;
        block4: {
            result = AvailabilityType.DOWN;
            Connection conn = this.getConnection();
            rs = null;
            stmt = null;
            try {
                stmt = conn.createStatement();
                rs = stmt.executeQuery("select User from mysql.user where User='" + this.userName + "' and Host='" + this.host + "'");
                if (!rs.first()) break block4;
                result = AvailabilityType.UP;
            }
            catch (SQLException sqle) {
                DatabaseQueryUtility.close((Statement)stmt, rs);
                catch (Throwable throwable) {
                    DatabaseQueryUtility.close((Statement)stmt, rs);
                    throw throwable;
                }
            }
        }
        DatabaseQueryUtility.close((Statement)stmt, (ResultSet)rs);
        return result;
    }
}

