/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.http.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLServerSocketFactory;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.security.ServerSocketFactoryMBean;
import org.jboss.remoting.transport.http.HTTPServerInvoker;

public class HTTPSServerInvoker
extends HTTPServerInvoker {
    private static final Logger log = Logger.getLogger(HTTPSServerInvoker.class);
    protected ServerSocketFactory serverSocketFactory = null;

    public HTTPSServerInvoker(InvokerLocator locator) {
        super(locator);
    }

    public HTTPSServerInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
    }

    protected ServerSocket createServerSocket(int serverBindPort, int backlog, InetAddress bindAddress) throws IOException {
        ServerSocket svrSocket;
        block10: {
            svrSocket = null;
            Map props = this.getConfiguration();
            if (this.serverSocketFactory != null) {
                svrSocket = this.serverSocketFactory.createServerSocket(serverBindPort, backlog, bindAddress);
            } else if (props.get("serverSocketFactory") != null) {
                try {
                    String serverSocketFactoryString = (String)props.get("serverSocketFactory");
                    if (serverSocketFactoryString == null) break block10;
                    MBeanServer server = this.getMBeanServer();
                    ObjectName serverSocketFactoryObjName = new ObjectName(serverSocketFactoryString);
                    if (server != null) {
                        try {
                            ServerSocketFactoryMBean serverSocketFactory = (ServerSocketFactoryMBean)MBeanServerInvocationHandler.newProxyInstance(server, serverSocketFactoryObjName, ServerSocketFactoryMBean.class, false);
                            svrSocket = serverSocketFactory.createServerSocket(serverBindPort, backlog, bindAddress);
                            break block10;
                        }
                        catch (Exception e) {
                            log.error("Error creating mbean proxy for server socket factory for object name: " + serverSocketFactoryObjName, e);
                            throw new IOException("Error createing custom server socket factory.");
                        }
                    }
                    log.error("The 'serverSocketFactory' attribute was set with a value, but the MBeanServer reference is null.");
                    throw new IOException("Error creating custom server socket factory.  The invoker does not have a reference to the mbean server.");
                }
                catch (MalformedObjectNameException e) {
                    log.error("Error setting the server socket factory due to the attibute value passed not being a valid ObjectName.", e);
                    throw new IOException("Error creating custom server socket factory.  The attributed value passed is not a valid object name.");
                }
                catch (NullPointerException e) {
                    log.error("Error setting the server socket factory due to null pointer exception.", e);
                    throw new IOException("Error creating custom server socket factory.");
                }
            }
        }
        if (svrSocket == null) {
            log.debug("Creating default server socket.");
            this.serverSocketFactory = SSLServerSocketFactory.getDefault();
            svrSocket = this.serverSocketFactory.createServerSocket(serverBindPort, backlog, bindAddress);
        }
        log.debug("Created server socket: " + svrSocket);
        return svrSocket;
    }

    public void setServerSocketFactory(ServerSocketFactory serverSocketFactory) {
        this.serverSocketFactory = serverSocketFactory;
    }
}

