/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.core.comm;

import java.util.Hashtable;
import java.util.Map;
import org.rhq.core.clientapi.server.core.CoreServerService;
import org.rhq.core.domain.resource.Agent;
import org.rhq.enterprise.communications.command.Command;
import org.rhq.enterprise.communications.command.impl.remotepojo.RemotePojoInvocationCommand;
import org.rhq.enterprise.communications.command.server.CommandAuthenticator;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class SecurityTokenCommandAuthenticator
implements CommandAuthenticator {
    private static final String CMDCONFIG_PROP_SECURITY_TOKEN = "rhq.security-token";
    private static final Map<String, Long> TOKENS_CACHE = new Hashtable<String, Long>();
    private static final long TOKENS_CACHE_TIMEOUT = 300000L;
    private static final String REGISTER_SERVICE_INTERFACE = CoreServerService.class.getName();
    private static final String REGISTER_COMMAND_TYPE_NAME = RemotePojoInvocationCommand.COMMAND_TYPE.getName();
    private AgentManagerLocal m_agentManager;

    @Override
    public boolean isAuthenticated(Command command) {
        String security_token = command.getConfiguration().getProperty(CMDCONFIG_PROP_SECURITY_TOKEN);
        if (security_token == null) {
            return this.isRegisterCommand(command);
        }
        long now = System.currentTimeMillis();
        Long timestamp = TOKENS_CACHE.get(security_token);
        if (timestamp == null || timestamp + 300000L < now) {
            try {
                AgentManagerLocal agentManager = this.getAgentManager();
                Agent agent = agentManager.getAgentByAgentToken(security_token);
                if (agent == null) {
                    throw new NullPointerException();
                }
                TOKENS_CACHE.put(security_token, new Long(now));
                agentManager.agentIsAlive(agent);
            }
            catch (Exception e) {
                TOKENS_CACHE.remove(security_token);
                return false;
            }
        }
        return true;
    }

    private boolean isRegisterCommand(Command command) {
        String method_name;
        RemotePojoInvocationCommand remote_cmd;
        String iface_name;
        return REGISTER_COMMAND_TYPE_NAME.equals(command.getCommandType().getName()) && REGISTER_SERVICE_INTERFACE.equals(iface_name = (remote_cmd = (RemotePojoInvocationCommand)command).getTargetInterfaceName()) && "registerAgent".equals(method_name = remote_cmd.getNameBasedInvocation().getMethodName());
    }

    private AgentManagerLocal getAgentManager() throws Exception {
        if (this.m_agentManager == null) {
            this.m_agentManager = LookupUtil.getAgentManager();
        }
        return this.m_agentManager;
    }
}

