/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest.reporting;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.composite.ResourceInstallCount;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.util.StringUtil;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.rest.AbstractRestBean;
import org.rhq.enterprise.server.rest.ReportsInterceptor;
import org.rhq.enterprise.server.rest.reporting.CsvWriter;
import org.rhq.enterprise.server.rest.reporting.InventorySummaryLocal;
import org.rhq.enterprise.server.rest.reporting.PropertyConverter;
import org.rhq.enterprise.server.rest.reporting.ReportFormatHelper;
import org.rhq.enterprise.server.util.CriteriaQuery;
import org.rhq.enterprise.server.util.CriteriaQueryExecutor;

@Interceptors(value={ReportsInterceptor.class})
@Stateless
public class InventorySummaryHandler
extends AbstractRestBean
implements InventorySummaryLocal {
    private final Log log = LogFactory.getLog(this.getClass());
    @EJB
    protected ResourceManagerLocal resourceMgr;

    @Override
    public StreamingOutput generateReport(final HttpServletRequest request, final String resourceTypeId, final String version) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Received request to generate " + this.getDebugReportName() + " report for " + this.caller));
        }
        final List<ResourceInstallCount> results = this.getSummaryCounts();
        if (StringUtil.isEmpty((String)resourceTypeId)) {
            return new StreamingOutput(){

                public void write(OutputStream stream) throws IOException, WebApplicationException {
                    if (InventorySummaryHandler.this.log.isDebugEnabled()) {
                        InventorySummaryHandler.this.log.debug((Object)"Generating inventory summary CSV report for resource types.");
                    }
                    CsvWriter<ResourceInstallCount> csvWriter = new CsvWriter<ResourceInstallCount>();
                    List<String> columns = InventorySummaryHandler.this.getColumns();
                    csvWriter.setColumns(columns.toArray(new String[columns.size()]));
                    stream.write((InventorySummaryHandler.this.getHeader() + "\n").getBytes());
                    for (ResourceInstallCount installCount : results) {
                        csvWriter.write(installCount, stream);
                    }
                }
            };
        }
        return new StreamingOutput(){

            public void write(OutputStream stream) throws IOException, WebApplicationException {
                if (InventorySummaryHandler.this.log.isDebugEnabled()) {
                    InventorySummaryHandler.this.log.debug((Object)("Generating detailed inventory summary CSV report for [resourceTypeId: " + resourceTypeId + ", version: " + version + "]"));
                }
                ResourceCriteria criteria = InventorySummaryHandler.this.getDetailsQueryCriteria(Integer.parseInt(resourceTypeId), version);
                CriteriaQueryExecutor<Resource, ResourceCriteria> queryExecutor = new CriteriaQueryExecutor<Resource, ResourceCriteria>(){

                    @Override
                    public PageList<Resource> execute(ResourceCriteria criteria) {
                        return InventorySummaryHandler.this.resourceMgr.findResourcesByCriteria(InventorySummaryHandler.this.caller, criteria);
                    }
                };
                CriteriaQuery<Resource, ResourceCriteria> query = new CriteriaQuery<Resource, ResourceCriteria>(criteria, queryExecutor);
                CsvWriter<Resource> csvWriter = new CsvWriter<Resource>();
                List<String> columns = InventorySummaryHandler.this.getDetailsColumns();
                csvWriter.setColumns(columns.toArray(new String[columns.size()]));
                LinkedHashMap<String, PropertyConverter<Resource>> propertyConverters = InventorySummaryHandler.this.getPropertyConverters(request);
                for (String property : propertyConverters.keySet()) {
                    csvWriter.setPropertyConverter(property, (PropertyConverter)propertyConverters.get(property));
                }
                stream.write((InventorySummaryHandler.this.getDetailsHeader() + "\n").getBytes());
                for (Resource resource : query) {
                    csvWriter.write(resource, stream);
                }
            }
        };
    }

    protected String getDebugReportName() {
        return "inventory summary";
    }

    protected List<String> getColumns() {
        ArrayList<String> columns = new ArrayList<String>(20);
        Collections.addAll(columns, "typeName", "typePlugin", "category.displayName", "version", "count");
        return columns;
    }

    protected List<String> getDetailsColumns() {
        ArrayList<String> columns = new ArrayList<String>(10);
        Collections.addAll(columns, "resourceType.name", "resourceType.plugin", "resourceType.category.displayName", "version", "name", "ancestry", "description", "currentAvailability.availabilityType", "detailsURL");
        return columns;
    }

    protected ResourceCriteria getDetailsQueryCriteria(Integer resourceTypeId, String version) {
        ResourceCriteria criteria = new ResourceCriteria();
        criteria.addFilterResourceTypeId(resourceTypeId);
        criteria.addFilterVersion(version);
        criteria.addFilterInventoryStatus(InventoryStatus.COMMITTED);
        criteria.addSortResourceCategory(PageOrdering.ASC);
        criteria.addSortPluginName(PageOrdering.ASC);
        criteria.addSortResourceTypeName(PageOrdering.ASC);
        return criteria;
    }

    protected List<ResourceInstallCount> getSummaryCounts() {
        return this.resourceMgr.findResourceInstallCounts(this.caller, true);
    }

    protected String getHeader() {
        return "Resource Type,Plugin,Category,Version,Count";
    }

    protected String getDetailsHeader() {
        return "Resource Type,Plugin,Category,Version,Name,Ancestry,Description,Availability,Details URL";
    }

    protected LinkedHashMap<String, PropertyConverter<Resource>> getPropertyConverters(final HttpServletRequest request) {
        LinkedHashMap<String, PropertyConverter<Resource>> propertyConverters = new LinkedHashMap<String, PropertyConverter<Resource>>();
        propertyConverters.put("ancestry", new PropertyConverter<Resource>(){

            @Override
            public Object convert(Resource resource, String propertyName) {
                return ReportFormatHelper.parseAncestry(resource.getAncestry());
            }
        });
        propertyConverters.put("detailsURL", new PropertyConverter<Resource>(){

            @Override
            public Object convert(Resource resource, String propertyName) {
                return InventorySummaryHandler.this.getDetailsURL(resource, request);
            }
        });
        return propertyConverters;
    }

    private String getDetailsURL(Resource resource, HttpServletRequest request) {
        String protocol = request.isSecure() ? "https" : "http";
        return protocol + "://" + request.getServerName() + ":" + request.getServerPort() + "/coregui/#Resource/" + resource.getId();
    }
}

