/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.sync.exporters;

import java.util.Arrays;
import java.util.Iterator;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.rhq.enterprise.server.sync.ExportWriter;
import org.rhq.enterprise.server.sync.exporters.AbstractDelegatingExportingIterator;

public abstract class JAXBExportingIterator<T, E>
extends AbstractDelegatingExportingIterator<T, E> {
    private Marshaller marshaller;

    public JAXBExportingIterator(Iterator<E> sourceIterator, Class<?> ... jaxbBoundClasses) {
        super(sourceIterator);
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])jaxbBoundClasses);
            this.marshaller = context.createMarshaller();
            this.marshaller.setProperty("jaxb.fragment", (Object)true);
            this.marshaller.setProperty("jaxb.formatted.output", (Object)true);
            this.marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Could not create JAXB serializer for classes " + Arrays.asList(jaxbBoundClasses), e);
        }
    }

    @Override
    public void export(ExportWriter output) throws XMLStreamException {
        try {
            this.marshaller.marshal(this.getCurrent(), (XMLStreamWriter)output);
        }
        catch (JAXBException e) {
            throw new XMLStreamException("Failed to export an entity.", e);
        }
    }
}

