isc.DataSource.create({
    ID:"JVMClassTreeDS",
    fields:[
        {
            name:"name"
        },
        {
            name:"path",
            primaryKey:true
        },
        {
            foreignKey:"JVMClassTreeDS.path",
            hidden:true,
            name:"parentID"
        },
        {
            name:"isFolder",
            type:"boolean"
        }
    ],
    operationBindings:[
        {
            language:"groovy",
            operationType:"fetch",
            script:"\n            if (!com.isomorphic.auth.DevModeAuthFilter.devModeAuthorized(request)) throw new Exception(\"Not Authorized\");\n\n            def namespace = criteria.parentID;\n            def classLoader = Thread.currentThread().getContextClassLoader();\n\n            if (namespace == null) {\n                return classLoader.getPackages().collect{it.name}.collect{\n                    def dotIndex = it.indexOf(\".\");\n                    dotIndex != -1 ? it.substring(0, dotIndex) : it;\n                }.unique().sort().collect{\n                    [name: it, path: it, parentID: namespace];\n                }\n            }\n\n            // non-root\n            def namespaces = classLoader.getPackages().collect{it.name}.findAll{ it.startsWith(namespace+\".\") }.collect{ it.substring(namespace.length()+1) }.collect{\n                def dotIndex = it.indexOf(\".\");\n                dotIndex != -1 ? it.substring(0, dotIndex) : it;\n            }.unique().sort().collect{\n                [name: it, path: namespace+\".\"+it, parentID: namespace];\n            };\n\n            // lookup classes for this namespace...\n            def resources = classLoader.getResources(namespace.replace('.', '/'));\n            def resource = resources.hasMoreElements() ? resources.nextElement() : null;\n            def children;\n            def url;\n            if (resource) {\n                url = resource.getFile();\n                log.warn(url);\n                if (url.startsWith(\"jar:\")) {\n            \n                } else {\n                    try {\n                        def file = new File(url);\n                        children = file.list().findAll{ it =~ /\\.class$/}.sort().collect{ \n                            def name = it.substring(0, it.length()-6);\n                            [name:name,path:namespace+\".\"+name,parentID:namespace,isFolder:false] \n                        };\n                    } catch (ignore) {}\n                }\n            }\n\n            namespaces?.addAll(children?:[]);\n            return namespaces;\n    	"
        }
    ]
})
