/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.xmlschema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.metadata.ConfigurationMetadataParser;
import org.rhq.core.clientapi.agent.metadata.InvalidPluginDescriptorException;
import org.rhq.core.clientapi.descriptor.configuration.ConfigurationDescriptor;
import org.rhq.core.clientapi.descriptor.configuration.ConfigurationProperty;
import org.rhq.core.clientapi.descriptor.configuration.ListProperty;
import org.rhq.core.clientapi.descriptor.configuration.MapProperty;
import org.rhq.core.clientapi.descriptor.configuration.MeasurementUnitsDescriptor;
import org.rhq.core.clientapi.descriptor.configuration.Option;
import org.rhq.core.clientapi.descriptor.configuration.PropertyOptions;
import org.rhq.core.clientapi.descriptor.configuration.PropertyType;
import org.rhq.core.clientapi.descriptor.configuration.SimpleProperty;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionEnumeration;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertySimpleType;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.enterprise.server.xmlschema.generated.configuration.instance.ComplexValueDescriptor;
import org.rhq.enterprise.server.xmlschema.generated.configuration.instance.ComplexValueListDescriptor;
import org.rhq.enterprise.server.xmlschema.generated.configuration.instance.ComplexValueMapDescriptor;
import org.rhq.enterprise.server.xmlschema.generated.configuration.instance.ComplexValueSimpleDescriptor;
import org.rhq.enterprise.server.xmlschema.generated.configuration.instance.ConfigurationInstanceDescriptor;
import org.rhq.enterprise.server.xmlschema.generated.configuration.instance.ListPropertyInstanceDescriptor;
import org.rhq.enterprise.server.xmlschema.generated.configuration.instance.MapPropertyInstanceDescriptor;
import org.rhq.enterprise.server.xmlschema.generated.configuration.instance.PropertyValuesDescriptor;
import org.rhq.enterprise.server.xmlschema.generated.configuration.instance.SimplePropertyInstanceDescriptor;

public class ConfigurationInstanceDescriptorUtil {
    public static final String NS_CONFIGURATION_INSTANCE = "urn:xmlns:rhq-configuration-instance";
    public static final String NS_CONFIGURATION = "urn:xmlns:rhq-configuration";
    private static final Log LOG = LogFactory.getLog(ConfigurationInstanceDescriptorUtil.class);

    private ConfigurationInstanceDescriptorUtil() {
    }

    protected static QName getTagName(ConfigurationProperty descriptor) {
        if (descriptor instanceof SimplePropertyInstanceDescriptor) {
            return new QName(NS_CONFIGURATION_INSTANCE, "simple-property");
        }
        if (descriptor instanceof ListPropertyInstanceDescriptor) {
            return new QName(NS_CONFIGURATION_INSTANCE, "list-property");
        }
        if (descriptor instanceof MapPropertyInstanceDescriptor) {
            return new QName(NS_CONFIGURATION_INSTANCE, "map-property");
        }
        if (descriptor instanceof SimpleProperty) {
            return new QName(NS_CONFIGURATION, "simple-property");
        }
        if (descriptor instanceof ListProperty) {
            return new QName(NS_CONFIGURATION, "list-property");
        }
        if (descriptor instanceof MapProperty) {
            return new QName(NS_CONFIGURATION, "map-property");
        }
        throw new IllegalArgumentException("Unknown descriptor type: " + descriptor.getClass());
    }

    private static QName getTagName(ComplexValueDescriptor value) {
        if (value instanceof ComplexValueSimpleDescriptor) {
            return new QName(NS_CONFIGURATION_INSTANCE, "simple-value");
        }
        if (value instanceof ComplexValueListDescriptor) {
            return new QName(NS_CONFIGURATION_INSTANCE, "list-value");
        }
        if (value instanceof ComplexValueMapDescriptor) {
            return new QName(NS_CONFIGURATION_INSTANCE, "map-value");
        }
        throw new IllegalArgumentException("Unknown value descriptor type: " + value.getClass());
    }

    public static ConfigurationInstanceDescriptor createConfigurationInstance(ConfigurationDefinition definition, Configuration configuration) {
        return ToDescriptor.createConfigurationInstance(definition, configuration);
    }

    public static ConfigurationAndDefinition createConfigurationAndDefinition(ConfigurationInstanceDescriptor descriptor) {
        return ToConfigurationAndDefinition.createConfigurationAndDefinition(descriptor);
    }

    private static class ToConfigurationAndDefinition {
        private ToConfigurationAndDefinition() {
        }

        public static ConfigurationAndDefinition createConfigurationAndDefinition(ConfigurationInstanceDescriptor descriptor) {
            ConfigurationAndDefinition ret = new ConfigurationAndDefinition();
            Configuration configuration = new Configuration();
            ConfigurationDefinition definition = new ConfigurationDefinition(null, null);
            ret.configuration = configuration;
            ret.definition = definition;
            for (JAXBElement<?> el : descriptor.getConfigurationProperty()) {
                Object childDescriptor = el.getValue();
                ToConfigurationAndDefinition.add(definition, configuration, null, null, childDescriptor);
            }
            return ret;
        }

        private static void add(ConfigurationDefinition configurationDefinition, Configuration configuration, PropertyDefinition parentDef, Property parentProp, Object propertyInstance) {
            PropertySimple prop = null;
            PropertyDefinition def = null;
            if (propertyInstance instanceof SimplePropertyInstanceDescriptor) {
                PropertySimple simpleProp;
                def = ToConfigurationAndDefinition.convert((ConfigurationProperty)propertyInstance);
                def.setConfigurationDefinition(configurationDefinition);
                SimplePropertyInstanceDescriptor simpleInstance = (SimplePropertyInstanceDescriptor)((Object)propertyInstance);
                prop = simpleProp = new PropertySimple(simpleInstance.getName(), (Object)simpleInstance.getValue());
            } else if (propertyInstance instanceof ListPropertyInstanceDescriptor) {
                def = ToConfigurationAndDefinition.convert((ConfigurationProperty)propertyInstance);
                def.setConfigurationDefinition(configurationDefinition);
                ListPropertyInstanceDescriptor listInstance = (ListPropertyInstanceDescriptor)((Object)propertyInstance);
                PropertyList listProp = new PropertyList(listInstance.getName());
                PropertyDefinition memberDefinition = ((PropertyDefinitionList)def).getMemberDefinition();
                if (listInstance.getValues() != null) {
                    for (JAXBElement<?> val : listInstance.getValues().getComplexValue()) {
                        ComplexValueDescriptor valDesc = (ComplexValueDescriptor)val.getValue();
                        Property child = ToConfigurationAndDefinition.convert(memberDefinition, valDesc);
                        listProp.add(child);
                    }
                }
                prop = listProp;
            } else if (propertyInstance instanceof MapPropertyInstanceDescriptor) {
                def = ToConfigurationAndDefinition.convert((ConfigurationProperty)propertyInstance);
                def.setConfigurationDefinition(configurationDefinition);
                MapPropertyInstanceDescriptor mapInstance = (MapPropertyInstanceDescriptor)((Object)propertyInstance);
                PropertyMap mapProp = new PropertyMap(mapInstance.getName());
                if (mapInstance.getValues() != null) {
                    for (JAXBElement<?> val : mapInstance.getValues().getComplexValue()) {
                        ComplexValueDescriptor valueDesc = (ComplexValueDescriptor)val.getValue();
                        PropertyDefinition valueDefinition = ((PropertyDefinitionMap)def).get(valueDesc.getPropertyName());
                        Property child = ToConfigurationAndDefinition.convert(valueDefinition, valueDesc);
                        mapProp.put(child);
                    }
                }
                prop = mapProp;
            } else {
                throw new IllegalArgumentException("Unsupported property instance type: " + propertyInstance.getClass());
            }
            if (parentDef != null) {
                if (parentDef instanceof PropertyDefinitionList) {
                    def.setParentPropertyListDefinition((PropertyDefinitionList)parentDef);
                } else if (parentDef instanceof PropertyDefinitionMap) {
                    def.setParentPropertyMapDefinition((PropertyDefinitionMap)parentDef);
                }
            } else {
                configurationDefinition.put(def);
            }
            prop.setConfiguration(configuration);
            if (parentProp != null) {
                if (parentProp instanceof PropertyList) {
                    prop.setParentList((PropertyList)parentProp);
                } else if (parentProp instanceof PropertyMap) {
                    prop.setParentMap((PropertyMap)parentProp);
                }
            } else {
                configuration.put((Property)prop);
            }
        }

        private static PropertyDefinition convert(ConfigurationProperty def) {
            try {
                ConfigurationDescriptor tmp = new ConfigurationDescriptor();
                tmp.getConfigurationProperty().add(new JAXBElement(ConfigurationInstanceDescriptorUtil.getTagName(def), ConfigurationProperty.class, (Object)def));
                ConfigurationDefinition configDef = ConfigurationMetadataParser.parse(null, (ConfigurationDescriptor)tmp);
                return (PropertyDefinition)configDef.getPropertyDefinitions().values().iterator().next();
            }
            catch (InvalidPluginDescriptorException e) {
                throw new IllegalArgumentException(e);
            }
        }

        private static Property convert(PropertyDefinition definition, ComplexValueDescriptor value) {
            PropertySimple ret = null;
            if (value instanceof ComplexValueSimpleDescriptor) {
                ret = new PropertySimple(value.getPropertyName(), (Object)((ComplexValueSimpleDescriptor)value).getValue());
            } else if (value instanceof ComplexValueListDescriptor) {
                ComplexValueListDescriptor listValue = (ComplexValueListDescriptor)value;
                PropertyDefinitionList listDefinition = (PropertyDefinitionList)definition;
                PropertyList list = new PropertyList(value.getPropertyName());
                for (JAXBElement<?> val : listValue.getComplexValue()) {
                    Property child = ToConfigurationAndDefinition.convert(listDefinition.getMemberDefinition(), (ComplexValueDescriptor)val.getValue());
                    list.add(child);
                }
                ret = list;
            } else if (value instanceof ComplexValueMapDescriptor) {
                ComplexValueMapDescriptor mapValue = (ComplexValueMapDescriptor)value;
                PropertyMap map = new PropertyMap(value.getPropertyName());
                PropertyDefinitionMap mapDefinition = (PropertyDefinitionMap)definition;
                for (JAXBElement<?> val : mapValue.getComplexValue()) {
                    ComplexValueDescriptor childDesc = (ComplexValueDescriptor)val.getValue();
                    PropertyDefinition childDefinition = mapDefinition.get(childDesc.getPropertyName());
                    Property child = ToConfigurationAndDefinition.convert(childDefinition, childDesc);
                    map.put(child);
                }
                ret = map;
            }
            if (ret.getName() == null) {
                ret.setName(definition.getName());
            }
            return ret;
        }
    }

    private static class ToDescriptor {
        private ToDescriptor() {
        }

        public static ConfigurationInstanceDescriptor createConfigurationInstance(ConfigurationDefinition definition, Configuration configuration) {
            ConfigurationInstanceDescriptor ret = new ConfigurationInstanceDescriptor();
            ToDescriptor.addAll(ret.getConfigurationProperty(), definition.getPropertyDefinitions(), configuration.getMap());
            return ret;
        }

        private static void addAll(List<JAXBElement<?>> descriptors, Map<String, PropertyDefinition> defs, Map<String, Property> props) {
            for (Map.Entry<String, PropertyDefinition> e : defs.entrySet()) {
                String propName = e.getKey();
                PropertyDefinition def = e.getValue();
                Property prop = props.get(propName);
                ToDescriptor.addSingle(descriptors, def, prop);
            }
        }

        private static void addSingle(List<JAXBElement<?>> descriptors, PropertyDefinition def, Property prop) {
            ConfigurationProperty descriptor = null;
            QName tagName = null;
            descriptor = ToDescriptor.createDescriptor(def, prop);
            tagName = ConfigurationInstanceDescriptorUtil.getTagName(descriptor);
            ToDescriptor.addToJAXBElementList(descriptors, Object.class, descriptor, tagName);
        }

        private static ConfigurationProperty createDescriptor(PropertyDefinition def, Property prop) {
            Object ret = null;
            if (def instanceof PropertyDefinitionSimple) {
                ret = ToDescriptor.createSimple((PropertyDefinitionSimple)def, (PropertySimple)prop);
            } else if (def instanceof PropertyDefinitionList) {
                ret = ToDescriptor.createList((PropertyDefinitionList)def, (PropertyList)prop);
            } else if (def instanceof PropertyDefinitionMap) {
                ret = ToDescriptor.createMap((PropertyDefinitionMap)def, (PropertyMap)prop);
            }
            return ret;
        }

        private static SimplePropertyInstanceDescriptor createSimple(PropertyDefinitionSimple def, PropertySimple prop) {
            SimplePropertyInstanceDescriptor ret = new SimplePropertyInstanceDescriptor();
            ToDescriptor.setCommonProps((ConfigurationProperty)ret, (PropertyDefinition)def, true);
            ret.setPropertyOptions(ToDescriptor.convert(def.getEnumeratedValues()));
            ret.setType(ToDescriptor.convert(def.getType()));
            ret.setUnits(ToDescriptor.convert(def.getUnits()));
            if (prop != null) {
                ret.setValue(prop.getStringValue());
            }
            return ret;
        }

        private static ListPropertyInstanceDescriptor createList(PropertyDefinitionList def, PropertyList prop) {
            ListPropertyInstanceDescriptor ret = new ListPropertyInstanceDescriptor();
            ToDescriptor.setCommonProps((ConfigurationProperty)ret, (PropertyDefinition)def, true);
            ConfigurationProperty memberDef = ToDescriptor.convertDefinition(def.getMemberDefinition());
            ret.setConfigurationProperty(new JAXBElement(ConfigurationInstanceDescriptorUtil.getTagName(memberDef), ConfigurationProperty.class, (Object)memberDef));
            if (prop != null) {
                PropertyValuesDescriptor values = new PropertyValuesDescriptor();
                ret.setValues(values);
                for (Property el : prop.getList()) {
                    ComplexValueDescriptor value = ToDescriptor.convertValue(el);
                    value.setPropertyName(null);
                    ToDescriptor.addToJAXBElementList(values.getComplexValue(), Object.class, value, ConfigurationInstanceDescriptorUtil.getTagName(value));
                }
            }
            return ret;
        }

        private static MapPropertyInstanceDescriptor createMap(PropertyDefinitionMap def, PropertyMap prop) {
            MapPropertyInstanceDescriptor ret = new MapPropertyInstanceDescriptor();
            ToDescriptor.setCommonProps((ConfigurationProperty)ret, (PropertyDefinition)def, true);
            for (PropertyDefinition mem : def.getPropertyDefinitions().values()) {
                ConfigurationProperty memDef = ToDescriptor.convertDefinition(mem);
                ToDescriptor.addToJAXBElementList(ret.getConfigurationProperty(), ConfigurationProperty.class, memDef, ConfigurationInstanceDescriptorUtil.getTagName(memDef));
            }
            if (prop != null) {
                PropertyValuesDescriptor values = new PropertyValuesDescriptor();
                ret.setValues(values);
                for (Property el : prop.getMap().values()) {
                    ComplexValueDescriptor value = ToDescriptor.convertValue(el);
                    ToDescriptor.addToJAXBElementList(values.getComplexValue(), Object.class, value, ConfigurationInstanceDescriptorUtil.getTagName(value));
                }
            }
            return ret;
        }

        private static void setCommonProps(ConfigurationProperty target, PropertyDefinition source, boolean creatingInstance) {
            target.setName(source.getName());
            target.setLongDescription(source.getDescription());
            target.setDisplayName(source.getDisplayName());
            if (!creatingInstance) {
                target.setRequired(Boolean.valueOf(source.isRequired()));
                target.setReadOnly(Boolean.valueOf(source.isReadOnly()));
                target.setSummary(Boolean.valueOf(source.isSummary()));
            }
        }

        private static PropertyOptions convert(List<PropertyDefinitionEnumeration> options) {
            if (options.isEmpty()) {
                return null;
            }
            PropertyOptions ret = new PropertyOptions();
            ArrayList<PropertyDefinitionEnumeration> opts = new ArrayList<PropertyDefinitionEnumeration>(options);
            Collections.sort(opts, new Comparator<PropertyDefinitionEnumeration>(){

                @Override
                public int compare(PropertyDefinitionEnumeration o1, PropertyDefinitionEnumeration o2) {
                    return o1.getOrderIndex() - o2.getOrderIndex();
                }
            });
            for (PropertyDefinitionEnumeration option : opts) {
                ret.getOption().add(ToDescriptor.convert(option));
            }
            return ret;
        }

        private static Option convert(PropertyDefinitionEnumeration option) {
            Option ret = new Option();
            ret.setName(option.getName());
            ret.setValue(option.getValue());
            return ret;
        }

        private static PropertyType convert(PropertySimpleType type) {
            if (type == null) {
                return null;
            }
            try {
                return PropertyType.valueOf((String)type.name());
            }
            catch (IllegalArgumentException e) {
                LOG.warn((Object)("Failed to convert a PropertySimpleType instance '" + type.name() + "' into a PropertyType."), (Throwable)e);
                throw e;
            }
        }

        private static MeasurementUnitsDescriptor convert(MeasurementUnits unit) {
            if (unit == null) {
                return null;
            }
            String value = unit.name();
            try {
                return MeasurementUnitsDescriptor.valueOf((String)value);
            }
            catch (IllegalArgumentException e) {
                LOG.warn((Object)("Failed to convert a MeasurementUnits instance '" + unit.getName() + "' into a MeasurementUnitsDescriptor."), (Throwable)e);
                throw e;
            }
        }

        private static ConfigurationProperty convertDefinition(PropertyDefinition def) {
            if (def instanceof PropertyDefinitionSimple) {
                return ToDescriptor.convertSimple((PropertyDefinitionSimple)def);
            }
            if (def instanceof PropertyDefinitionList) {
                return ToDescriptor.convertList((PropertyDefinitionList)def);
            }
            if (def instanceof PropertyDefinitionMap) {
                return ToDescriptor.convertMap((PropertyDefinitionMap)def);
            }
            throw new IllegalArgumentException("Unsupported property definition type: " + def.getClass());
        }

        private static SimpleProperty convertSimple(PropertyDefinitionSimple def) {
            SimpleProperty ret = new SimpleProperty();
            ToDescriptor.setCommonProps((ConfigurationProperty)ret, (PropertyDefinition)def, false);
            ret.setDefaultValue(def.getDefaultValue());
            ret.setPropertyOptions(ToDescriptor.convert(def.getEnumeratedValues()));
            ret.setType(ToDescriptor.convert(def.getType()));
            ret.setUnits(ToDescriptor.convert(def.getUnits()));
            return ret;
        }

        private static ListProperty convertList(PropertyDefinitionList def) {
            ListProperty ret = new ListProperty();
            ToDescriptor.setCommonProps((ConfigurationProperty)ret, (PropertyDefinition)def, false);
            ConfigurationProperty memberDefinition = ToDescriptor.convertDefinition(def.getMemberDefinition());
            ret.setConfigurationProperty(new JAXBElement(ConfigurationInstanceDescriptorUtil.getTagName(memberDefinition), ConfigurationProperty.class, (Object)memberDefinition));
            return ret;
        }

        private static MapProperty convertMap(PropertyDefinitionMap def) {
            MapProperty ret = new MapProperty();
            ToDescriptor.setCommonProps((ConfigurationProperty)ret, (PropertyDefinition)def, false);
            List elements = ret.getConfigurationProperty();
            for (PropertyDefinition el : def.getPropertyDefinitions().values()) {
                ConfigurationProperty prop = ToDescriptor.convertDefinition(el);
                QName tagName = ConfigurationInstanceDescriptorUtil.getTagName(prop);
                ToDescriptor.addToJAXBElementList(elements, ConfigurationProperty.class, prop, tagName);
            }
            return ret;
        }

        private static ComplexValueDescriptor convertValue(Property prop) {
            if (prop instanceof PropertySimple) {
                return ToDescriptor.convertSimpleValue((PropertySimple)prop);
            }
            if (prop instanceof PropertyList) {
                return ToDescriptor.convertListValue((PropertyList)prop);
            }
            if (prop instanceof PropertyMap) {
                return ToDescriptor.convertMapValue((PropertyMap)prop);
            }
            throw new IllegalArgumentException("Unsupported property type to convert to a value descriptor: " + prop.getClass());
        }

        private static ComplexValueSimpleDescriptor convertSimpleValue(PropertySimple prop) {
            ComplexValueSimpleDescriptor ret = new ComplexValueSimpleDescriptor();
            ret.setPropertyName(prop.getName());
            ret.setValue(prop.getStringValue());
            return ret;
        }

        private static ComplexValueListDescriptor convertListValue(PropertyList prop) {
            ComplexValueListDescriptor ret = new ComplexValueListDescriptor();
            ret.setPropertyName(prop.getName());
            for (Property el : prop.getList()) {
                ComplexValueDescriptor value = ToDescriptor.convertValue(el);
                ToDescriptor.addToJAXBElementList(ret.getComplexValue(), Object.class, value, ConfigurationInstanceDescriptorUtil.getTagName(value));
            }
            return ret;
        }

        private static ComplexValueMapDescriptor convertMapValue(PropertyMap prop) {
            ComplexValueMapDescriptor ret = new ComplexValueMapDescriptor();
            ret.setPropertyName(prop.getName());
            for (Property el : prop.getMap().values()) {
                ComplexValueDescriptor value = ToDescriptor.convertValue(el);
                ToDescriptor.addToJAXBElementList(ret.getComplexValue(), Object.class, value, ConfigurationInstanceDescriptorUtil.getTagName(value));
            }
            return ret;
        }

        private static <T> void addToJAXBElementList(List<JAXBElement<? extends T>> list, Class<T> baseClass, T property, QName tagName) {
            JAXBElement el = new JAXBElement(tagName, baseClass, property);
            list.add(el);
        }
    }

    public static class ConfigurationAndDefinition {
        public Configuration configuration;
        public ConfigurationDefinition definition;
    }
}

